/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import com.ats.recorder.TestError;
import com.ats.script.Project;
import com.ats.script.actions.ActionApi;
import com.ats.script.actions.ActionCallscript;
import com.ats.script.actions.ActionComment;
import com.ats.tools.ResourceContent;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.Constants;
import com.ats.tools.report.SuitesReportItem;
import com.ats.tools.report.XmlReport;
import com.ats.tools.report.actions.HtmlReportAction;
import com.ats.tools.report.analytics.ActionTypesEnum;
import com.ats.tools.report.general.HtmlReport;
import com.ats.tools.report.general.HtmlReportExecution;
import com.ats.tools.report.general.HtmlReportPlaylist;
import com.ats.tools.report.general.HtmlReportTestInfo;
import com.ats.tools.report.models.Action;
import com.ats.tools.report.models.ActionElement;
import com.ats.tools.report.models.AppDataJson;
import com.ats.tools.report.models.Bound;
import com.ats.tools.report.models.Channel;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.Image;
import com.ats.tools.report.models.Results;
import com.ats.tools.report.models.Script;
import com.ats.tools.report.models.Suite;
import com.ats.tools.report.models.SuiteInfo;
import com.ats.tools.report.models.Summary;
import com.ats.tools.report.models.TestInfo;
import com.ats.tools.report.utils.AtsReportXmlGenerator;
import com.ats.tools.report.utils.FileUtils;
import com.ats.tools.report.utils.HtmlSummaryGenerator;
import com.ctc.wstx.stax.WstxInputFactory;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.collections4.CollectionUtils;

public class HtmlCampaignReportGenerator {
    private final Path outputFolderPath;
    private final File jsonSuiteFilesFile;
    private final int devReportLevel;
    private final int validReportLevel;
    private final SuitesReportItem suiteItem;
    private final boolean isValidationReport;
    private static final String styles = ResourceContent.getHtmlReportCss();
    private static final String javascript = ResourceContent.getHtmlReportJavascript();
    private static final String actionTemplate = ResourceContent.getHtmlReportActionHtmlTemplate();
    private static final String mainTemplate = ResourceContent.getHtmlReportTemplate();
    private static final String playlistTemplate = ResourceContent.getHtmlReportPlaylistTemplate();
    private static final String reportSuiteTemplate = ResourceContent.getHtmlReportSuiteTemplate();
    private static final String mainExecutionTemplate = ResourceContent.getHtmlReportExecutionTemplate();
    private static final String htmlSummaryTemplate = ResourceContent.getHtmlReportSummaryTemplate();
    private AtsReportXmlGenerator atsReportXmlGenerator;
    private Map<String, Integer> testSuiteActionsCount = new HashMap<String, Integer>();
    private HtmlReportPlaylist htmlReportPlaylist;
    private ObjectMapper objectMapper = new ObjectMapper();
    private List<Summary> testSummariesForExecutions;
    private Map<String, Long> testDurations = new HashMap<String, Long>();
    private List<PlaylistData> playlistsDataLst = new ArrayList<PlaylistData>();
    private PlaylistData playlistsDataCurrent = null;

    public HtmlCampaignReportGenerator(Path outputFolderPath, File jsonSuiteFilesFile, int devReportLevel, int validReport, SuitesReportItem suiteItem) {
        this.outputFolderPath = outputFolderPath;
        this.jsonSuiteFilesFile = jsonSuiteFilesFile;
        this.devReportLevel = devReportLevel;
        this.validReportLevel = validReport;
        this.isValidationReport = validReport == 1;
        this.suiteItem = suiteItem;
    }

    public void generateSuitsHtmlReports() throws IOException, XMLStreamException {
        long startTime = System.nanoTime();
        List<Script> scripts = FileUtils.getScripts(this.outputFolderPath.toString());
        HtmlReportProject project = (HtmlReportProject)this.objectMapper.readValue(Files.readString(this.jsonSuiteFilesFile.toPath()), HtmlReportProject.class);
        this.populateProjectLogoAndWatermark(project);
        Results results = (Results)this.objectMapper.readValue(this.outputFolderPath.resolve("ats-results.json").toFile(), Results.class);
        this.atsReportXmlGenerator = new AtsReportXmlGenerator(project, results, scripts, this.devReportLevel, this.outputFolderPath, this.validReportLevel, "ats-report.xml");
        this.testSummariesForExecutions = this.atsReportXmlGenerator.getTestSummariesForExecutionsResult();
        this.updateResultAndScriptsBasedOnTestSummaries(results, scripts);
        this.atsReportXmlGenerator.writeProjectInfo();
        HtmlReportExecution htmlReportExecution = new HtmlReportExecution(mainExecutionTemplate, project, this.outputFolderPath.toString(), this.devReportLevel, this.isValidationReport, this.suiteItem);
        htmlReportExecution.processMainExecutionsFile();
        this.populateSuiteInfo(project, results);
        project.getSuites().forEach(suite -> this.generateHtmlReports((Suite)suite, htmlReportExecution.getFileWriter(), htmlReportExecution.getValidationFileWriter(), project, scripts));
        this.AddDataGraph(this.playlistsDataLst, htmlReportExecution.getFileWriter());
        htmlReportExecution.closeWriter();
        this.atsReportXmlGenerator.writeFileEnd();
        if (!this.suiteItem.isNoSuiteLaunch()) {
            HtmlSummaryGenerator.generateHtmlSummary(htmlSummaryTemplate, project, this.outputFolderPath.toString(), this.devReportLevel, this.testSuiteActionsCount, results, scripts, this.testDurations, this.testSummariesForExecutions);
        }
        AtsLogger.printLog(new StringBuilder("report generated in ").append((System.nanoTime() - startTime) / 1000000000L).append(" second(s)"));
    }

    private void populateSuiteInfo(HtmlReportProject project, Results results) {
        project.getSuites().forEach(suite -> results.getSuites().stream().sorted((o1, o2) -> Math.toIntExact(o2.getStarted() - o1.getStarted())).filter(s -> s.getName().equals(suite.getName())).findFirst().ifPresent(suite::setSuiteInfo));
    }

    private void populateProjectLogoAndWatermark(HtmlReportProject project) {
        project.setProjectLogo(Objects.requireNonNullElse(FileUtils.getBase64ImageProperty(Project.REPORT_LOGO_URL), project.getATS_LOGO()));
        project.setProjectWatermark(FileUtils.getBase64ImageProperty(Project.REPORT_WATERMARK_URL));
    }

    private void updateResultAndScriptsBasedOnTestSummaries(Results results, List<Script> scripts) {
        this.testSummariesForExecutions.stream().filter(summary -> Constants.SummaryStatus.PASS_CONTINUE.getNumericValue().equals(summary.getStatus())).forEach(summary -> {
            List<Script> suiteScripts = scripts.stream().filter(script -> summary.getSuiteName().equals(script.getSuite())).toList();
            suiteScripts.stream().filter(script -> summary.getTestName().equals(script.getName()) && !script.isPassed()).findFirst().ifPresent(script -> script.setPassed(Constants.Status.PASS.getBooleanValue()));
            results.getSuites().stream().filter(suiteInfo -> summary.getSuiteName().equals(suiteInfo.getName())).findFirst().ifPresent(suiteInfo -> {
                Map<Boolean, List<Script>> scriptsByStatus = suiteScripts.stream().collect(Collectors.groupingBy(Script::isPassed));
                suiteInfo.setTestsPassed(CollectionUtils.emptyIfNull((Collection)scriptsByStatus.get(Constants.Status.PASS.getBooleanValue())).size());
                suiteInfo.setTestsFailed(CollectionUtils.emptyIfNull((Collection)scriptsByStatus.get(Constants.Status.FAIL.getBooleanValue())).size());
                suiteInfo.setStatus(suiteInfo.getTestsFailed() > 0 ? Constants.Status.FAIL.getValue() : Constants.Status.PASS.getValue());
            });
        });
        Map<String, List<SuiteInfo>> suitesByStatus = results.getSuites().stream().collect(Collectors.groupingBy(SuiteInfo::getStatus));
        results.setSuitesFailed(CollectionUtils.emptyIfNull((Collection)suitesByStatus.get(Constants.Status.FAIL.getValue())).size());
        results.setSuitesPassed(CollectionUtils.emptyIfNull((Collection)suitesByStatus.get(Constants.Status.PASS.getValue())).size());
        results.setStatus(results.getSuitesFailed() > 0 ? Constants.Status.FAIL.getValue() : Constants.Status.PASS.getValue());
    }

    private void generateHtmlReports(Suite suite, OutputStream fileWriter, OutputStream validationFileWriter, HtmlReportProject project, List<Script> scripts) {
        List<Script> suiteScripts = scripts.stream().filter(script -> script.getSuite().equals(suite.getName())).collect(Collectors.toList());
        String scriptsStatus = suiteScripts.stream().anyMatch(script -> !script.isPassed()) ? Constants.Status.FAIL.getValue() : Constants.Status.PASS.getValue();
        this.playlistsDataCurrent = new PlaylistData(suite.getName());
        this.htmlReportPlaylist = new HtmlReportPlaylist(playlistTemplate, suite, fileWriter, validationFileWriter, project, suiteScripts, this.isValidationReport, this.suiteItem.isNoSuiteLaunch(), scriptsStatus);
        this.htmlReportPlaylist.processPlaylistData();
        this.playlistsDataCurrent.addTest(this.htmlReportPlaylist.getPassed(), this.htmlReportPlaylist.getFailed(), this.htmlReportPlaylist.getFiltered());
        this.playlistsDataCurrent.addDurationInSecond(this.htmlReportPlaylist.getDurationInSecond());
        this.atsReportXmlGenerator.writeSuiteData(suite, scripts);
        suite.getTests().forEach(test -> this.generateHtmlReport(suite.getName(), (String)test));
        this.playlistsDataLst.add(this.playlistsDataCurrent);
        this.atsReportXmlGenerator.writeSuiteEnd();
        this.htmlReportPlaylist.processPlaylistFooter();
    }

    private void generateHtmlReport(String suiteName, String testName) {
        Path targetPath = this.outputFolderPath.resolve(suiteName).resolve(testName + "_xml");
        if (!Files.exists(targetPath, new LinkOption[0])) {
            return;
        }
        HashMap<String, String> appIcons = new HashMap<String, String>();
        boolean creatingObject = false;
        Action action = new Action();
        AppDataJson appDataJson = new AppDataJson();
        ActionElement actionElement = new ActionElement();
        TestInfo testInfo = new TestInfo();
        testInfo.setTestName(testName);
        try {
            System.getProperties().put("javax.xml.stream.XMLInputFactory", InputFactory.class.getName());
            Optional<Summary> first = this.testSummariesForExecutions.stream().filter(summary -> summary.getTestName().equals(testName)).findFirst();
            XMLInputFactory factory = XMLInputFactory.newInstance();
            FileInputStream inputStream = new FileInputStream(targetPath.resolve(XmlReport.REPORT_DATA_FILE).toFile());
            if (first.isPresent()) {
                this.atsReportXmlGenerator.writeScript(targetPath.resolve("actions.xml").toFile(), this.devReportLevel);
            }
            XMLStreamReader reader = factory.createXMLStreamReader(inputStream);
            FileOutputStream outputStream = new FileOutputStream(targetPath.resolve("ats-test-report.html").toFile());
            HtmlReport htmlReport = this.createReportHeader();
            HtmlReportAction htmlReportAction = new HtmlReportAction();
            boolean isTestInfo = false;
            while (reader.hasNext()) {
                int event = reader.next();
                if (event == 7) continue;
                if (event == 1) {
                    if (reader.getLocalName().equals("action")) {
                        isTestInfo = false;
                        action.setIndex(Integer.parseInt(reader.getAttributeValue(0)));
                        String type = reader.getAttributeValue(1).split("\\.")[reader.getAttributeValue(1).split("\\.").length - 1];
                        boolean asSuite = Constants.SummaryStatus.PASS_CONTINUE.getNumericValue().equals(testInfo.getSummary().getStatus());
                        if (asSuite && type.equals("ActionCallscript")) {
                            type = "EndOfRecording";
                        }
                        action.setType(type);
                        creatingObject = true;
                    } else if (!creatingObject && reader.getLocalName().equals("script")) {
                        creatingObject = true;
                        isTestInfo = true;
                    }
                    if (creatingObject) {
                        if (isTestInfo) {
                            switch (reader.getLocalName()) {
                                case "script": {
                                    testInfo.setExternalId(reader.getAttributeValue("", "externalId"));
                                    testInfo.setTestId(reader.getAttributeValue("", "testId"));
                                    testInfo.setOsInfo(reader.getAttributeValue("", "osInfo"));
                                    break;
                                }
                                case "description": {
                                    testInfo.setDescription(reader.getElementText());
                                    break;
                                }
                                case "author": {
                                    testInfo.setAuthor(reader.getElementText());
                                    break;
                                }
                                case "modifiedBy": {
                                    testInfo.setModifiedBy(reader.getElementText());
                                    break;
                                }
                                case "modifiedAt": {
                                    testInfo.setModifiedAt(reader.getElementText());
                                    break;
                                }
                                case "createdAt": {
                                    testInfo.setCreatedAt(reader.getElementText());
                                    break;
                                }
                                case "prerequisite": {
                                    testInfo.setPrerequisite(reader.getElementText());
                                    break;
                                }
                                case "startedFormated": {
                                    testInfo.setStartedFormatted(reader.getElementText());
                                    break;
                                }
                                case "started": {
                                    testInfo.setStarted(reader.getElementText());
                                    break;
                                }
                                case "quality": {
                                    testInfo.setQuality(reader.getElementText());
                                    break;
                                }
                                case "group": {
                                    testInfo.getGroups().add(reader.getElementText());
                                    break;
                                }
                                case "project": {
                                    HtmlReportProject project = new HtmlReportProject();
                                    testInfo.setProject(project);
                                    break;
                                }
                                case "id": {
                                    testInfo.getProject().setProjectId(reader.getElementText());
                                    break;
                                }
                                case "name": {
                                    testInfo.getProject().setProjectName(reader.getElementText());
                                    break;
                                }
                                case "summary": {
                                    Summary summary2 = new Summary(reader);
                                    testInfo.setSummary(summary2);
                                    break;
                                }
                                case "errors": {
                                    testInfo.getSummary().setTestErrors(new ArrayList<TestError>());
                                    break;
                                }
                                case "error": {
                                    Object error = new TestError();
                                    ((TestError)error).setLine(Integer.parseInt(reader.getAttributeValue("", "line")));
                                    ((TestError)error).setScript(reader.getAttributeValue("", "script"));
                                    ((TestError)error).setTestErrorStatus(TestError.TestErrorStatus.valueOf(reader.getAttributeValue("", "testErrorStatus")));
                                    ((TestError)error).setMessage(reader.getElementText());
                                    testInfo.getSummary().getTestErrors().add((TestError)error);
                                    break;
                                }
                                case "data": {
                                    testInfo.getSummary().setData(reader.getElementText());
                                }
                            }
                        }
                        if (!isTestInfo) {
                            block64 : switch (reader.getLocalName()) {
                                case "line": {
                                    action.setLine(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "script": {
                                    action.setScript(reader.getElementText());
                                    break;
                                }
                                case "timeLine": {
                                    action.setTimeLine(Long.parseLong(reader.getElementText()));
                                    break;
                                }
                                case "error": {
                                    action.setError(reader.getElementText());
                                    break;
                                }
                                case "stop": {
                                    action.setStop(Boolean.parseBoolean(reader.getElementText()));
                                    break;
                                }
                                case "duration": {
                                    action.setDuration(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "passed": {
                                    action.setPassed(Boolean.parseBoolean(reader.getElementText()));
                                    break;
                                }
                                case "value": {
                                    action.setValue(reader.getElementText());
                                    break;
                                }
                                case "data": {
                                    if (isTestInfo) {
                                        testInfo.getSummary().setData(reader.getElementText());
                                        break;
                                    }
                                    action.setData(reader.getElementText());
                                    break;
                                }
                                case "parameter": {
                                    if (ActionApi.class.getSimpleName().equals(action.getType()) || ActionCallscript.class.getSimpleName().equals(action.getType())) {
                                        switch (reader.getAttributeCount()) {
                                            case 2: {
                                                appDataJson.getData().put(reader.getAttributeValue(0), reader.getAttributeValue(1));
                                                break block64;
                                            }
                                            case 3: {
                                                appDataJson.getData().put(reader.getAttributeValue(0), reader.getAttributeValue(2));
                                                break block64;
                                            }
                                        }
                                        appDataJson.getData().put(reader.getAttributeValue(0), "\u00d8");
                                        break;
                                    }
                                    switch (reader.getAttributeValue(0)) {
                                        case "name": {
                                            appDataJson.setName(reader.getAttributeValue(1));
                                            action.setAppDataJson(appDataJson);
                                            break;
                                        }
                                        case "app": {
                                            appDataJson.setApp(reader.getAttributeValue(1));
                                            break;
                                        }
                                        case "appVersion": {
                                            appDataJson.setAppVersion(reader.getAttributeValue(1));
                                            break;
                                        }
                                        case "os": {
                                            appDataJson.setOs(reader.getAttributeValue(1));
                                            break;
                                        }
                                        case "appIcon": {
                                            appDataJson.setAppIcon(reader.getAttributeValue(1));
                                            appIcons.put(appDataJson.getApp(), appDataJson.getAppIcon());
                                        }
                                    }
                                    break;
                                }
                                case "img": {
                                    if (reader.getAttributeCount() <= 0) break;
                                    Image image = new Image(reader);
                                    if (image.getType().equals("api")) {
                                        image.useApiIcon();
                                    }
                                    action.setImage(image);
                                    break;
                                }
                                case "channel": {
                                    Channel channel = new Channel();
                                    channel.setName(reader.getAttributeValue(0));
                                    action.setChannel(channel);
                                    break;
                                }
                                case "bound": {
                                    Bound bound = new Bound();
                                    action.getChannel().setBound(bound);
                                    break;
                                }
                                case "x": {
                                    action.getChannel().getBound().setX(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "y": {
                                    action.getChannel().getBound().setY(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "width": {
                                    action.getChannel().getBound().setWidth(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "height": {
                                    action.getChannel().getBound().setHeight(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "element": {
                                    actionElement.setTag(reader.getAttributeValue(0));
                                    break;
                                }
                                case "criterias": {
                                    actionElement.setCriterias(reader.getElementText());
                                    break;
                                }
                                case "foundElements": {
                                    actionElement.setFoundElements(Integer.parseInt(reader.getElementText()));
                                    break;
                                }
                                case "searchDuration": {
                                    actionElement.setSearchDuration(Integer.parseInt(reader.getElementText()));
                                }
                            }
                        }
                    }
                }
                if (event == 2 && reader.getLocalName().equals("script") && isTestInfo) {
                    htmlReport.setMainReport(new HtmlReportTestInfo(testInfo, htmlReport.getMainReport(), null, suiteName, this.suiteItem).getResult());
                    String _actions = testInfo.getSummary().getActions();
                    this.playlistsDataCurrent.addNbTests(Integer.parseInt(_actions));
                    this.testSuiteActionsCount.put(testInfo.getTestName() + "|" + testInfo.getSummary().getSuiteName(), Integer.valueOf(testInfo.getSummary().getActions()));
                    this.testDurations.put(testInfo.getTestName() + "|" + testInfo.getSummary().getSuiteName(), Long.parseLong(testInfo.getSummary().getDuration()));
                    ((OutputStream)outputStream).write(htmlReport.getMainReport().getBytes());
                    this.htmlReportPlaylist.processPlaylistTestInfo(new HtmlReportTestInfo(testInfo, reportSuiteTemplate, targetPath.resolve("ats-test-report.html").toString(), suiteName, this.suiteItem).getResult());
                }
                if (event == 2 && "dataJson".equals(reader.getLocalName())) {
                    action.setAppDataJson(appDataJson);
                    appDataJson = new AppDataJson();
                }
                if (event == 2 && reader.getLocalName().equals("element")) {
                    action.setActionElement(actionElement);
                    actionElement = new ActionElement();
                }
                if (event != 2 || !reader.getLocalName().equals("action")) continue;
                String processedAction = htmlReportAction.processAction(action, appIcons, testInfo, this.devReportLevel);
                ((OutputStream)outputStream).write(processedAction.getBytes());
                this.htmlReportPlaylist.processPlaylistTestAction(processedAction, this.isValidationReport, !ActionComment.class.getSimpleName().equals(action.getType()) && !ActionCallscript.class.getSimpleName().equals(action.getType()));
                htmlReportAction.setActionTemplate(actionTemplate);
                this.playlistsDataCurrent.addAction(action.getType());
                action = new Action();
            }
            ((OutputStream)outputStream).write(htmlReport.getFooter().getBytes());
            this.htmlReportPlaylist.processTestCaseFooter();
            reader.close();
            ((InputStream)inputStream).close();
            ((OutputStream)outputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HtmlReport createReportHeader() {
        return new HtmlReport(mainTemplate, styles, javascript);
    }

    private void AddDataGraph(List<PlaylistData> playlists, OutputStream fileWriter) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String jsonData = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(playlists);
            String baliseJson = "<script type=\"application/json\" id=\"playlist-data\">\n" + jsonData + "\n</script>";
            fileWriter.write(baliseJson.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class PlaylistData {
        private String name;
        @JsonProperty(value="passed")
        private long _passed = 0L;
        @JsonProperty(value="failed")
        private long _failed = 0L;
        @JsonProperty(value="filtered")
        private long _filtered = 0L;
        @JsonProperty(value="nbActions")
        private int _nbActions = 0;
        @JsonProperty(value="durationInSecond")
        private long _durationInSecond;
        private List<ActionData> actionsData;

        public PlaylistData(String name) {
            this.name = name;
            this.actionsData = new ArrayList<ActionData>();
            this.actionsData.add(new ActionData("Navigation", 0));
            this.actionsData.add(new ActionData("Calls", 0));
            this.actionsData.add(new ActionData("UserAction", 0));
            this.actionsData.add(new ActionData("Assertion", 0));
            this.actionsData.add(new ActionData("Technical", 0));
            this.actionsData.add(new ActionData("Others", 0));
        }

        public void addAction(String actionType) {
            String actionName = "";
            switch (ActionTypesEnum.of(actionType)) {
                case NAVIGATION: {
                    actionName = "Navigation";
                    break;
                }
                case CALL_SCRIPT: {
                    actionName = "Calls";
                    break;
                }
                case USER_ACTION: {
                    actionName = "UserAction";
                    break;
                }
                case ASSERT: {
                    actionName = "Assertion";
                    break;
                }
                case TECHNICAL: {
                    actionName = "Technical";
                    break;
                }
                default: {
                    actionName = "Others";
                }
            }
            for (ActionData action : this.actionsData) {
                if (!action.name.equalsIgnoreCase(actionName)) continue;
                ++action.value;
                return;
            }
        }

        public void addTest(long passed, long failed, long filtered) {
            this._passed = passed;
            this._failed = failed;
            this._filtered = filtered;
        }

        public void addNbTests(int nbActions) {
            this._nbActions += nbActions;
        }

        public void addDurationInSecond(long duration) {
            this._durationInSecond = duration;
        }

        public String getName() {
            return this.name;
        }

        public List<ActionData> getActions() {
            return this.actionsData;
        }
    }

    public static class InputFactory
    extends WstxInputFactory {
        public InputFactory() {
            this.setProperty("com.ctc.wstx.maxAttributeSize", Integer.MAX_VALUE);
        }
    }

    private static class ActionData {
        public String name;
        public int value;

        public ActionData(String name, int value) {
            this.name = name;
            this.value = value;
        }
    }
}

