/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.actions;

import com.ats.tools.ResourceContent;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.Constants;
import com.ats.tools.report.actions.HtmlReportActionApi;
import com.ats.tools.report.actions.HtmlReportActionAssert;
import com.ats.tools.report.actions.HtmlReportActionCallScript;
import com.ats.tools.report.actions.HtmlReportActionChannel;
import com.ats.tools.report.actions.HtmlReportActionComment;
import com.ats.tools.report.actions.HtmlReportActionGoToUrl;
import com.ats.tools.report.actions.HtmlReportActionMouse;
import com.ats.tools.report.actions.HtmlReportActionProperty;
import com.ats.tools.report.actions.HtmlReportActionScripting;
import com.ats.tools.report.actions.HtmlReportActionTextAndSelect;
import com.ats.tools.report.actions.HtmlReportActionWindowNew;
import com.ats.tools.report.actions.HtmlReportActionWindowState;
import com.ats.tools.report.actions.HtmlReportActionWindowSwitch;
import com.ats.tools.report.models.Action;
import com.ats.tools.report.models.Image;
import com.ats.tools.report.models.TestInfo;
import com.ats.tools.report.utils.HtmlActionUtils;
import com.ats.tools.report.utils.HtmlReportActionLabel;
import java.util.Map;

public class HtmlReportAction {
    public static final String STATUS_LINE_STYLE = "${statusLineStyle}";
    public static final String ACTION_NAME_STYLE = "${actionNameStyle}";
    public static final String ACTION_ID = "${actionId}";
    public static final String RESULT_ICON = "${result-icon}";
    public static final String ACTION_NAME = "${actionName}";
    public static final String SCRIPT_NAME = "${scriptName}";
    public static final String LINE = "${line}";
    public static final String EXECUTION_TIME_MIL = "${executionTimeMil}";
    public static final String EXECUTION_TIME_MIN = "${executionTimeMin}";
    public static final String EXECUTION_TIME_SEC = "${executionTimeSec}";
    private static final String ID_HIDDEN_PLACEHOLDER_MIN = "${idHiddenPlaceHolderMin}";
    private static final String ID_HIDDEN_PLACEHOLDER_SEC = "${idHiddenPlaceHolderSec}";
    private static final String ID_HIDDEN_PLACEHOLDER_MIL = "${idHiddenPlaceHolderMil}";
    private static final String ACTION_LABEL_CLASS = "${actionLabelClass}";
    private static final String ACTION_LABEL = "${actionLabel}";
    public static final String MEDIA_DATA = "${mediaData}";
    public static final String ELEMENT = "${element}";
    public static final String ACTION_BODY = "${actionBody}";
    public static final String DURATION_IDENTIFICATION_CLASS = "${durationIdentificationClass}";
    public static final String MEDIA_DATA_HTML_TEMPLATE = "<${mediaTag} class='data-image' ${controls} src='data:${contentType}/${mediaType};base64,${mediaSrc}' alt='Image'></${mediaTag}>";
    public static final String TEST_SCRIPT_HTML_TEMPLATE = "<a  style='color: rgba(104, 112, 125, 1); text-decoration: none; display: flex; align-items: center;' href='ats://${scriptNameUri}' target='_self'><div class='external-link-icon'></div><div class='script-name-text' title='${scriptNameTitle}'>${scriptName} </div>  &nbsp;( line ${line} )</a>";
    private String actionTemplate = ResourceContent.getHtmlReportActionHtmlTemplate();
    private final String oneElementDataTemplate = ResourceContent.getHtmlReportOneElementDataActionTemplate();
    private final String oneElementDataTemplate_AsaSuite = ResourceContent.getHtmlReportOneElementDataActionTemplate_AsaSuite();
    private final String twoElementDataTemplate = ResourceContent.getHtmlReportTwoElementsDataActionTemplate();
    private final String twoElementDataTemplate_AsaSuite = ResourceContent.getHtmlReportTwoElementsDataActionTemplate_AsaSuite();
    private final String threeElementDataTemplate = ResourceContent.getHtmlReportThreeElementsDataActionTemplate();
    private final String fiveElementDataTemplate = ResourceContent.getHtmlReportApiCallActionTemplate();
    private final String actionAssertPropertyTemplate = ResourceContent.getHtmlReportAssertPropertyActionTemplate();
    private final String actionAssertOccurrenceTemplate = ResourceContent.getHtmlReportAssertOccurrenceActionTemplate();
    private final String actionAssertValueTemplate = ResourceContent.getHtmlReportAssertValueActionTemplate();

    public String processAction(Action action, Map<String, String> appIcons, TestInfo testInfo, int reportLevel) {
        this.actionTemplate = this.actionTemplate.replace(SCRIPT_NAME, this.buildScriptName(action, testInfo));
        this.actionTemplate = this.actionTemplate.replace(LINE, String.valueOf(action.getLine()));
        HtmlReportActionLabel htmlReportActionLabel = new HtmlReportActionLabel(action.getType());
        this.actionTemplate = this.actionTemplate.replace(ACTION_LABEL_CLASS, htmlReportActionLabel.getCssClass());
        this.actionTemplate = this.actionTemplate.replace(ACTION_LABEL, htmlReportActionLabel.getLabel());
        if (action.getDuration() < 1000) {
            this.actionTemplate = this.actionTemplate.replace(EXECUTION_TIME_MIL, action.getDuration() % 1000 + " ms");
            this.actionTemplate = this.actionTemplate.replace(ID_HIDDEN_PLACEHOLDER_MIN, "hidden");
            this.actionTemplate = this.actionTemplate.replace(ID_HIDDEN_PLACEHOLDER_SEC, "hidden");
        } else {
            this.actionTemplate = this.actionTemplate.replace(ID_HIDDEN_PLACEHOLDER_MIL, "hidden");
            this.actionTemplate = this.actionTemplate.replace(EXECUTION_TIME_SEC, (long)action.getDuration() / 1000L % 60L + " sec");
            this.actionTemplate = this.actionTemplate.replace(EXECUTION_TIME_MIN, action.getDuration() / 60000 + " min");
        }
        this.actionTemplate = this.actionTemplate.replace(DURATION_IDENTIFICATION_CLASS, action.getScript() + "-" + action.getLine() + "-" + action.getDuration());
        if (reportLevel == 3) {
            String mediaData = this.buildMediaData(action.getImage());
            this.actionTemplate = this.actionTemplate.replace(MEDIA_DATA, mediaData);
        } else {
            this.actionTemplate = this.actionTemplate.replace("${imageVisibilityPlaceHolder}", "style='display: none;'");
        }
        boolean asSuite = Constants.SummaryStatus.PASS_CONTINUE.getNumericValue().equals(testInfo.getSummary().getStatus());
        String actionType = action.getType();
        if (actionType.equals("ActionComment")) {
            this.actionTemplate = this.actionTemplate.replace(ACTION_NAME, actionType);
            this.actionTemplate = this.actionTemplate.replace(STATUS_LINE_STYLE, "status-line-non-functional");
            this.actionTemplate = this.actionTemplate.replace(ACTION_NAME_STYLE, "action-name-non-functional");
            this.actionTemplate = this.actionTemplate.replace(RESULT_ICON, "result-non-icon");
            this.actionTemplate = this.actionTemplate.replace("element", "result-non-icon");
        } else {
            this.actionTemplate = this.actionTemplate.replace(ACTION_NAME, actionType);
            if (action.isPassed()) {
                this.actionTemplate = actionType.equals("ActionCallscript") ? this.actionTemplate.replace(STATUS_LINE_STYLE, "status-line-action-call-script") : this.actionTemplate.replace(STATUS_LINE_STYLE, "status-line-pass");
                this.actionTemplate = this.actionTemplate.replace(ACTION_NAME_STYLE, "action-name-pass");
                this.actionTemplate = this.actionTemplate.replace(RESULT_ICON, Constants.Status.PASS.getIcon());
            } else if (!action.isPassed() && !action.isStop()) {
                this.actionTemplate = actionType.equals("ActionCallscript") ? this.actionTemplate.replace(STATUS_LINE_STYLE, "status-line-action-call-script error " + testInfo.getTestName()) : this.actionTemplate.replace(STATUS_LINE_STYLE, "status-line-fail-pass error " + testInfo.getTestName());
                this.actionTemplate = this.actionTemplate.replace(ACTION_NAME_STYLE, "action-name-fail-pass");
                this.actionTemplate = this.actionTemplate.replace(RESULT_ICON, Constants.StatusIcons.FAIL_PASS_ICON);
            } else if (!action.isPassed() && action.isStop()) {
                this.actionTemplate = actionType.equals("ActionCallscript") ? this.actionTemplate.replace(STATUS_LINE_STYLE, "status-line-action-call-script error " + testInfo.getTestName()) : this.actionTemplate.replace(STATUS_LINE_STYLE, "status-line-failed error " + testInfo.getTestName());
                this.actionTemplate = this.actionTemplate.replace(ACTION_NAME_STYLE, "action-name-failed");
                this.actionTemplate = this.actionTemplate.replace(RESULT_ICON, Constants.Status.FAIL.getIcon());
            }
            this.actionTemplate = this.actionTemplate.replace(ACTION_ID, String.format("%s-%s", action.getScript(), action.getIndex()));
        }
        switch (actionType) {
            case "ActionChannelStart": {
                if (action.getAppDataJson() == null || action.getAppDataJson().getAppVersion() == null) {
                    this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionChannel(this.twoElementDataTemplate, action, HtmlReportActionChannel.ActionChannelOperation.CHANNEL_START, appIcons, testInfo.getOsInfo()).getResult());
                    break;
                }
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionChannel(this.threeElementDataTemplate, action, HtmlReportActionChannel.ActionChannelOperation.CHANNEL_START, appIcons, testInfo.getOsInfo()).getResult());
                break;
            }
            case "ActionChannelClose": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionChannel(this.twoElementDataTemplate, action, HtmlReportActionChannel.ActionChannelOperation.CHANNEL_CLOSE, appIcons, testInfo.getOsInfo()).getResult());
                break;
            }
            case "ActionChannelSwitch": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionChannel(this.oneElementDataTemplate, action, HtmlReportActionChannel.ActionChannelOperation.CHANNEL_CHANGE, appIcons, testInfo.getOsInfo()).getResult());
                break;
            }
            case "ActionGotoUrl": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionGoToUrl(this.oneElementDataTemplate, action).getResult());
                break;
            }
            case "ActionMouseDragDrop": 
            case "ActionMouseSwipe": 
            case "ActionMouse": 
            case "ActionMouseKey": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionMouse(this.twoElementDataTemplate, action, false).getResult());
                break;
            }
            case "ActionMouseScroll": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionMouse(this.twoElementDataTemplate, action, true).getResult());
                break;
            }
            case "ActionWindowState": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionWindowState(this.oneElementDataTemplate, action, false).getResult());
                break;
            }
            case "ActionWindowResize": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionWindowState(this.twoElementDataTemplate, action, true).getResult());
                break;
            }
            case "ActionText": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionTextAndSelect(this.twoElementDataTemplate, action, "Entered text").getResult());
                break;
            }
            case "ActionSelect": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionTextAndSelect(this.twoElementDataTemplate, action, "Selected option").getResult());
                break;
            }
            case "ActionProperty": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionProperty(this.twoElementDataTemplate, action).getResult());
                break;
            }
            case "ActionScripting": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionScripting(this.twoElementDataTemplate, action).getResult());
                break;
            }
            case "ActionWindowSwitch": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionWindowSwitch(this.oneElementDataTemplate, action).getResult());
                break;
            }
            case "ActionWindowNew": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionWindowNew(this.oneElementDataTemplate, action).getResult());
                break;
            }
            case "ActionAssertValue": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionAssert(this.actionAssertValueTemplate, action, HtmlReportActionAssert.ActionAssertOperation.ASSERT_VALUE).getResult());
                break;
            }
            case "ActionAssertProperty": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionAssert(this.actionAssertPropertyTemplate, action, HtmlReportActionAssert.ActionAssertOperation.ASSERT_PROPERTY).getResult());
                break;
            }
            case "ActionAssertCount": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionAssert(this.actionAssertOccurrenceTemplate, action, HtmlReportActionAssert.ActionAssertOperation.ASSERT_COUNT).getResult());
                break;
            }
            case "ActionComment": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionComment(this.oneElementDataTemplate, action).getResult());
                break;
            }
            case "ActionApi": {
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, new HtmlReportActionApi(this.fiveElementDataTemplate, action).getResult());
                break;
            }
            case "ActionCallscript": 
            case "EndOfRecording": {
                String wrkTemplate = "";
                wrkTemplate = action.getAppDataJson() != null && !action.getAppDataJson().getData().isEmpty() || action.getActionElement() != null ? new HtmlReportActionCallScript(this.twoElementDataTemplate_AsaSuite, action, true, testInfo.getProject(), asSuite).getResult() : new HtmlReportActionCallScript(this.oneElementDataTemplate_AsaSuite, action, false, testInfo.getProject(), asSuite).getResult();
                this.actionTemplate = this.actionTemplate.replace(ACTION_BODY, wrkTemplate);
                break;
            }
            case "StartScriptAction": {
                this.actionTemplate = "";
                break;
            }
            default: {
                AtsLogger.printLog("default action");
            }
        }
        if (!actionType.equals("ActionComment") && reportLevel == 1) {
            this.actionTemplate = this.actionTemplate.replace("class='data'", "style='display: none;'");
            this.actionTemplate = this.actionTemplate.replace("class='inner-container'", "class='inner-container' style='min-height: unset;'");
            this.actionTemplate = this.actionTemplate.replace("class='header'", "class='header' style='padding-bottom: unset;'");
        }
        return this.actionTemplate;
    }

    private String buildMediaData(Image image) {
        if (image.getType().equals("video")) {
            this.actionTemplate = this.actionTemplate.replace("${mediaIcon}", "data-video-icon");
            this.actionTemplate = this.actionTemplate.replace("${mediaHostIcon}", "data-video-host-icon");
            return MEDIA_DATA_HTML_TEMPLATE.replace("${mediaTag}", "video").replace("${contentType}", "video").replace("${mediaType}", "mp4").replace("${mediaSrc}", image.getSrc()).replace("${controls}", "controls='controls'");
        }
        this.actionTemplate = this.actionTemplate.replace("${mediaHostIcon}", "data-image-host-icon");
        this.actionTemplate = this.actionTemplate.replace("${mediaIcon}", "data-image-icon");
        return MEDIA_DATA_HTML_TEMPLATE.replace("${mediaTag}", "img").replace("${contentType}", "image").replace("${mediaType}", image.getType()).replace("${mediaSrc}", image.getSrc());
    }

    private CharSequence buildScriptName(Action action, TestInfo testInfo) {
        return TEST_SCRIPT_HTML_TEMPLATE.replace("${scriptNameUri}", HtmlActionUtils.getActionUrl(action, testInfo)).replace(SCRIPT_NAME, action.getScript() + " ").replace("${scriptNameTitle}", action.getScript());
    }

    public void setActionTemplate(String actionTemplate) {
        this.actionTemplate = actionTemplate;
    }
}

