/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.scripts;

import com.ats.AtsSingleton;
import com.ats.executor.scripts.AtsCallSubscriptPythonException;
import com.ats.executor.scripts.AtsCallSubscriptScript;
import com.ats.script.actions.ActionComment;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import org.testng.annotations.Test;

public class AtsCallSubscriptPython
extends AtsCallSubscriptScript {
    public static final String PYTHON_LANGUAGE = "python";
    private static final String PY_CONSOLE_PREFIX = "ats-py-console: ";
    private static final String atsCode = "class ats_result:\r\n\tlogs=[]\r\n\tvalues=[]\r\n\tcomments=[]\r\ndef ats_log(data):\r\n\tats_result.logs.append(data)\r\ndef ats_comment(data):\r\n\tats_result.comments.append(data)\r\ndef ats_return(data):\r\n\tats_result.values=data\r\n\r\n";

    @Test
    public void testMain() {
        List<Object> returnValues = new ArrayList();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StringBuilder pyCode = new StringBuilder(atsCode).append("def ats_parameter(index):\r\n\t").append((CharSequence)this.getParametersCode()).append("\r\n\tif(index<len(p)):\r\n\t\treturn p[index]\r\n\telse:\r\n\t\treturn ''\r\n\r\n").append("ats_iteration").append("=").append(this.getIteration()).append("\r\n").append("ats_iterations_count").append("=").append(this.getIterationsCount()).append("\r\n").append(this.code).append("\r\n");
        try {
            Context.Builder builder = AtsSingleton.getInstance().getPythonBuilder();
            Context ctx = builder.out((OutputStream)out).build();
            ctx.eval(PYTHON_LANGUAGE, (CharSequence)pyCode.toString());
            Value binding = ctx.getBindings(PYTHON_LANGUAGE);
            Value atsResult = binding.getMember("ats_result");
            Value atsReturnValues = atsResult.getMember("values");
            Value atsLogs = atsResult.getMember("logs");
            Value atsComments = atsResult.getMember("comments");
            returnValues = atsReturnValues.isString() || atsReturnValues.isBoolean() || atsReturnValues.isNumber() ? Arrays.asList(atsReturnValues.as(Object.class)) : new ArrayList<Object>(Arrays.asList((Object[])atsReturnValues.as(Object[].class)));
            String[] logs = (String[])atsLogs.as(String[].class);
            for (int i = 0; i < logs.length; ++i) {
                String log = logs[i];
                System.out.println(PY_CONSOLE_PREFIX + log);
                this.exec(0, new ActionComment(this, "log", this.clv(log)));
            }
            String[] comments = (String[])atsComments.as(String[].class);
            for (int i = 0; i < comments.length; ++i) {
                this.exec(0, new ActionComment(this, "step", this.clv(comments[i])));
            }
            System.out.println(out.toString());
            ctx.close();
        }
        catch (Exception e) {
            throw new AtsCallSubscriptPythonException(e.getMessage());
        }
        this.returnValues(returnValues.toArray());
    }
}

