/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.performance.filters;

import com.ats.tools.performance.filters.UrlPattern;
import com.browserup.harreader.model.HarEntry;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class UrlBaseFilter {
    private String pageId = "ats-channel-start";
    protected List<UrlPattern> listUrls;

    public static Predicate<UrlPattern> isMatching(String value) {
        return p -> p.match(value);
    }

    public UrlBaseFilter() {
    }

    public UrlBaseFilter(List<String> list) {
        this.listUrls = list.stream().map(s -> new UrlPattern((String)s)).collect(Collectors.toList());
    }

    public void setPageId(String value) {
        this.pageId = value;
    }

    public void filter(List<HarEntry> logEntries, List<HarEntry> savedEntries) {
        while (logEntries.size() > 0) {
            this.process(logEntries.remove(0), savedEntries);
        }
    }

    protected void saveEntry(List<HarEntry> savedEntries, HarEntry entry) {
        entry.setPageref(this.pageId);
        savedEntries.add(entry);
    }

    protected void process(HarEntry entry, List<HarEntry> savedEntries) {
        this.saveEntry(savedEntries, entry);
    }
}

