/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element;

import com.ats.data.Rectangle;
import com.ats.element.AtsElement;
import com.ats.element.AtsMobileElement;
import com.ats.element.AtsSapElement;
import com.ats.element.ParameterElement;
import com.ats.element.api.AtsApiElement;
import com.ats.element.test.TestElement;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.desktop.DesktopElement;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.executor.drivers.engines.WebDriverEngine;
import com.ats.generator.variables.CalculatedProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

public class FoundElement {
    private String id;
    private Double x = 0.0;
    private Double y = 0.0;
    private Double screenX = 0.0;
    private Double screenY = 0.0;
    private Double innerX = 0.0;
    private Double innerY = 0.0;
    private Double boundX = 0.0;
    private Double boundY = 0.0;
    private Double width = 0.0;
    private Double height = 0.0;
    private int centerWidth = 0;
    private int centerHeight = 0;
    private String tag = "*";
    private boolean shadowRoot = false;
    private String type = "html";
    private RemoteWebElement value;
    private FoundElement parent;
    private boolean visible = true;
    private boolean numeric = false;
    private boolean password = false;
    private boolean clickable = true;
    private ArrayList<FoundElement> children;
    private boolean active = true;
    private ArrayList<AtsElement> iframes;
    private Map<String, String> attributes;
    private String innerText = null;

    public FoundElement() {
    }

    public FoundElement(Channel channel) {
        RemoteWebElement root = (RemoteWebElement)channel.getRootElement();
        if (root != null) {
            this.setRemoteWebElement(root);
            this.width = root.getSize().getWidth();
            this.height = root.getSize().getHeight();
        }
    }

    public FoundElement(Channel channel, String tagName, RemoteWebElement elem) {
        try {
            this.width = elem.getSize().getWidth();
            this.height = elem.getSize().getHeight();
            this.x = (double)elem.getRect().getX() + channel.getSubDimension().getX();
            this.y = (double)elem.getRect().getY() + channel.getSubDimension().getY();
            this.screenX = this.x;
            this.screenY = this.y;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTag(tagName);
        this.setRemoteWebElement(elem);
    }

    public FoundElement(WebDriverEngine engine, RemoteWebElement elem) {
        String tagName = "shadowroot";
        try {
            tagName = engine.getElementTag((WebElement)elem);
            this.width = elem.getSize().getWidth();
            this.height = elem.getSize().getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTag(tagName);
        this.setRemoteWebElement(elem);
        this.setShadowRoot(true);
    }

    public FoundElement(AtsElement element) {
        this.setRemoteWebElement(element.getElement());
        this.tag = element.getTag();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.numeric = element.isNumeric();
        this.password = element.isPassword();
        this.shadowRoot = element.isShadowRoot();
    }

    public FoundElement(DesktopElement element) {
        this.setRemoteWebElement(element.getElement());
        this.tag = element.getTag();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.x = element.getX();
        this.y = element.getY();
        this.screenX = element.getX();
        this.screenY = element.getY();
    }

    public FoundElement(DesktopWindow win) {
        this.id = win.getId();
        this.tag = win.getTag();
        this.width = win.getWidth();
        this.height = win.getHeight();
    }

    public FoundElement(AtsElement element, Channel channel, Double offsetX, Double offsetY) {
        this(element);
        Double elemX = element.getX();
        Double elemY = element.getY();
        this.updatePosition(elemX, elemY, channel, offsetX, offsetY);
        this.screenX = element.getScreenX() + elemX;
        this.screenY = element.getScreenY() + elemY;
        this.boundX = element.getBoundX();
        this.boundY = element.getBoundY();
    }

    public FoundElement(AtsElement element, ArrayList<AtsElement> iframes, Channel channel, Double offsetX, Double offsetY) {
        this(element, channel, offsetX, offsetY);
        this.iframes = iframes;
    }

    public FoundElement(WebDriverEngine engine, AtsElement element, Channel channel, Double offsetX, Double offsetY, boolean waitAnimation) {
        this(element, channel, offsetX, offsetY);
        if (waitAnimation && element.getElement().isDisplayed()) {
            for (int maxTry = 5; (this.width < 1.0 || this.height < 1.0) && maxTry > 0; --maxTry) {
                List<Double> rect = engine.getBoundingClientRect(element.getElement());
                Double rectX = rect.get(0);
                Double rectY = rect.get(1);
                Double rectW = rect.get(2);
                Double rectH = rect.get(3);
                if (rectX != null && rectY != null && rectW != null && rectH != null && rectW >= 1.0 && rectH >= 1.0) {
                    this.x = rectX;
                    this.y = rectY;
                    this.boundX = rectX;
                    this.boundY = rectY;
                    this.width = rectW;
                    this.height = rectH;
                    continue;
                }
                channel.sleep();
            }
        }
    }

    public FoundElement(List<AtsElement> desktops) {
        AtsElement desktop = desktops.get(0);
        this.type = "desktop";
        this.visible = true;
        this.id = desktop.getId();
        this.password = false;
        this.tag = desktop.getTag();
        this.width = desktop.getWidth();
        this.height = desktop.getHeight();
        this.clickable = true;
        this.active = true;
        this.screenX = desktop.getX();
        this.screenY = desktop.getY();
        this.x = this.screenX;
        this.y = this.screenY;
    }

    public FoundElement(AtsElement element, TestBound channelDimension) {
        this.type = "desktop";
        this.visible = element.isVisible();
        this.id = element.getId();
        this.password = element.isPassword();
        this.tag = element.getTag();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.clickable = element.isClickable();
        this.active = this.clickable && this.visible;
        this.screenX = element.getX();
        this.screenY = element.getY();
        this.x = this.screenX - channelDimension.getX();
        this.y = this.screenY - channelDimension.getY();
        if (element.getChildren() != null) {
            this.children = element.getChildren().stream().map(e -> new FoundElement((AtsElement)e, channelDimension)).collect(Collectors.toCollection(ArrayList::new));
        }
        this.attributes = element.getAttributesMap();
    }

    public FoundElement(AtsSapElement element) {
        this.type = "sap";
        this.id = element.getId();
        this.tag = element.getTag();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.x = element.getX();
        this.y = element.getY();
        this.screenX = element.getScreenX();
        this.screenY = element.getScreenY();
        this.innerText = element.getInnerText();
    }

    public FoundElement(double channelX, double channelY, JsonNode node) {
        this.type = "sap";
        this.id = this.getNodeText(node, "Id");
        this.tag = this.getNodeText(node, "Tag");
        this.width = this.getNodeDouble(node, "Width");
        this.height = this.getNodeDouble(node, "Height");
        this.visible = true;
        this.clickable = true;
        this.active = this.clickable && this.visible;
        this.screenX = this.getNodeDouble(node, "ScreenX");
        this.screenY = this.getNodeDouble(node, "ScreenY");
        this.x = this.screenX - channelX;
        this.y = this.screenY - channelY;
    }

    private String getNodeText(JsonNode node, String attribute) {
        if (node.has(attribute)) {
            return node.get(attribute).asText();
        }
        return "";
    }

    private Double getNodeDouble(JsonNode node, String attribute) {
        if (node.has(attribute)) {
            return node.get(attribute).asDouble();
        }
        return 0.0;
    }

    public FoundElement(double channelX, double channelY, JsonNode node, JsonNode parentNode) {
        this(channelX, channelY, node);
        if (!parentNode.isNull()) {
            this.parent = new FoundElement(channelX, channelY, parentNode, parentNode.get("Parent"));
        }
    }

    public FoundElement(AtsMobileElement element) {
        this.type = "mobile";
        this.id = element.getId();
        this.tag = element.getTag();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.screenX = element.getX();
        this.screenY = element.getY();
        this.x = this.screenX;
        this.y = this.screenY;
        this.innerText = element.getAttribute("innerText");
    }

    public FoundElement(AtsApiElement element) {
        this.type = "api";
        this.visible = true;
        this.id = element.getId();
        this.tag = element.getTag();
        this.clickable = false;
    }

    public FoundElement(Channel channel, ArrayList<AtsElement> iframes, ArrayList<AtsElement> elements, Double initElementX, Double initElementY) {
        this(elements.remove(0), iframes, channel, initElementX, initElementY);
        if (elements.size() > 0) {
            this.setParent(new FoundElement(channel, iframes, elements, initElementX, initElementY));
        } else if (iframes != null && iframes.size() > 0) {
            elements.addAll(iframes);
            iframes.clear();
            this.setParent(new FoundElement(channel, iframes, elements, initElementX, initElementY));
        }
    }

    public FoundElement(Channel channel, TestElement parent, int duration, int device) {
        this.tag = "@RECORD";
        this.screenX = parent.getFoundElement().getScreenX();
        this.screenY = parent.getFoundElement().getScreenY();
        this.width = parent.getFoundElement().getWidth();
        this.height = parent.getFoundElement().getHeight();
        this.attributes = Map.of("duration", String.valueOf(duration), "device", String.valueOf(device));
    }

    public FoundElement(Channel channel, TestBound bound, Rectangle rect) {
        this.setRemoteWebElement((RemoteWebElement)channel.getRootElement());
        this.tag = "@IMAGE";
        this.width = rect.getWidth();
        this.height = rect.getHeight();
        int centerX = (int)(this.width / 2.0);
        int centerY = (int)(this.height / 2.0);
        this.centerWidth = centerX;
        this.centerHeight = centerY;
        this.x = rect.getX() + bound.getX();
        this.y = rect.getY() + bound.getY();
        this.boundX = this.x - channel.getSubDimension().getX() + (double)centerX;
        this.boundY = this.y - channel.getSubDimension().getY() + (double)centerY;
        this.screenX = this.x + channel.getDimension().getX() + (double)centerX;
        this.screenY = this.y + channel.getDimension().getY() + (double)centerY;
        this.innerX = this.boundX - channel.getSubDimension().getWidth() / 2.0;
        this.innerY = this.boundY - channel.getSubDimension().getHeight() / 2.0;
    }

    public String getInnerText() {
        if (this.value == null) {
            return this.innerText;
        }
        return this.value.getAttribute("innerText");
    }

    public void addShadowParent(FoundElement elem) {
        if (this.parent == null) {
            this.parent = elem;
        } else {
            this.parent.addShadowParent(elem);
        }
    }

    public FoundElement addParent(FoundElement p) {
        this.parent = p;
        return this.parent;
    }

    public void updateSize(double w, double h) {
        if (this.width < w) {
            this.width = w;
        }
        if (this.height < h) {
            this.height = h;
        }
    }

    public void updateSize(Double screenX, Double screenY, Double width, Double height, Double x, Double y) {
        this.screenX = screenX;
        this.screenY = screenY;
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
    }

    public String[] getItemAttribute() {
        if (this.attributes != null && this.attributes.size() == 2) {
            return new String[]{this.attributes.get("value"), this.attributes.get("text")};
        }
        return new String[0];
    }

    public Map<String, String> getAttribute() {
        return this.attributes;
    }

    public CalculatedProperty[] getCalculatedProperty() {
        ArrayList<CalculatedProperty> lst = new ArrayList<CalculatedProperty>();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            lst.add(new CalculatedProperty(entry.getKey(), entry.getValue()));
        }
        return lst.toArray(new CalculatedProperty[this.attributes.size()]);
    }

    public int getCenterWidth() {
        return this.centerWidth;
    }

    public int getCenterHeight() {
        return this.centerHeight;
    }

    public boolean isDesktop() {
        return "desktop".equals(this.type);
    }

    public boolean isMobile() {
        return "mobile".equals(this.type);
    }

    public boolean isSAP() {
        return "sap".equals(this.type);
    }

    public ArrayList<AtsElement> getIframes() {
        return this.iframes;
    }

    public void dispose() {
        if (this.parent != null) {
            this.parent.dispose();
            this.parent = null;
        }
        this.value = null;
    }

    public void updateBounding(Double x, Double y, Channel channel, Double width, Double height) {
        this.updatePosition(x, y, channel, 0.0, 0.0);
        this.width = width;
        this.height = height;
    }

    public void updatePosition(Double x, Double y, Channel channel, Double offsetX, Double offsetY) {
        this.x = x + channel.getSubDimension().getX() + offsetX;
        this.y = y + channel.getSubDimension().getY() + offsetY;
    }

    private void setRemoteWebElement(RemoteWebElement rwe) {
        this.value = rwe;
        if (rwe != null) {
            this.id = rwe.getId();
        }
    }

    public boolean isIframe() {
        return AtsElement.checkIframe(this.tag);
    }

    public boolean isBody() {
        return AtsElement.checkBody(this.tag);
    }

    public boolean isInput() {
        return AtsElement.checkInput(this.tag);
    }

    public boolean isInputFile() {
        return AtsElement.checkInputFile(this.tag, this.value.getDomProperty("type"));
    }

    public boolean isTD() {
        return AtsElement.checkTD(this.tag);
    }

    public WebElement getValue() {
        return this.value;
    }

    public String getDomAttributeOrProperty(String value) {
        String attribute = this.getValue().getDomAttribute(value);
        if (attribute == null && (attribute = this.getValue().getDomProperty(value)) == null) {
            return "";
        }
        return attribute;
    }

    public boolean isSelected() {
        String prop = this.getValue().getDomProperty("selected");
        return "true".equals(prop);
    }

    public String getTextContent() {
        String prop = this.getValue().getDomProperty("textContent");
        if (prop == null) {
            return "";
        }
        return prop;
    }

    public String getWebElementId() {
        if (this.value == null) {
            return "N/A";
        }
        return this.value.getId();
    }

    public byte[] getWebElementImage() {
        return (byte[])this.value.getScreenshotAs(OutputType.BYTES);
    }

    public void activate(RemoteWebDriver remoteWebDriver) {
        this.value = new RemoteWebElement();
        this.value.setParent(remoteWebDriver);
        this.value.setId(this.id);
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public int[] getScreenRectangle() {
        return new int[]{this.screenX.intValue(), this.screenY.intValue(), this.width.intValue(), this.height.intValue()};
    }

    public Double getScreenX() {
        return this.screenX;
    }

    public Double getScreenY() {
        return this.screenY;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isPassword() {
        return this.password;
    }

    public boolean isActive() {
        return this.active;
    }

    public ArrayList<FoundElement> getChildren() {
        return this.children;
    }

    public int getInnerX() {
        return this.innerX.intValue();
    }

    public int getInnerY() {
        return this.innerY.intValue();
    }

    public boolean isShadowRoot() {
        return this.shadowRoot;
    }

    public void setShadowRoot(boolean value) {
        this.shadowRoot = value;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setClickable(boolean value) {
        this.clickable = value;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public FoundElement getParent() {
        return this.parent;
    }

    public void setParent(FoundElement parent) {
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Double getHeight() {
        return this.height;
    }

    public Double getArea() {
        return this.height * this.width;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Double getBoundX() {
        return this.boundX;
    }

    public void setBoundX(Double boundX) {
        this.boundX = boundX;
    }

    public Double getBoundY() {
        return this.boundY;
    }

    public void setBoundY(Double boundY) {
        this.boundY = boundY;
    }

    public ParameterElement getParameterElement() {
        return new ParameterElement(this.getWebElementId(), this.getTag(), this.getTestBound());
    }

    public RemoteWebElement getRemoteWebElement(RemoteWebDriver driver) {
        RemoteWebElement element = new RemoteWebElement();
        element.setParent(driver);
        element.setId(this.id);
        return element;
    }

    public TestBound getTestBound() {
        return new TestBound(this.x, this.y, this.width, this.height);
    }

    public TestBound getTestScreenBound() {
        return new TestBound(this.screenX, this.screenY, this.width, this.height);
    }

    public AtsSapElement getAtsSapElement() {
        return new AtsSapElement(this);
    }

    public void flatten(List<FoundElement> flatList) {
        if (this.children != null) {
            for (FoundElement child : this.children) {
                child.flatten(flatList);
            }
        }
        this.children = null;
        flatList.add(this);
    }
}

