/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element;

import com.ats.element.DialogBox;
import com.ats.executor.ActionStatus;
import com.ats.executor.drivers.engines.SapDriverEngine;
import com.ats.generator.variables.CalculatedProperty;
import com.google.common.collect.ObjectArrays;

public class SapDialogBox
extends DialogBox {
    private static final String ACCEPT = "accept";
    private static final String DISMISS = "dismiss";
    private SapDriverEngine sapDriver;
    private String id;
    private String title;
    private String text;
    private String type;

    public SapDialogBox(SapDriverEngine driver, String id, String title, String text, String type) {
        this.sapDriver = driver;
        this.id = id;
        this.title = title;
        this.text = text;
        this.type = type;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void dismiss(ActionStatus status) {
        this.sapDriver.dialogBoxExecute(status, this.id, DISMISS);
    }

    @Override
    public void accept(ActionStatus status) {
        this.sapDriver.dialogBoxExecute(status, this.id, ACCEPT);
    }

    @Override
    public CalculatedProperty[] getAttributes() {
        Object[] arr1 = super.getAttributes();
        Object[] arr2 = new CalculatedProperty[]{new CalculatedProperty("title", this.title), new CalculatedProperty("type", this.type)};
        return (CalculatedProperty[])ObjectArrays.concat((Object[])arr1, (Object[])arr2, CalculatedProperty.class);
    }

    @Override
    public void clickButtonAtIndex(int index, ActionStatus status) {
        this.sapDriver.dialogBoxExecute(status, this.id, Integer.toString(index));
    }
}

