/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor;

import com.ats.AtsSingleton;
import com.ats.crypto.Passwords;
import com.ats.element.ParameterElement;
import com.ats.element.SearchedElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ExecutionStatistics;
import com.ats.executor.ScriptStatus;
import com.ats.executor.StopExecutionThread;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.executor.listeners.ExecutionListener;
import com.ats.executor.listeners.SuiteListener;
import com.ats.executor.listeners.TestListener;
import com.ats.executor.results.SuiteResultCollection;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.objects.mouse.Mouse;
import com.ats.generator.objects.mouse.MouseKey;
import com.ats.generator.objects.mouse.MouseScroll;
import com.ats.generator.objects.mouse.MouseSwipe;
import com.ats.generator.variables.ApiData;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.RandomStringValue;
import com.ats.generator.variables.TableSplit;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.parameter.Parameter;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.generator.variables.transform.DateTransformer;
import com.ats.generator.variables.transform.EvalTransformer;
import com.ats.generator.variables.transform.NumericTransformer;
import com.ats.generator.variables.transform.RegexpTransformer;
import com.ats.generator.variables.transform.TimeTransformer;
import com.ats.generator.variables.transform.Transformer;
import com.ats.learning.AtsLearning;
import com.ats.learning.AtsLearningOff;
import com.ats.learning.IAtsLearning;
import com.ats.recorder.IVisualRecorder;
import com.ats.recorder.TestError;
import com.ats.recorder.VisualRecorder;
import com.ats.recorder.VisualRecorderNull;
import com.ats.script.Project;
import com.ats.script.Script;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionCallscript;
import com.ats.script.actions.ActionChannelStart;
import com.ats.script.actions.ActionComment;
import com.ats.script.actions.ActionCondition;
import com.ats.script.actions.ActionExecute;
import com.ats.script.actions.condition.ExecuteOptions;
import com.ats.script.actions.network.ActionNetwork;
import com.ats.tools.Utils;
import com.ats.tools.logger.ExecutionLogger;
import com.ats.tools.logger.levels.AtsFailError;
import com.ats.tools.report.AtsReporterListener;
import com.ats.tools.report.SuitesReportItem;
import com.ats.tools.report.utils.ReportImageFormat;
import com.ats.tools.telemetry.Collector;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import org.openqa.selenium.Keys;
import org.openqa.selenium.interactions.Actions;
import org.testng.Assert;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.SkipException;
import org.testng.TestRunner;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Listeners;

@Listeners(value={ExecutionListener.class, SuiteListener.class, TestListener.class, AtsReporterListener.class})
public class ActionTestScript
extends Script {
    public static final String MAIN_TEST_FUNCTION = "testMain";
    public static final String TEST_STOPPABLE = "com.ats.test.stoppable";
    public static final String TEST_PARAMETERS = "ats.script.parameters";
    public static final String EXECUTION_VELOCITY = "ats-velocity";
    public static final String EXECUTION_VELOCITY_ENV = "ATS_VELOCITY";
    public static final String SUITE_PARAMETERS = "parameters.txt";
    private static final String COLUMN_TEST_ID = "$ats_test_id";
    private static final String COLUMN_TEST_DESCRIPTION = "$ats_test_description";
    private static final String COLUMN_TEST_PREREQUISITE = "$ats_test_prerequisite";
    private static final String COLUMN_TEST_EXTERNAL = "$ats_test_external_id";
    private static final String SUITE_TERMINATED = "suite terminated";
    private static final String AS_SUITE_TERMINATED = "callscript 'as a suite' terminated";
    private int verbosity = 0;
    private Map<String, String> testParameters;
    private Path suiteOutputPath;
    private ActionTestScript topScript;
    private String dateOrder = "";
    private String[] retVals;
    private Project projectData;
    private boolean xmlPic = false;
    private static final List<String> trueList = Arrays.asList("on", "true", "1", "yes", "y");
    private ScriptStatus status = new ScriptStatus();
    private long startTime;
    private boolean asSuite = false;
    private IAtsLearning atsLearning = new AtsLearningOff();
    private List<String> channels = new ArrayList<String>();
    private ParameterElement parameterElement = null;
    public static final String JAVA_VAR_FUNCTION_NAME = "var";
    public static final String JAVA_GLOBAL_VAR_FUNCTION_NAME = "gvar";
    public static final String JAVA_VALUE_FUNCTION_NAME = "clv";
    public static final String JAVA_SPLIT_FUNCTION_NAME = "split";
    public static final String JAVA_PARAM_FUNCTION_NAME = "prm";
    public static final String JAVA_RETURNS_FUNCTION_NAME = "rtn";
    public static final String JAVA_RNDSTRING_FUNCTION_NAME = "rds";
    public static final String JAVA_ENV_FUNCTION_NAME = "env";
    public static final String JAVA_PROPERTY_FILE_FUNCTION_NAME = "pt";
    public static final String CONCAT_FUNCTION = "ct";
    public static final String JAVA_PROJECT_VARIABLE_FUNCTION_NAME = "prj";
    public static final String JAVA_SYSTEM_FUNCTION_NAME = "sys";
    public static final String JAVA_PROPERTY_FUNCTION_NAME = "prp";
    public static final String JAVA_UUID_FUNCTION_NAME = "uid";
    public static final String JAVA_TODAY_FUNCTION_NAME = "td";
    public static final String JAVA_LAST_ACTION_DURATION_FUNCTION_NAME = "lad";
    public static final String JAVA_NOW_FUNCTION_NAME = "nw";
    public static final String JAVA_ITERATION_FUNCTION_NAME = "itr";
    public static final String JAVA_ITERATION_COUNT_FUNCTION_NAME = "itc";
    public static final String JAVA_ELEMENT_FUNCTION_NAME = "el";
    public static final String JAVA_REGEX_FUNCTION_NAME = "rx";
    public static final String JAVA_DATE_FUNCTION_NAME = "dt";
    public static final String JAVA_TIME_FUNCTION_NAME = "tm";
    public static final String JAVA_NUMERIC_FUNCTION_NAME = "nm";
    public static final String JAVA_SCRIPTING_FUNCTION_NAME = "sc";
    public static final String JAVA_POS_FUNCTION_NAME = "ps";
    public static final String JAVA_MOUSE_FUNCTION_NAME = "ms";
    public static final String JAVA_EMBEDED_FUNCTION_NAME = "emb";
    public static final String JAVA_ATS_FUNCTION_NAME = "ats";
    public static final String JAVA_CONDITION_FUNCTION = "opt";
    public static final String JAVA_EXECUTE_FUNCTION_NAME = "exec";
    private boolean dragWithDesktop = false;
    private IVisualRecorder recorder = new VisualRecorderNull();

    protected ScriptHeader getScriptHeader() {
        return this.scriptHeader;
    }

    public ActionTestScript() {
        super(null);
        this.init(new Passwords());
    }

    public ActionTestScript(File assetsFolder) {
        super(null);
        this.init(new Passwords(assetsFolder.toPath()));
        this.initShadowScript();
    }

    public ActionTestScript(ExecutionLogger logger) {
        super(logger);
        this.init(null);
    }

    public ActionTestScript(ActionTestScript topScript) {
        this.setTopScript(topScript);
    }

    public void setTopScript(ActionTestScript topScript, String scriptName) {
        this.setTopScript(topScript);
        this.setTestName(scriptName);
        this.setOutputPath(topScript.getSuiteOutputPath());
        this.initShadowScript(topScript.getShadowScript());
        AtsSingleton.getInstance().addCalledScript(this, this.getCanonicalName());
    }

    public void setTopScript(ActionTestScript topScript) {
        this.init(topScript, topScript.getPasswords());
    }

    private void init(Passwords passwords) {
        this.init(this, passwords);
    }

    private void init(ActionTestScript topScript, Passwords passwords) {
        this.topScript = topScript;
        this.scriptHeader = topScript.getScriptHeader();
        this.passwords = passwords;
        Logger.getLogger("org.openqa.selenium").setLevel(Level.OFF);
        Logger.getLogger(Actions.class.getName()).setLevel(Level.OFF);
        Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);
    }

    public String[] getReturnValues() {
        return this.retVals;
    }

    public Passwords getPasswords() {
        return this.passwords;
    }

    public void updateTestName(String name) {
        this.setTestName(name);
    }

    public void scriptFail(String message) {
        Assert.fail((String)message);
    }

    public ScriptStatus getStatus() {
        return this.status;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public Map<String, String> getTestParameters() {
        return this.testParameters;
    }

    public Path getSuiteOutputPath() {
        return this.suiteOutputPath;
    }

    public void setOutputPath(Path value) {
        this.suiteOutputPath = value;
    }

    public ScriptHeader getHeader() {
        return this.getScriptHeader();
    }

    public void initAsSuite() {
        this.asSuite = true;
        this.stopRecorder(true);
    }

    @BeforeSuite(alwaysRun=true)
    public void beforeSuite() {
        this.startTime = System.currentTimeMillis();
        ITestResult itr = Reporter.getCurrentTestResult();
        SuitesReportItem currentsuite = new SuitesReportItem(this.scriptHeader.getProjectUuid(), this.scriptHeader.getProjectId(), (TestRunner)itr.getTestContext());
        AtsSingleton.getInstance().updateLogger(this.scriptHeader.getLogsType(), currentsuite.getOutputFolder());
        if (AtsSingleton.getInstance().getAtsPropertiesFilePath() != null) {
            this.getLogger().sendInfo("using '.atsPropertiesFile'", AtsSingleton.getInstance().getAtsPropertiesFilePath());
        }
        this.getLogger().sendScriptSuite(currentsuite.getStartLog());
        ExecutionListener.startSuite(currentsuite);
        if (System.getProperty("xstats") != null && System.getProperty("xstats").equalsIgnoreCase("true")) {
            ExecutionStatistics timerTask = new ExecutionStatistics();
            Timer timer = new Timer(true);
            timer.scheduleAtFixedRate((TimerTask)timerTask, 0L, 500L);
        }
    }

    @AfterSuite(alwaysRun=true)
    public void afterSuite() {
        ITestResult itr = Reporter.getCurrentTestResult();
        ITestContext ctx = itr.getTestContext();
        int testsPassed = 0;
        int testsFailed = 0;
        String logLabel = SUITE_TERMINATED;
        boolean nativeSuite = true;
        int testsCount = ctx.getSuite().getXmlSuite().getTests().size();
        if (this.asSuite) {
            logLabel = AS_SUITE_TERMINATED;
            nativeSuite = false;
        }
        Map result = ctx.getSuite().getResults();
        for (Map.Entry entry : result.entrySet()) {
            ISuiteResult sr = (ISuiteResult)entry.getValue();
            testsPassed += sr.getTestContext().getPassedTests().size();
            testsFailed += sr.getTestContext().getFailedTests().size();
        }
        Path jsonResultsPath = Paths.get(ctx.getOutputDirectory(), new String[0]).getParent().resolve("ats-results.json");
        int testsFiltered = testsCount - testsPassed - testsFailed;
        String suiteName = ctx.getSuite().getName();
        JsonObject logs = new JsonObject();
        logs.addProperty("name", suiteName);
        logs.addProperty("passed", (Number)testsPassed);
        logs.addProperty("failed", (Number)testsFailed);
        logs.addProperty("filtered", (Number)testsFiltered);
        try {
            this.saveJsonData(jsonResultsPath, ctx.getSuite().getName(), testsCount, testsPassed, testsFailed, testsFiltered, nativeSuite, this.startTime);
            this.getLogger().sendInfo("save ATS results", jsonResultsPath.toString());
        }
        catch (JsonIOException | IOException e) {
            e.printStackTrace();
        }
        this.getLogger().sendScriptSuite(logLabel + " -> " + logs.toString());
        if (Collector.isOpenTelemetryEnabled()) {
            this.getLogger().sendScriptSuite("OpenTelemetry is enabled, collecting data results ...");
            Collector collector = Collector.getDefault();
            collector.addCount("tests-count", testsPassed + testsFailed);
            collector.addCount("tests-passed", testsPassed);
            collector.addCount("tests-failed", testsFailed);
            collector.close();
        }
    }

    private void saveJsonData(Path path, String name, int count, int passed, int failed, int filtered, boolean nativeSuite, long started) throws JsonIOException, IOException {
        Gson gson = new Gson();
        SuiteResultCollection collection = null;
        try {
            collection = (SuiteResultCollection)gson.fromJson((Reader)new BufferedReader(new FileReader(path.toString())), SuiteResultCollection.class);
        }
        catch (FileNotFoundException e) {
            collection = new SuiteResultCollection();
        }
        collection.addSuiteResult(name, count, passed, failed, filtered, nativeSuite, started);
        try (FileWriter writer = new FileWriter(path.toString());){
            gson.toJson((Object)collection, (Appendable)writer);
            writer.flush();
            writer.close();
        }
    }

    @BeforeClass(alwaysRun=true)
    public void beforeClass(ITestContext ctx) {
        int reportNum;
        this.started = System.currentTimeMillis();
        TestRunner runner = (TestRunner)ctx;
        String suiteName = ctx.getSuite().getName();
        this.verbosity = ctx.getSuite().getXmlSuite().getVerbose();
        this.suiteOutputPath = Paths.get(runner.getOutputDirectory(), new String[0]);
        SuitesReportItem currentSuite = new SuitesReportItem(runner);
        AtsSingleton.getInstance().updateLogger(this.scriptHeader.getLogsType(), this.suiteOutputPath.getParent());
        this.setDateOrder(currentSuite.getDateOrder());
        if (currentSuite.isSubScriptIteration()) {
            this.setTestName(this.getClass().getName() + "-" + ctx.getName());
            this.testParameters = runner.getTest().getLocalParameters();
        } else {
            this.testParameters = ctx.getSuite().getXmlSuite().getParameters();
            this.setTestName(this.getClass().getName());
        }
        AtsSingleton.getInstance().addCalledScript(this, this.getCanonicalName());
        if (AtsSingleton.getInstance().getAtsError() != null) {
            this.getLogger().sendInfo("ActionTestScript properties file found, but an error occured !", AtsSingleton.getInstance().getAtsError());
        }
        this.status = new ScriptStatus(this.getTestName(), suiteName);
        if ("true".equalsIgnoreCase(runner.getTest().getParameter("check.mode"))) {
            throw new SkipException("check mode : " + this.getTestName());
        }
        Map params = runner.getTest().getAllParameters();
        this.setTestExecutionVariables(params);
        String atsReportEnv = this.getEnvironmentValue("ATS_REPORT", "").toLowerCase(Locale.ROOT);
        String cmdATSReport = this.getEnvironmentValue("ats-report", "").toLowerCase(Locale.ROOT);
        int devReport = 0;
        if (!atsReportEnv.isEmpty()) {
            try {
                reportNum = Integer.parseInt(atsReportEnv);
                if (reportNum > 0 && reportNum < 4) {
                    devReport = Utils.string2Int(atsReportEnv, 0);
                }
            }
            catch (NumberFormatException e) {
                this.getLogger().sendError("parameter can not be interpreted as number", "-1");
            }
        }
        if (!cmdATSReport.isEmpty()) {
            try {
                reportNum = Integer.parseInt(cmdATSReport);
                if (reportNum > 0 && reportNum < 4) {
                    devReport = Utils.string2Int(cmdATSReport, 0);
                }
            }
            catch (NumberFormatException e) {
                this.getLogger().sendError("parameter can not be interpreted as number", "-1");
            }
        }
        this.xmlPic = devReport > 2;
        System.setProperty("ats-report", Integer.toString(devReport));
        int mgtReport = trueList.indexOf(this.getEnvironmentValue("mgt-report", "").toLowerCase(Locale.ROOT)) > -1 ? 1 : 0;
        System.setProperty("mgt-report", Integer.toString(mgtReport));
        int validReport = trueList.indexOf(this.getEnvironmentValue("validation-report", "").toLowerCase(Locale.ROOT)) > -1 ? 1 : 0;
        System.setProperty("validation-report", Integer.toString(validReport));
        boolean xml = trueList.indexOf(this.getEnvironmentValue("xml.report", "").toLowerCase(Locale.ROOT)) > -1;
        int visualQuality = currentSuite.getVisualQuality();
        if (devReport + mgtReport + validReport != 0 || currentSuite.isReporting()) {
            if (visualQuality == 0) {
                visualQuality = 3;
            }
            xml = true;
        }
        JsonObject logs = new JsonObject();
        logs.addProperty("name", this.getTestName());
        logs.addProperty("suite", suiteName);
        logs.addProperty("xmlReport", Boolean.valueOf(xml));
        logs.addProperty("visualQuality", (Number)visualQuality);
        ScriptHeader header = null;
        if (currentSuite.isSubScriptIteration()) {
            params.remove("ats-callscript-iteration");
            params.remove("ats-callscript-parameters");
            int iteration = Utils.string2Int((String)params.remove("ats-iteration"));
            int iterationsCount = Utils.string2Int((String)params.remove("ats-iteration-count"));
            logs.addProperty("iteration", (Number)iteration);
            logs.addProperty("iterationsCount", (Number)iterationsCount);
            this.updateIterationData(iteration, iterationsCount);
            ParameterList parameterList = new ParameterList(iteration);
            header = this.getScriptHeader();
            int i = 0;
            boolean numParamExist = true;
            while (numParamExist) {
                if (params.containsKey("#" + i)) {
                    parameterList.addParameter(new Parameter(i, new CalculatedValue((String)params.get("#" + i))));
                    params.remove("#" + i);
                    ++i;
                    continue;
                }
                numParamExist = false;
            }
            for (Map.Entry entry : params.entrySet()) {
                parameterList.addParameter(new Parameter(i, (String)entry.getKey(), (String)entry.getValue()));
                if (COLUMN_TEST_ID.equals(entry.getKey())) {
                    header.setId((String)entry.getValue());
                } else if (COLUMN_TEST_DESCRIPTION.equals(entry.getKey())) {
                    header.setDescription((String)entry.getValue());
                } else if (COLUMN_TEST_EXTERNAL.equals(entry.getKey())) {
                    header.setExternalId((String)entry.getValue());
                } else if (COLUMN_TEST_PREREQUISITE.equals(entry.getKey())) {
                    header.setPrerequisite((String)entry.getValue());
                }
                ++i;
            }
            this.setParameterList(parameterList);
        } else {
            Properties parametersProperties = new Properties();
            JsonObject parametersObject = new JsonObject();
            for (Map.Entry param : params.entrySet()) {
                String k = (String)param.getKey();
                String v = this.getEnvironmentValue(k, (String)param.getValue());
                parametersProperties.put(k, v);
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty(k, v);
                parametersObject.addProperty(k, v);
            }
            logs.add("parameters", (JsonElement)parametersObject);
            try {
                parametersProperties.store(new FileOutputStream(Paths.get(runner.getOutputDirectory(), SUITE_PARAMETERS).toFile()), null);
            }
            catch (IOException parameterList) {
                // empty catch block
            }
        }
        String testParameters = System.getProperty(TEST_PARAMETERS);
        if (testParameters != null && !testParameters.isBlank()) {
            JsonObject parametersObject = new JsonObject();
            String[] testParametersArray = testParameters.split(",");
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            int loop = 0;
            for (String s : testParametersArray) {
                parameters.add(new Parameter(loop, s));
                parametersObject.addProperty("param" + loop, s);
                ++loop;
            }
            this.setParameterList(new ParameterList(1, parameters));
            logs.add("script-parameters", (JsonElement)parametersObject);
        }
        logs.addProperty("time", (Number)Instant.now().toEpochMilli());
        StringBuilder sb = new StringBuilder("test started").append(" -> ").append(logs.toString());
        this.getHeader().sendPreprocessing(this.getLogger(), suiteName);
        this.getLogger().sendScriptTest(sb.toString());
        File output = new File(runner.getOutputDirectory());
        if (visualQuality > 0 || xml) {
            if (header == null) {
                header = this.getScriptHeader();
            }
            header.setName(this.getTestName());
            if (!output.exists()) {
                output.mkdirs();
            }
            ReportImageFormat imgFormat = new ReportImageFormat();
            this.initRecorder(output, header, xml, currentSuite.isAtsvHtml(), visualQuality, imgFormat);
        }
        this.initShadowScript(header, suiteName);
        String velocity = System.getProperty(EXECUTION_VELOCITY);
        if (velocity == null) {
            velocity = System.getenv(EXECUTION_VELOCITY);
        }
        AtsSingleton.getInstance().setVelocitylevel(velocity);
        this.topScript.setAtsLearning(new AtsLearning(this.suiteOutputPath));
        if ("true".equals(System.getProperty(TEST_STOPPABLE))) {
            this.getLogger().sendScriptInfo("this script can be stopped if 'q' is sent to 'System.in' stream");
            new StopExecutionThread(this, System.in).start();
        }
    }

    private void setAtsLearning(AtsLearning value) {
        this.atsLearning = value;
    }

    public void saveAtsLearning(TestElement testElement, IDriverEngine engine, SearchedElement searchedElement) {
        this.atsLearning.saveAtsLearning(testElement, engine, searchedElement);
    }

    private void closeAtsLearning() {
        this.atsLearning.terminate();
    }

    @AfterClass(alwaysRun=true)
    public void afterClass(ITestContext ctx) {
        TestRunner runner = (TestRunner)ctx;
        this.getTopScript().closeAtsLearning();
        this.status.endLogs(this, runner);
    }

    @AfterMethod(alwaysRun=true)
    public void cleanup() {
        if (this.status.getCallscriptStack() != null) {
            this.getLogger().sendScriptError("callscripts error", this.status.getCallscriptStack());
        }
        this.stopRecorder(false);
        AtsSingleton.getInstance().closeChannels(new ActionStatus(), this.getChannels());
        this.getTopScript().closeAtsLearning();
    }

    public void startChannel(String name) {
        this.topScript.channels.add(name);
    }

    public List<String> getChannels() {
        return this.topScript.channels;
    }

    public ParameterElement getParameterElement() {
        return this.parameterElement;
    }

    public ActionTestScript getTopScript() {
        return this.topScript;
    }

    public String getCanonicalName() {
        return this.getClass().getCanonicalName();
    }

    public void initCalledScript(ActionCallscript action, ActionTestScript atsCaller, String testName, int line, ParameterList parameters, List<Variable> variables, int iter, int iterCount, String scriptName, String type, String path) {
        this.parameterElement = null;
        if (parameters != null) {
            this.parameterElement = parameters.getElement();
        }
        this.iteration = iter;
        this.iterationsCount = iterCount;
        this.csvAbsoluteFilePath = path;
        this.setTestName(this.getClass().getName());
        JsonObject log = action.getConditionLogs();
        log.addProperty("called", scriptName);
        log.addProperty("iteration", this.iteration + "/" + this.iterationsCount);
        log.addProperty("type", type);
        if (this.csvAbsoluteFilePath != null) {
            log.addProperty("url", this.csvAbsoluteFilePath);
        }
        if (parameters != null) {
            this.setParameterList(parameters);
            if (parameters.getList().size() > 0) {
                JsonArray parametersArray = new JsonArray();
                for (Parameter p : parameters.getList()) {
                    JsonObject jso = new JsonObject();
                    Object calc = p.getCalculated();
                    if ("src".equals(p.getName())) {
                        if (((String)calc).startsWith("data:image") && ((String)calc).length() > 50) {
                            calc = ((String)calc).substring(0, 50) + " ...";
                        }
                    } else if ("text".equals(p.getName()) && ((String)calc).length() > 50) {
                        calc = ((String)calc).substring(0, 50) + " ...";
                    }
                    jso.addProperty(p.getName(), (String)calc);
                    parametersArray.add((JsonElement)jso);
                }
                JsonObject parametersData = new JsonObject();
                if (this.parameterElement != null) {
                    parametersData.addProperty("element", this.parameterElement.getTag());
                    parametersData.add("values", (JsonElement)parametersArray);
                    log.add("parameters", (JsonElement)parametersData);
                } else {
                    log.add("parameters", (JsonElement)parametersArray);
                }
            }
        }
        if (variables != null) {
            this.setVariables(variables);
        }
        this.setTestExecutionVariables(this.topScript.getTestExecutionVariables());
        this.topScript.getLogger().sendScriptInfo(ActionCallscript.getScriptLog(testName, line, log));
    }

    public void setDateOrder(String value) {
        if (this.topScript != null) {
            this.topScript.dateOrder = value;
        }
    }

    public String getDateOrder() {
        if (this.topScript != null) {
            return this.topScript.dateOrder;
        }
        return "";
    }

    public String getTopScriptName() {
        if (this.topScript != null) {
            return this.topScript.getTestName();
        }
        return this.getTestName();
    }

    public void setProjectData(Project value) {
        this.projectData = value;
        this.projectData.synchronize();
        this.passwords = new Passwords(this.projectData.getAssetsFolderPath().toFile());
    }

    public Variable var(String name, CalculatedValue value) {
        return this.createVariable(name, value, null, false);
    }

    public Variable var(String name) {
        return this.createVariable(name, new CalculatedValue(""), null, false);
    }

    public Variable var(String name, Transformer transformer) {
        return this.createVariable(name, new CalculatedValue(""), transformer, false);
    }

    public Variable var(String name, CalculatedValue value, Transformer transformer) {
        return this.createVariable(name, value, transformer, false);
    }

    public String gvar(String varPath) {
        return this.topScript.getGlobalVariableValue(varPath);
    }

    public void addSummary(ActionComment action) {
        this.getTopScript().summaryStack(action.getComment().getCalculated());
    }

    public CalculatedValue clv(Object ... data) {
        return new CalculatedValue(this, data);
    }

    public TableSplit split(String row, String col, CalculatedValue value) {
        return new TableSplit(row, col, value);
    }

    public String prm(String name) {
        return this.getParameterValue(name);
    }

    public String prm(String name, String defaultValue) {
        return this.getParameterValue(name, defaultValue);
    }

    public String prm(int index) {
        return this.getParameterValue(index);
    }

    public String prm(int index, String defaultValue) {
        return this.getParameterValue(index, defaultValue);
    }

    public CalculatedValue[] prm(CalculatedValue ... values) {
        return values;
    }

    public void rtn(CalculatedValue ... values) {
        int i = 0;
        this.retVals = new String[values.length];
        for (CalculatedValue calc : values) {
            this.retVals[i] = calc.getCalculated();
            ++i;
        }
        this.updateVariables();
    }

    public void rtn(String ... values) {
        int i = 0;
        this.retVals = new String[values.length];
        String[] stringArray = values;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String value;
            this.retVals[i] = value = stringArray[j];
            ++i;
        }
        this.updateVariables();
    }

    private void updateVariables() {
        List<Variable> variables = this.getVariables();
        int index = 0;
        for (String value : this.retVals) {
            if (variables.size() < index + 1) break;
            variables.get(index).setData(value);
            ++index;
        }
    }

    public void ats_return(String ... values) {
        this.retVals = values;
        this.updateVariables();
    }

    public void ats_return(Object ... values) {
        this.retVals = (String[])Arrays.stream(values).map(Object::toString).toArray(String[]::new);
        this.updateVariables();
    }

    public void returnValues(String ... values) {
        this.retVals = values;
        this.updateVariables();
    }

    public void returnValues(Object ... values) {
        this.retVals = (String[])Arrays.stream(values).map(Object::toString).toArray(String[]::new);
        this.updateVariables();
    }

    public String rds(int len) {
        return new RandomStringValue(len, null).exec();
    }

    public String rds(int len, String type) {
        return new RandomStringValue(len, type).exec();
    }

    public String env(String name) {
        return this.getEnvironmentValue(name, "");
    }

    public String env(String name, String defaultValue) {
        return this.getEnvironmentValue(name, defaultValue);
    }

    public String pt(String file, String name) {
        return this.getPropertyVariableValue(file, name);
    }

    public String ct(String ... data) {
        if (data != null && data.length > 0) {
            return String.join((CharSequence)"", data);
        }
        return "";
    }

    public String prj(String name, String defaultValue) {
        return this.getProjectVariableValue(name, defaultValue);
    }

    public String prj(String name) {
        return this.getProjectVariableValue(name);
    }

    public String sys(String name) {
        return AtsSingleton.getInstance().getSystemValue(name);
    }

    public CalculatedProperty prp(String type, String name, CalculatedValue value) {
        return new CalculatedProperty(type, name, value);
    }

    public ApiData prp(String name, CalculatedValue value) {
        return new ApiData(name, value);
    }

    public String uid() {
        return this.getUuidValue();
    }

    public String td() {
        return this.getTodayValue();
    }

    public String lad() {
        return String.valueOf(this.getLastActionDuration());
    }

    public String nw() {
        return this.getNowValue();
    }

    public int itr() {
        return this.getIteration();
    }

    public int itc() {
        return this.getIterationsCount();
    }

    public SearchedElement el(SearchedElement parent, CalculatedValue index, boolean shadow, String tagName, CalculatedProperty ... properties) {
        return new SearchedElement(parent, index, shadow, tagName, properties);
    }

    public SearchedElement el(CalculatedValue index, boolean shadow, String tagName, CalculatedProperty ... properties) {
        return new SearchedElement(null, index, shadow, tagName, properties);
    }

    public SearchedElement el(SearchedElement parent, CalculatedValue index, boolean shadow, String tagName) {
        return new SearchedElement(parent, index, shadow, tagName);
    }

    public SearchedElement el(CalculatedValue index, boolean shadow, String tagName) {
        return new SearchedElement(null, index, shadow, tagName);
    }

    public SearchedElement el(String xpath) {
        return new SearchedElement(this, xpath);
    }

    public RegexpTransformer rx(String patt, int[] group) {
        return new RegexpTransformer(patt, group);
    }

    public DateTransformer dt(String ... data) {
        DateTransformer dtr = new DateTransformer(data);
        dtr.setDateOrder(this.getDateOrder());
        return dtr;
    }

    public TimeTransformer tm(String ... data) {
        return new TimeTransformer(data);
    }

    public NumericTransformer nm(int dp, boolean comma) {
        return new NumericTransformer(dp, comma);
    }

    public EvalTransformer sc(String code) {
        return new EvalTransformer(code);
    }

    public MouseDirectionData ps(Cartesian cart, CalculatedValue value) {
        return new MouseDirectionData(cart, value);
    }

    public Mouse ms(String type) {
        return new Mouse(type);
    }

    public Mouse ms(String type, MouseDirectionData hpos, MouseDirectionData vpos) {
        return new Mouse(type, hpos, vpos);
    }

    public MouseKey ms(String type, Keys key, MouseDirectionData hpos, MouseDirectionData vpos) {
        return new MouseKey(type, key, hpos, vpos);
    }

    public MouseKey ms(String type, Keys key) {
        return new MouseKey(type, key);
    }

    public MouseScroll ms(int scroll, MouseDirectionData hpos, MouseDirectionData vpos) {
        return new MouseScroll(scroll, hpos, vpos);
    }

    public MouseScroll ms(int scroll) {
        return new MouseScroll(scroll);
    }

    public MouseSwipe ms(MouseDirectionData hdir, MouseDirectionData vdir, MouseDirectionData hpos, MouseDirectionData vpos) {
        return new MouseSwipe(hdir, vdir, hpos, vpos);
    }

    public MouseSwipe ms(MouseDirectionData hdir, MouseDirectionData vdir) {
        return new MouseSwipe(hdir, vdir);
    }

    public String emb(String relativePath) {
        return this.getAssetsUrl(relativePath);
    }

    public String ats(String key) {
        return this.getTopScript().getSpecialValue(key);
    }

    public ExecuteOptions opt(CalculatedValue code) {
        return new ExecuteOptions(code);
    }

    public ExecuteOptions opt(CalculatedValue code, boolean escapeQuote) {
        return new ExecuteOptions(code, escapeQuote);
    }

    public ExecuteOptions opt() {
        return new ExecuteOptions();
    }

    public void exec(int line, Action action) {
        if (action instanceof ActionCondition) {
            this.exec(line, (ActionCondition)action);
        } else if (action instanceof ActionNetwork) {
            ((ActionNetwork)action).execute(this, this.getTestName(), line, 0);
        }
    }

    public void exec(int line, ActionComment action) {
        action.execute(this, this.getTestName(), line, 0);
        if (action.isPassed()) {
            this.getLogger().sendAction(action, this.getTestName(), line);
        }
    }

    public void exec(int line, ActionCondition action) {
        if (action.getCondition().isPassed()) {
            action.execute(this, this.getTestName(), line, 0);
            this.getTopScript().actionFinished(this.getTestName(), line, action);
        }
    }

    public void exec(int line, ActionCallscript action) {
        if (action.getCondition().isPassed()) {
            try {
                action.execute(this, this.getTestName(), line, 0);
                if (action.isPassed()) {
                    action.getStatus().setMessage(action.getCalledScriptLogs());
                    this.getTopScript().actionFinished(this.getTestName(), line, action);
                } else {
                    this.actionFinishedFail(action.getStatus(), action, line, this.getTestName(), TestError.TestErrorStatus.FAIL_STOP);
                    this.getTopScript().getRecorder().updateSummaryFail(this.getTestName(), line, "subString", action.getStatus().getFailMessage(), TestError.TestErrorStatus.FAIL_STOP);
                }
            }
            catch (AssertionError e) {
                ActionStatus ast = action.getStatus();
                ast.setError(-18, ((Throwable)((Object)e)).getMessage());
                this.actionFinishedFail(ast, action, line, this.getTestName(), TestError.TestErrorStatus.FAIL_STOP);
                this.getTopScript().getRecorder().updateSummaryFail(this.getTestName(), line, ast.getChannelApplication(), ast.getFailMessage(), TestError.TestErrorStatus.FAIL_STOP);
                this.scriptFail(ast.getFailMessage());
            }
        }
    }

    public void exec(int line, ActionExecute action) {
        if (action.getCondition().isPassed()) {
            action.execute(this, this.getTestName(), line, 0);
            this.getTopScript().actionFinished(this.getTestName(), line, action, action.getStopPolicy());
        }
    }

    public static Date getIsoDate(String value) {
        return Utils.parseDateFormat(value);
    }

    public void startChannelFailed(String testName, int testLine, String appName, String failMessage) {
        this.failedAt(ActionChannelStart.class.getSimpleName(), testName, testLine, appName, -19, failMessage);
        this.getRecorder().updateSummaryFail(testName, testLine, appName, failMessage, TestError.TestErrorStatus.FAIL_STOP);
    }

    public void callScriptFailed(String calledScsript, String testName, int testLine, int errorNum, String failMessage, long duration) {
        this.failedAt(ActionCallscript.class.getSimpleName(), testName, testLine, "", errorNum, failMessage);
        this.getRecorder().updateSummaryFail(testName, testLine, "", failMessage, TestError.TestErrorStatus.FAIL_STOP);
        this.getRecorder().update(errorNum, duration, calledScsript, failMessage);
        this.status.addErrorStack(failMessage);
        StringBuilder sb = new StringBuilder(testName).append(":").append(testLine);
        this.status.addErrorStack(sb.toString());
        this.getLogger().sendScriptError(failMessage, testName + ":" + testLine);
        this.scriptFail(failMessage);
    }

    public void failedAt(String action, String testName, int line, String app, int errorCode, String errorMessage) {
        this.status.failedAt(action, testName, line, app, errorCode, errorMessage);
        this.getLogger().sendScriptFail(action, testName, line, app, errorMessage);
    }

    public void actionFinished(String testName, int line, ActionCondition action) {
        this.actionFinished(testName, line, action, 0);
    }

    public void actionFinished(String testName, int line, ActionCondition action, int stopPolicy) {
        ActionStatus actionStatus;
        if (!action.getCondition().isPassed()) {
            return;
        }
        if (!(action instanceof ActionCallscript)) {
            this.status.addAction();
        }
        if ((actionStatus = action.getStatus()).isPassed()) {
            this.getLogger().sendAction(action, testName, line);
        } else if (stopPolicy == 0) {
            if (this.actionFinishedFail(actionStatus, action, line, testName, TestError.TestErrorStatus.FAIL_STOP)) {
                AtsSingleton.getInstance().getCurrentChannel().addShadowActionError(action, line, TestError.TestErrorStatus.FAIL_STOP);
                throw new AtsFailError(action, testName, line, this.status.getErrorScript(), this.status.getErrorInfo(), this.getLogger());
            }
        } else {
            this.getLogger().sendAction(action, testName, line);
            if (stopPolicy == 2) {
                this.actionFinishedFail(actionStatus, action, line, testName, TestError.TestErrorStatus.FAIL_CONTINUE);
            } else if (stopPolicy == 1) {
                this.actionFinishedFailPass(actionStatus, line, testName, action.getScript().getTimeLine());
            }
        }
    }

    private void actionFinishedFailPass(ActionStatus actionStatus, int line, String testName, long timeline) {
        this.getRecorder().updateSummaryFailPass(testName, line, actionStatus.getFailMessage(), TestError.TestErrorStatus.FAIL_PASS);
    }

    private boolean actionFinishedFail(ActionStatus actionStatus, Action action, int line, String testName, TestError.TestErrorStatus testErrorStatus) {
        if (this.status.isSuiteExecution()) {
            String app = actionStatus.getChannelApplication();
            String errorMessage = actionStatus.getFailMessage();
            this.getTopScript().failedAt(action.getClass().getSimpleName(), testName, line, app, actionStatus.getCode(), errorMessage);
            this.getRecorder().updateSummaryFail(testName, line, app, errorMessage, testErrorStatus);
            return true;
        }
        return false;
    }

    public Channel getCurrentChannel() {
        return AtsSingleton.getInstance().getCurrentChannel(this);
    }

    public void startDrag() {
        this.topScript.dragWithDesktop = AtsSingleton.getInstance().isDesktopChannel();
    }

    public boolean isDesktopDragDrop() {
        return this.topScript.dragWithDesktop;
    }

    public void endDrag() {
        this.topScript.dragWithDesktop = false;
    }

    public void initRecorder(File output, ScriptHeader header, boolean xml, boolean atsvHtml, int visualQuality, ReportImageFormat imgFormat) {
        this.setRecorder(new VisualRecorder(this, output, header, xml, atsvHtml, visualQuality, this.getLogger(), imgFormat, this.xmlPic));
    }

    private void initRecorder(ScriptHeader info, Project projectData, boolean xml, boolean atsvHtml, int quality, ReportImageFormat reportImageFormat, boolean xmlPic2) {
        this.setRecorder(new VisualRecorder(this, info, projectData, xml, atsvHtml, quality, new ReportImageFormat(), this.xmlPic));
    }

    public IVisualRecorder getRecorder() {
        return this.topScript.recorder;
    }

    public void setRecorder(IVisualRecorder value) {
        if (value instanceof VisualRecorderNull && this.recorder instanceof VisualRecorder || value instanceof VisualRecorder && this.recorder instanceof VisualRecorderNull) {
            this.topScript.recorder.terminate();
            this.topScript.recorder = value;
        }
    }

    public void startRecorder(ScriptHeader info, int quality, boolean xml, boolean atsvHtml) {
        this.topScript.initRecorder(info, this.projectData, xml, atsvHtml, quality, new ReportImageFormat(), this.xmlPic);
    }

    public void startRecorder(Channel channel, SystemDriver systemDriver) {
        systemDriver.startVisualRecord(channel, this.getScriptHeader(), 10, 0L);
    }

    public void stopRecorder() {
        this.stopRecorder(false);
    }

    public void stopRecorder(boolean asAsSuite) {
        if (asAsSuite) {
            this.recorder.terminateAsSuite();
        }
        this.topScript.setRecorder(new VisualRecorderNull());
    }
}

