/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers;

import com.ats.AtsSingleton;
import com.ats.driver.ApplicationProperties;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.executor.channels.MobileChannel;
import com.ats.executor.channels.MobileChromeChannel;
import com.ats.executor.drivers.DriverInfo;
import com.ats.executor.drivers.DriverInfoApi;
import com.ats.executor.drivers.DriverInfoDesktop;
import com.ats.executor.drivers.DriverInfoGrid;
import com.ats.executor.drivers.DriverInfoMobile;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.RemoteDriverInfo;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.ApiDriverEngine;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.executor.drivers.engines.MobileDriverEngine;
import com.ats.executor.drivers.engines.SapDriverEngine;
import com.ats.executor.drivers.engines.SystemDriverEngine;
import com.ats.executor.drivers.engines.browsers.BraveDriverEngine;
import com.ats.executor.drivers.engines.browsers.ChromeDriverEngine;
import com.ats.executor.drivers.engines.browsers.ChromiumDriverEngine;
import com.ats.executor.drivers.engines.browsers.FirefoxDriverEngine;
import com.ats.executor.drivers.engines.browsers.IEDriverEngine;
import com.ats.executor.drivers.engines.browsers.MsEdgeDriverEngine;
import com.ats.executor.drivers.engines.browsers.OperaDriverEngine;
import com.ats.executor.drivers.engines.browsers.SafariDriverEngine;
import com.ats.executor.drivers.engines.desktop.ExplorerDriverEngine;
import com.ats.executor.drivers.engines.mobiles.MobileChromeDriverEngine;
import java.util.ArrayList;

public class DriverManager {
    public static final String CHROME_BROWSER = "chrome";
    public static final String BRAVE_BROWSER = "brave";
    public static final String CHROMIUM_BROWSER = "chromium";
    public static final String FIREFOX_BROWSER = "firefox";
    public static final String IE_BROWSER = "ie";
    public static final String MSEDGE_BROWSER = "msedge";
    public static final String OPERA_BROWSER = "opera";
    public static final String SAFARI_BROWSER = "safari";
    public static final String SAP_DRIVER = "sap";
    private ArrayList<MobileDriverEngine> mobileDrivers = new ArrayList();

    public IDriverEngine getDriverEngine(Channel channel, ActionStatus status, SystemDriver systemDriver, ActionTestScript script) {
        String application = channel.getApplication();
        ApplicationProperties props = AtsSingleton.getInstance().getApplicationProperties(application);
        String appName = props.getName().toLowerCase();
        boolean enableAtsLearning = true;
        if (CHROME_BROWSER.equals(appName)) {
            IDriverInfo systemDriverInfo = this.getRemoteDriverInfo(status, systemDriver, appName, props.getUri(), script);
            if (status.isPassed()) {
                return new ChromeDriverEngine(channel, status, systemDriverInfo, systemDriver, props, enableAtsLearning);
            }
            return null;
        }
        if (MSEDGE_BROWSER.equals(appName)) {
            IDriverInfo systemDriverInfo = this.getRemoteDriverInfo(status, systemDriver, appName, props.getUri(), script);
            if (status.isPassed()) {
                return new MsEdgeDriverEngine(channel, status, systemDriverInfo, systemDriver, props, enableAtsLearning);
            }
            return null;
        }
        if (BRAVE_BROWSER.equals(appName)) {
            DriverInfo systemDriverInfo = this.getSystemDriverInfo(status, systemDriver, appName, props.getUri(), script);
            if (status.isPassed()) {
                return new BraveDriverEngine(channel, status, systemDriverInfo, systemDriver, props, enableAtsLearning);
            }
            return null;
        }
        if (OPERA_BROWSER.equals(appName)) {
            DriverInfo systemDriverInfo = this.getSystemDriverInfo(status, systemDriver, appName, props.getUri(), script);
            if (status.isPassed()) {
                return new OperaDriverEngine(channel, status, systemDriverInfo, systemDriver, props, enableAtsLearning);
            }
            return null;
        }
        if (FIREFOX_BROWSER.equals(appName)) {
            IDriverInfo systemDriverInfo = this.getRemoteDriverInfo(status, systemDriver, appName, props.getUri(), script);
            if (status.isPassed()) {
                return new FirefoxDriverEngine(channel, status, systemDriverInfo, systemDriver, props, enableAtsLearning);
            }
            return null;
        }
        if (SAFARI_BROWSER.equals(appName)) {
            DriverInfo systemDriverInfo = this.getSystemDriverInfo(status, systemDriver, appName, props.getUri(), script);
            if (status.isPassed()) {
                return new SafariDriverEngine(channel, status, systemDriverInfo, systemDriver, props, enableAtsLearning);
            }
            return null;
        }
        if (IE_BROWSER.equals(appName)) {
            IDriverInfo systemDriverInfo = this.getRemoteDriverInfo(status, systemDriver, appName, props.getUri(), script);
            if (status.isPassed()) {
                return new IEDriverEngine(channel, status, systemDriverInfo, systemDriver, props, enableAtsLearning);
            }
            return null;
        }
        if (CHROMIUM_BROWSER.equals(appName)) {
            if (props.getDriver() != null && props.getUri() != null) {
                IDriverInfo systemDriverInfo = this.getRemoteDriverInfo(status, systemDriver, appName, props.getUri(), script);
                if (status.isPassed()) {
                    return new ChromiumDriverEngine(channel, status, props.getName(), systemDriverInfo, systemDriver, props, enableAtsLearning);
                }
                return null;
            }
            status.setError(-19, "missing Chromium properties ('path' and 'driver') in .atsProperties file");
            return null;
        }
        enableAtsLearning = false;
        if (props.isSap() || application.toLowerCase().startsWith("sap://")) {
            DriverInfo systemDriverInfo = this.getSystemDriverInfo(status, systemDriver, SAP_DRIVER, props.getUri(), script);
            if (status.isPassed()) {
                return new SapDriverEngine(channel, status, application, systemDriverInfo, systemDriver, props, enableAtsLearning);
            }
            return null;
        }
        if (channel instanceof MobileChannel) {
            String token = this.getChannelToken(application);
            MobileDriverEngine mobileDriverEngine = new MobileDriverEngine((MobileChannel)channel, status, application, new DriverInfo(application, script), systemDriver, props, token, enableAtsLearning);
            if (status.isPassed()) {
                this.mobileDrivers.add(mobileDriverEngine);
            }
            if (channel instanceof MobileChromeChannel) {
                return new MobileChromeDriverEngine((MobileChromeChannel)channel, status, new DriverInfoMobile(application), systemDriver, mobileDriverEngine, props, enableAtsLearning);
            }
            return mobileDriverEngine;
        }
        if (props.isApi() || application.startsWith("http://") || application.startsWith("https://")) {
            return new ApiDriverEngine(channel, status, application, new DriverInfoApi(application), systemDriver, props, script, enableAtsLearning);
        }
        if ("explorer".equals(appName)) {
            return new ExplorerDriverEngine(channel, status, new DriverInfoDesktop(appName, "explorer"), systemDriver, props, enableAtsLearning);
        }
        return new SystemDriverEngine(channel, status, application, new DriverInfoDesktop(appName, "desktop"), systemDriver, props, enableAtsLearning);
    }

    private String getChannelToken(String applicationPath) {
        int start = applicationPath.indexOf("://");
        if (start > -1) {
            applicationPath = applicationPath.substring(start + 3);
        }
        String[] appData = applicationPath.split("/");
        String endPoint = appData[0];
        for (MobileDriverEngine engine : this.mobileDrivers) {
            if (!engine.getEndPoint().equals(endPoint)) continue;
            this.mobileDrivers.remove(engine);
            return engine.getToken();
        }
        return null;
    }

    private IDriverInfo getRemoteDriverInfo(ActionStatus status, SystemDriver sysDriver, String driverName, String appPath, ActionTestScript script) {
        String gridUri = System.getProperty("ats-grid-endpoint");
        if (gridUri != null) {
            return new DriverInfoGrid(driverName, gridUri, script);
        }
        return this.getSystemDriverInfo(status, sysDriver, driverName, appPath, script);
    }

    private DriverInfo getSystemDriverInfo(ActionStatus status, SystemDriver sysDriver, String driverName, String appPath, ActionTestScript script) {
        RemoteDriverInfo remoteDriver = sysDriver.getRemoteDriver(status, driverName, appPath);
        if (remoteDriver != null && remoteDriver.getDriverUri() != null) {
            status.setNoError();
            return new DriverInfo(driverName, remoteDriver, script);
        }
        if (status.isPassed()) {
            status.setError(-19, "unable to get remote driver url -> " + driverName);
        }
        return null;
    }

    public void tearDown() {
        while (this.mobileDrivers.size() > 0) {
            this.mobileDrivers.remove(0).tearDown();
        }
    }
}

