/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines;

import com.ats.data.Dimension;
import com.ats.data.Point;
import com.ats.data.Rectangle;
import com.ats.driver.ApplicationProperties;
import com.ats.driver.AtsRemoteWebDriver;
import com.ats.element.FoundElement;
import com.ats.element.ParameterElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.generator.objects.BoundData;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.graphic.ImageTemplateMatchingSimple;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;

public abstract class DriverEngine {
    protected Channel channel;
    protected AtsRemoteWebDriver driver;
    private SystemDriver systemDriver;
    private IDriverInfo driverInfo;
    protected String applicationPath;
    private int actionWait = -1;
    private int propertyWait = -1;
    private boolean enableLearning = false;

    public boolean isEnableLearning() {
        return this.enableLearning;
    }

    public DriverEngine(Channel channel, boolean enableLearning) {
        this.channel = channel;
        this.enableLearning = enableLearning;
    }

    public DriverEngine(Channel channel, IDriverInfo driverInfo, SystemDriver systemDriver, boolean enableLearning) {
        this(channel, enableLearning);
        this.setDriverInfo(driverInfo);
        this.setSystemEngine(systemDriver);
        channel.setDriverUrl(driverInfo.getDriverHostAndPort().toString());
    }

    public DriverEngine(Channel channel, SystemDriver systemDriver, IDriverInfo driverInfo, ApplicationProperties props, boolean enableLearning) {
        this(channel, driverInfo, systemDriver, enableLearning);
    }

    public DriverEngine(Channel channel, IDriverInfo driverInfo, SystemDriver systemDriver, ApplicationProperties props, int defaultWait, int defaultCheck, boolean enableLearning) {
        this(channel, driverInfo, systemDriver, enableLearning);
        this.actionWait = props.getWait();
        this.propertyWait = props.getCheck();
        this.applicationPath = props.getUri();
        if (this.actionWait == -1) {
            this.actionWait = defaultWait;
        }
        if (this.propertyWait == -1) {
            this.propertyWait = defaultCheck;
        }
    }

    public List<FoundElement> findElementByXpath(String xpath) {
        return Collections.emptyList();
    }

    public String getColName(WebElement element) {
        return null;
    }

    public FoundElement getParamElement(ParameterElement elem) {
        return new FoundElement(this.channel, elem.getTag(), elem.getRemoteWebElement(this.driver));
    }

    public void started(ActionTestScript script, ActionStatus status) {
    }

    public void newWindow(ActionStatus status, WindowType type, CalculatedValue url) {
    }

    public boolean isAtsLearningEnabled() {
        return this.enableLearning;
    }

    public String getParentsDomCode(WebElement element) {
        return null;
    }

    public void updateScreenshot(TestBound dimension, boolean isRef) {
        this.getSystemDriver().updateVisualImage(dimension, isRef);
    }

    public String createVisualAction(Channel channel, boolean stop, String actionType, int scriptLine, String scriptName, long timeline, boolean sync) {
        return this.getSystemDriver().createVisualAction(channel, stop, actionType, scriptLine, scriptName, timeline, sync);
    }

    public TestElement getTestElementRoot(ActionTestScript script) {
        return new TestElement(script, this.channel);
    }

    private void setDriverInfo(IDriverInfo value) {
        this.driverInfo = value;
    }

    public IDriverInfo getDriverInfo() {
        return this.driverInfo;
    }

    private void setSystemEngine(SystemDriver value) {
        this.systemDriver = value;
    }

    public SystemDriver getSystemDriver() {
        return this.systemDriver;
    }

    public List<String[]> getWindowsData() {
        return Collections.emptyList();
    }

    public void setDriver(AtsRemoteWebDriver driver) {
        this.driver = driver;
    }

    public AtsRemoteWebDriver getAtsRemoteDriver() {
        return this.driver;
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public void actionWait() {
        this.channel.sleep(this.actionWait);
    }

    public int getActionWait() {
        return this.actionWait;
    }

    public int getPropertyWait() {
        return this.propertyWait;
    }

    protected double getCartesianOffset(double value, MouseDirectionData direction, Cartesian cart1, Cartesian cart2, Cartesian cart3) {
        if (direction != null) {
            if (cart1.equals(direction.getName())) {
                return direction.getIntValue() + 1;
            }
            if (cart3.equals(direction.getName())) {
                return value - direction.getDoubleValue() - 2.0;
            }
            return direction.getDoubleValue() + value / 2.0;
        }
        return value / 2.0;
    }

    public double getOffsetX(Rectangle rect, MouseDirection position) {
        return this.getCartesianOffset(rect.getWidth(), position.getHorizontalPos(), Cartesian.LEFT, Cartesian.CENTER, Cartesian.RIGHT);
    }

    public double getOffsetY(Rectangle rect, MouseDirection position) {
        return this.getCartesianOffset(rect.getHeight(), position.getVerticalPos(), Cartesian.TOP, Cartesian.MIDDLE, Cartesian.BOTTOM);
    }

    public String setWindowBound(BoundData x, BoundData y, BoundData w, BoundData h) {
        int newX = 0;
        int newY = 0;
        int newWidth = 0;
        int newHeight = 0;
        if (w != null || h != null) {
            newWidth = w != null ? w.getValue() : this.channel.getDimension().getWidth().intValue();
            newHeight = h != null ? h.getValue() : this.channel.getDimension().getHeight().intValue();
            this.setSize(new Dimension(newWidth, newHeight));
        }
        if (x != null || y != null) {
            newX = x != null ? x.getValue() : this.channel.getDimension().getX().intValue();
            newY = y != null ? y.getValue() : this.channel.getDimension().getY().intValue();
            this.setPosition(new Point(newX, newY));
        }
        return newX + "," + newY + "," + newWidth + "," + newHeight;
    }

    protected boolean desktopMoveToElement(FoundElement foundElement, MouseDirection position, int offsetX, int offsetY) {
        Rectangle rect = foundElement.getRectangle();
        this.getSystemDriver().mouseMove(this.getOffsetX(rect, position) + (double)foundElement.getScreenX().intValue() + (double)offsetX, this.getOffsetY(rect, position) + (double)foundElement.getScreenY().intValue() + (double)offsetY);
        return true;
    }

    protected abstract void setPosition(Point var1);

    protected abstract void setSize(Dimension var1);

    public List<FoundElement> findElements(TestElement parent, ImageTemplateMatchingSimple template) {
        this.channel.setWindowToFront();
        this.channel.refreshLocation();
        WebElement parentElement = null;
        TestBound tb = null;
        if (parent == null) {
            tb = this.channel.getSubDimension();
        } else {
            parentElement = parent.getFoundElement().getValue();
            tb = parent.getFoundElement().getTestBound();
        }
        TestBound bound = tb;
        return template.findOccurrences(this.getScreenshot(parentElement, bound)).parallelStream().map(r -> new FoundElement(this.channel, bound, (Rectangle)r)).collect(Collectors.toCollection(ArrayList::new));
    }

    public byte[] getScreenshot(WebElement element, TestBound bound) {
        return this.getSystemDriver().getScreenshotByte(bound.getX(), bound.getY(), bound.getWidth(), bound.getHeight());
    }

    public CalculatedProperty[] getCssAttributes(FoundElement element) {
        return new CalculatedProperty[0];
    }

    public CalculatedProperty[] getFunctions(FoundElement element) {
        return new CalculatedProperty[0];
    }

    public String getCurrentHandle() {
        return String.valueOf(this.channel.getHandle());
    }

    public Channel getChannel() {
        return this.channel;
    }

    public File saveCurrentPage() {
        return null;
    }

    public List<FoundElement> findElementsByXpath(String xpath) {
        return Collections.emptyList();
    }

    public List<FoundElement> findElementsByName(String name) {
        return Collections.emptyList();
    }

    public List<FoundElement> findElementsByTagName(String tagName) {
        return Collections.emptyList();
    }

    public List<FoundElement> findElementsById(String id) {
        return Collections.emptyList();
    }

    public List<FoundElement> findElementsByClassName(String className) {
        return Collections.emptyList();
    }

    public Future<List<FoundElement>> getInputFiles() {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }
}

