/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.analytics;

import java.util.Arrays;
import java.util.List;

public enum ActionTypesEnum {
    NAVIGATION("ActionWindow", "GotoUrl", "ActionApi"),
    CALL_SCRIPT("ActionCallscript"),
    USER_ACTION("ActionText", "ActionMouse", "ActionSelect", "ActionFileTransfer"),
    ASSERT("ActionAssert", "ActionProperty"),
    TECHNICAL("ActionChannel", "ActionScripting", "ActionButton", "ActionPropertySet", "EndOfRecording"),
    SSA("StartScriptAction"),
    OTHERS(new String[0]);

    private final List<String> actionTypesList;

    private ActionTypesEnum(String ... actionTypes) {
        this.actionTypesList = List.of(actionTypes);
    }

    public static ActionTypesEnum of(String actionType) {
        return Arrays.stream(ActionTypesEnum.values()).filter(actionTypesEnum -> actionTypesEnum.actionTypesList.stream().anyMatch(s -> {
            String[] actionTypeArray = actionType.split("\\.");
            String actionTypeName = actionTypeArray[actionTypeArray.length - 1];
            return actionTypeName.contains((CharSequence)s);
        })).findFirst().orElse(OTHERS);
    }
}

