/*
 * Decompiled with CFR 0.152.
 */
package com.ats.driver;

import com.ats.executor.drivers.desktop.SystemDriver;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ObjectArrays;

public class ApplicationProperties {
    public static final int BROWSER_TYPE = 0;
    public static final int DESKTOP_TYPE = 1;
    public static final int MOBILE_TYPE = 2;
    public static final int API_TYPE = 3;
    public static final int SAP_TYPE = 4;
    private int type = 0;
    private String name = "chrome";
    private String driver;
    private String uri;
    private int wait = -1;
    private int debugPort = -1;
    private int check = -1;
    private String lang;
    private String userDataDir;
    private String title;
    private String[] options;
    private String[] excludedOptions;
    private String authentication;
    private String[] extensions;

    public ApplicationProperties(String name) {
        this.name = name;
    }

    public ApplicationProperties(String name, String connexion, String client, String authentication, String lang) {
        this(name);
        this.type = 4;
        this.uri = connexion + ":" + client + ":" + lang;
        this.authentication = authentication;
        this.lang = lang;
    }

    public ApplicationProperties(int type, String name, String driver, String uri, int wait, int check, String lang, String userDataDir, String title, String[] options, String[] excludedOptions, String[] extensions, int debugPort) {
        this(name);
        this.type = type;
        this.driver = driver;
        this.uri = uri;
        this.wait = wait;
        this.check = check;
        this.lang = lang;
        this.userDataDir = userDataDir;
        this.title = title;
        this.options = options;
        this.excludedOptions = excludedOptions;
        this.extensions = extensions;
        this.debugPort = debugPort;
    }

    public static String getUserDataPath(String userDataDir, String browserName, SystemDriver systemDriver) {
        JsonNode json;
        if (userDataDir != null && (json = systemDriver.getUserFolder(userDataDir, browserName)).has("userDataPath")) {
            return json.get("userDataPath").asText();
        }
        return null;
    }

    public boolean isWeb() {
        return this.type == 0;
    }

    public boolean isDesktop() {
        return this.type == 1;
    }

    public boolean isMobile() {
        return this.type == 2;
    }

    public boolean isApi() {
        return this.type == 3;
    }

    public boolean isSap() {
        return this.type == 4;
    }

    public String getName() {
        return this.name;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUri() {
        return this.uri;
    }

    public int getWait() {
        return this.wait;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public int getCheck() {
        return this.check;
    }

    public String getLang() {
        return this.lang;
    }

    public String getUserDataDir() {
        return this.userDataDir;
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void addExcludedOptions(String opt) {
        int len = this.getExcludedOptions().length;
        this.excludedOptions = new String[len + 1];
        this.excludedOptions[len] = opt;
    }

    public String[] getExcludedOptions() {
        if (this.excludedOptions == null) {
            return new String[0];
        }
        return this.excludedOptions;
    }

    public String[] getExtensions() {
        if (this.extensions == null) {
            return new String[0];
        }
        return this.extensions;
    }

    public String[] getExcludedOptions(String logOption) {
        Object[] data = new String[]{logOption};
        if (this.excludedOptions == null) {
            return data;
        }
        return (String[])ObjectArrays.concat((Object[])data, (Object[])this.excludedOptions, String.class);
    }

    public String getAuthentication() {
        return this.authentication;
    }
}

