/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.desktop;

import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.TestBound;
import com.ats.executor.drivers.engines.SystemDriverEngine;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.openqa.selenium.NoAlertPresentException;

public class DesktopAlert
extends DialogBox {
    private FoundElement dialog;
    private SystemDriverEngine engine;

    public DesktopAlert(SystemDriverEngine engine, TestBound dimension) {
        super(engine, dimension);
        this.waitBox = 200;
        Long Pid = engine.getChannel().getProcessId();
        List<FoundElement> elements = engine.getSystemDriver().getDialogBox(dimension, Pid);
        if (elements.size() <= 0) {
            throw new NoAlertPresentException();
        }
        this.dialog = elements.get(0);
        this.engine = engine;
    }

    @Override
    public void dismiss(ActionStatus status) {
        if (this.dialog != null) {
            FoundElement closebutton = null;
            List<FoundElement> buttons = this.dialog.getChildren().stream().filter(p -> p.getTag().equals("Button")).collect(Collectors.toList());
            if (buttons.size() > 1) {
                closebutton = this.searchButtonDismiss(buttons);
            } else {
                FoundElement close;
                List title = this.dialog.getChildren().stream().filter(p -> p.getTag().equals("TitleBar")).collect(Collectors.toList());
                if (title.size() > 0 && "Button".equals((close = ((FoundElement)title.get(0)).getChildren().get(0)).getTag())) {
                    closebutton = close;
                }
            }
            if (closebutton != null) {
                this.engine.mouseMoveToElement(status, closebutton, new MouseDirection(), false, 0, 0);
                this.engine.getSystemDriver().mouseClick();
            }
        }
    }

    private FoundElement searchButtonDismiss(List<FoundElement> buttons) {
        if (buttons.size() > 1) {
            for (FoundElement elem : buttons) {
                String attrTxt;
                Map<String, String> attrs = elem.getAttribute();
                if (attrs == null || attrs.size() <= 0 || !attrs.containsKey("Text") || !(attrTxt = attrs.get("Text").toLowerCase()).equalsIgnoreCase("no") && !attrTxt.equalsIgnoreCase("cancel") && !attrTxt.equalsIgnoreCase("non") && !attrTxt.equalsIgnoreCase("annuler")) continue;
                return elem;
            }
        }
        return buttons.get(1);
    }

    @Override
    public void accept(ActionStatus status) {
        List<FoundElement> buttons;
        if (this.dialog != null && (buttons = this.dialog.getChildren().stream().filter(p -> p.getTag().equals("Button")).collect(Collectors.toList())).size() > 0) {
            FoundElement AcceptButton = this.searchButtonAccept(buttons);
            this.engine.mouseMoveToElement(status, AcceptButton, new MouseDirection(), false, 0, 0);
            this.engine.getSystemDriver().mouseClick();
        }
    }

    private FoundElement searchButtonAccept(List<FoundElement> buttons) {
        if (buttons.size() > 1) {
            for (FoundElement elem : buttons) {
                String attrTxt;
                Map<String, String> attrs = elem.getAttribute();
                if (attrs == null || attrs.size() <= 0 || !attrs.containsKey("Text") || (attrTxt = attrs.get("Text").toLowerCase()) != "yes" && attrTxt != "oui") continue;
                return elem;
            }
        }
        return buttons.get(0);
    }

    @Override
    public void defaultButton(ActionStatus status) {
        if (this.dialog != null) {
            this.engine.mouseMoveToElement(status, this.dialog, new MouseDirection(), false, 0, 0);
        }
    }

    @Override
    public String getText() {
        List<FoundElement> labels;
        if (this.dialog != null && (labels = this.dialog.getChildren().stream().filter(p -> p.getTag().equals("Text")).collect(Collectors.toList())).size() > 0) {
            StringJoiner joiner = new StringJoiner("\n");
            labels.forEach(l -> joiner.add(this.engine.getAttribute(null, (FoundElement)l, "Name", 1)));
            return joiner.toString();
        }
        return "";
    }

    @Override
    public void sendKeys(ActionStatus status, String text) {
        List edits;
        if (this.dialog != null && (edits = this.dialog.getChildren().stream().filter(p -> p.getTag().equals("Edit")).collect(Collectors.toList())).size() > 0) {
            this.engine.getSystemDriver().executeScript(null, "SetValue(" + text + ")", (FoundElement)edits.get(0));
        }
    }

    @Override
    public String getTitle() {
        List title;
        if (this.dialog != null && (title = this.dialog.getChildren().stream().filter(p -> p.getTag().equals("TitleBar")).collect(Collectors.toList())).size() > 0) {
            return this.engine.getAttribute(null, (FoundElement)title.get(0), "Value", 1);
        }
        return "";
    }

    @Override
    public void clickButtonAtIndex(int index, ActionStatus status) {
        if (this.dialog != null) {
            List buttons = this.dialog.getChildren().stream().filter(p -> p.getTag().equals("Button")).collect(Collectors.toList());
            if (buttons.size() > index) {
                this.engine.mouseMoveToElement(status, (FoundElement)buttons.get(index), new MouseDirection(), false, 0, 0);
                this.engine.getSystemDriver().mouseClick();
            } else {
                status.setPassed(false);
                status.setMessage("Index not found, the maximum is " + (buttons.size() - 1));
            }
        }
    }

    @Override
    public CalculatedProperty[] getAttributes() {
        return new CalculatedProperty[]{new CalculatedProperty("text", this.getText()), new CalculatedProperty("title", this.getTitle())};
    }
}

