/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import java.util.regex.Matcher;
import org.apache.commons.text.StringEscapeUtils;

public class BaseValue {
    public String startChar = "\u00bb";
    public String endChar = "\u00ab";
    public String separatorChar = "\u00ac";
    protected String value;
    protected String codeValue;
    protected String replace = "";

    public BaseValue(Matcher m) {
        String data;
        this.replace = m.group(0);
        if (this.replace != null) {
            this.replace = StringEscapeUtils.escapeJava((String)this.replace);
        }
        this.value = data = StringEscapeUtils.escapeJava((String)m.group(1));
        this.codeValue = data;
    }

    public BaseValue(String value) {
        this.value = value;
        this.codeValue = value;
    }

    public String getReplace() {
        return this.replace;
    }

    public String getNoComma() {
        return this.replace.replace(",", "\n");
    }

    public String getCode() {
        StringBuilder codeBuilder = new StringBuilder("(");
        codeBuilder.append(this.codeValue);
        codeBuilder.append(")");
        return codeBuilder.toString();
    }

    public String getType() {
        return "V";
    }

    public String getHashValue() {
        StringBuilder sb = new StringBuilder("#@");
        sb.append(this.getType()).append(this.value).append("#");
        return sb.toString();
    }

    public String replace(String value) {
        return value.replace(this.getReplace(), this.getHashValue());
    }
}

