/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.Variable;
import com.ats.script.Script;
import com.ats.script.actions.ActionReturnVariable;
import com.ats.script.actions.condition.ExecuteOptions;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Predicate;

public class ActionProperty
extends ActionReturnVariable {
    public static final String SCRIPT_LABEL = "property";
    public static final Predicate<String> PREDICATE = g -> g.startsWith(SCRIPT_LABEL);
    public static final String NO_DATA_AVAILABLE = "NO_DATA_AVAILABLE";
    private String name;

    public ActionProperty() {
    }

    public ActionProperty(Script script, ExecuteOptions options, int stopPolicy, String name, Variable variable, ArrayList<String> objectArray) {
        super(script, options, stopPolicy, objectArray, variable);
        this.setName(name);
    }

    public ActionProperty(Script script, ExecuteOptions options, int stopPolicy, int maxTry, int delay, SearchedElement element, String name, Variable variable) {
        super(script, options, stopPolicy, maxTry, delay, element, variable);
        this.setName(name);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(", \"").append(this.name).append("\", ").append(this.variable.getName()).append(")");
        return codeBuilder;
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.name);
        return keywords;
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        String attributeValue = "";
        if (this.status.isPassed()) {
            attributeValue = this.getTestElement().getAttribute(this.status, this.name);
            int leftTries = this.getActionMaxTry();
            while (attributeValue == null && leftTries > 0) {
                this.getCurrentChannel().tryAndWait(53, "get property fail, wait and try again", this.getActionMaxTry(), --leftTries);
                attributeValue = this.getTestElement().getAttribute(this.status, this.name);
            }
            if (attributeValue == null) {
                attributeValue = "";
                this.status.setError(-5, "attribute '" + this.name + "' not found", this.name);
                ts.getRecorder().update(-5, this.status.endDuration(), this.name);
            } else {
                this.status.setMessage(attributeValue);
                ts.getRecorder().update(this.status.getCode(), this.status.endDuration(), this.name, attributeValue);
            }
        } else {
            attributeValue = this.getTestElement().getAttribute(this.status, this.name);
            if (this.status.getCode() == -1) {
                this.status.setMessage("ELEMENT_NOT_FOUND");
                ts.getRecorder().update(this.status.getCode(), this.status.endDuration(), this.name, NO_DATA_AVAILABLE);
            } else {
                this.status.setMessage(attributeValue);
                ts.getRecorder().update(this.status.getCode(), this.status.endDuration(), this.name, attributeValue);
            }
        }
        this.updateVariableValue(attributeValue);
        this.status.setValue(attributeValue);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty(SCRIPT_LABEL, this.name);
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }
}

