/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.general;

import com.ats.recorder.TestError;
import com.ats.tools.report.Constants;
import com.ats.tools.report.models.ExecutionGroup;
import com.ats.tools.report.models.ReportContextExecution;
import com.ats.tools.report.models.ReportSettings;
import com.ats.tools.report.models.TestInfo;
import com.ats.tools.report.utils.HtmlActionUtils;
import java.io.File;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class HtmlReportTestInfo {
    private static final String TABLE_VALUE_TEMPLATE = "<div style='word-wrap: anywhere'>${valuePlaceholder}</div>";
    private static final String TABLE_NO_VALUE_TEMPLATE = "<div class='no-value' style='word-wrap: anywhere'>${valuePlaceholder}</div>";
    private static final String TEST_NAME = "${testName}";
    private static final String ACTIONS_COUNT = "${actionsCount}";
    private static final String EXECUTION_TIME_SEC = "${executionTimeSec}";
    private static final String EXECUTION_TIME_MIN = "${executionTimeMin}";
    private static final String EXECUTION_TIME_HRS = "${executionTimeHrs}";
    private static final String ID_HIDDEN_PLACEHOLDER_HRS = "${idHiddenPlaceHolderHrs}";
    private static final String ERROR_TEXT_COLOR_PLACEHOLDER = "${error-text-color-placeholder}";
    private static final String EXECUTION_ERROR = "${executionError}";
    private static final String ERROR_ACTION_URL = "${errorActionUrl}";
    private static final String ERROR_ACTION_ID = "${errorActionId}";
    private static final String REPORT_SUMMARY = "${reportSummary}";
    private static final String AUTHOR = "${author}";
    private static final String STARTED = "${started}";
    private static final String FINISHED = "${finished}";
    private static final String TEST_ID = "${testId}";
    private static final String EXTERNAL_ID = "${externalId}";
    private static final String TEST_DESCRIPTION = "${testDescription}";
    private static final String PREREQUISITES = "${prerequisites}";
    private static final String GROUPS = "${groups}";
    private static final String EXECUTION_GROUPS = "${executionGroups}";
    private static final String TEST_CASE_ID = "${testCaseId}";
    private static final String TEST_TITLE = "${testTitle}";
    private static final String TEST_EXECUTION_STATUS_NAME_CLASS = "test-execution-status-name";
    private static final String EXECUTION_ERROR_TEMPLATE = "Line: ${executionErrorLine}, Error: ${executionErrorText}";
    private static final String EXTERNAL_LINK_HTML_TEMPLATE = "<a class='hover-underline gen-margin-right-10' style='color: rgba(56, 63, 79, 1); display: flex;' href='${externalResourceUri}' target='_blank'><div class='external-link-icon'></div>${externalResource}</a>";
    private static final String EXECUTION_ERROR_HTML_TEMPLATE = "<div class='test-execution-status'>\n                <div class='test-execution-status-name' title='Go to failed action' onclick=\"navigateToElementById('${errorActionId}', this, true)\"><div class='hover-underline div-with-flex-center'><div class='down-arrow-icon'></div>Execution error</div></div>\n                <div class='test-execution-status-value right-border-radius' style='justify-content: space-between;'><a style='text-decoration: none; display: flex; align-items: center;' id='errorUrl' href='ats://${errorActionUrl}' target='_self'><div class='external-link-icon'></div><div class='hover-underline ${error-text-color-placeholder}' title='${executionError}'>${executionError}</div></a></div>            </div>";
    private static final String REPORT_SUMMARY_HTML_TEMPLATE = "<div class=\"test-execution-status\">\n    <div class=\"test-execution-status-name test-execution-status-name-blue\">Report summary</div>\n    <div class=\"test-execution-status-value test-execution-status-value-blue right-border-radius\">\n        <div class=\"data-body-1-cell-cell-action-comment\">\n            <iframe class=\"action-comment-iframe\" loading=\"lazy\" srcdoc=\"${reportSummary}\"></iframe>\n        </div>\n    </div>\n</div>";
    private static final String GROUP_NAME_HTML_TEMPLATE = "<a class=\"item-with-frame\" style=\"text-decoration: none; color: rgba(56, 63, 79, 1); display: flex;\" href=\"ats://${groupUri}\" target=\"_self\">\n    <div class=\"external-link-icon\"></div>${groupName}\n</a>";
    private static final String EXECUTION_GROUP_TOOLTIP_LINE = "    <div class=\"execution-group-tooltip-text\">\n        <div class=\"execution-group-tooltip-label\">${label}: </div>\n        <span>${text}</span>\n    </div>\n";
    private static final String EXECUTION_GROUP_NAME_HTML_TEMPLATE = "<a class=\"test-case-header-name-execution-group-link\" href=\"ats://${groupUri}\" target=\"_self\">\n    <div class=\"execution-group-tooltip-trigger\">\n        <div class=\"execution-group-tooltip-wrapper\">\n            <div style=\"background-color: ${backgroundColor}; border: 2px solid ${color}; color: ${color};\"\n             class=\"test-case-header-name-execution-group-link-text\">\n                ${executionGroupTag}\n            </div>\n        </div>\n        <div class=\"execution-group-tooltip\">\n            ${tooltipContent}\n        </div>\n    </div>\n</a>";
    private static final String TEST_NAME_HTML_TEMPLATE = "<a style=\"color: rgba(104, 112, 125, 1);\" class=\"test-case-header-name-button\" href=\"ats://${scriptNameUri}\" target=\"_self\">\n    <div class=\"run-script-icon\" style=\"margin-right: 10px;\" title=\"Execute the script in a single test java execution (with editor)\"></div>\n</a>\n<a style=\"color: rgb(56 63 74 / 75%);\" class=\"test-case-header-name-button\" href=\"ats://${testNameUri}\" target=\"_self\">\n    <div class=\"external-link-icon\" style=\"margin-right: 10px;\" title=\"Open script in the editor\"></div>\n    <div title=\"${testNameTitle}\" class=\"test-name-text test-case-header-name hover-underline\">\n        <div style=\"font-size: 12px;\" class=\"test-case-domain-name\">${testDomain}</div>\n        <div class=\"test-case-name\" style=\"direction: ltr;\">${testName}</div>\n    </div>\n</a>\n";
    private static final String REPORT_HTML_LINK_PLACE_HOLDER = "${htmlReportLink}";
    private static final String REPORT_EXECUTION_RESULT_HTML_TEMPLATE = "<div class='${executionResult}'></div>\n";
    private static final String REPORT_EXECUTION_RESULT_HTML_TEMPLATE_PLACE_HOLDER = "${executionResulPlaceholder}";
    private static final String EXECUTION_ERROR_HTML_PLACEHOLDER = "${executionErrorTemplate}";
    private static final String EXECUTION_SUMMARY_HTML_PLACEHOLDER = "${executionSummaryTemplate}";
    private static final String MODIFIED_AT_PLACEHOLDER = "${modifiedAt}";
    private static final String PROFILE_PICTURE_PLACEHOLDER = "${profilePic}";
    private static final String AUTHOR_HEADER = "Author";
    private static final String MODIFIED_BY_HEADER = "Modifier";
    private static final String MODIFIED_AT_HEADER = "Modified";
    private static final String MODIFIED_AT_HEADER_CSS = "modified-at-header";
    private static final String CREATED_AT_HEADER = "Created";
    private static final String DISPLAY_NONE_CSS = "display-none";
    private static final String PROFILE_PIC_CSS = "profile-pic";
    private final ReportSettings reportSettings;
    private final Map<String, ExecutionGroup> executionGroups;
    private String result;

    public HtmlReportTestInfo(TestInfo testInfo, String template, String htmlReportPath, String suiteName, ReportContextExecution contextExecution) {
        this.reportSettings = contextExecution.reportSettings();
        this.executionGroups = contextExecution.project().getProperties().executionGroups();
        String groups = testInfo.getGroups().stream().filter(StringUtils::isNotBlank).map(group -> this.buildGroupNameWithLink(testInfo, (String)group)).collect(Collectors.joining());
        String executionGroups = MapUtils.isNotEmpty(this.executionGroups) ? testInfo.getGroups().stream().filter(StringUtils::isNotBlank).map(group -> this.buildExecutionGroupNameWithLink(testInfo, (String)group)).collect(Collectors.joining()) : "";
        boolean isCommandLineExecution = contextExecution.suiteItem().getName().toLowerCase().contains("command line suite") || suiteName.toLowerCase().contains("command line suite");
        this.result = template.replace(STARTED, this.formatValue(testInfo.getStartedFormatted()));
        if (StringUtils.isNotBlank((CharSequence)testInfo.getModifiedBy())) {
            profilePic = this.getUserProfilePictureFromProjectProperties(contextExecution.project().getProperties().userProfileImages(), testInfo.getSystemUser());
            this.result = this.result.replace(AUTHOR_HEADER, MODIFIED_BY_HEADER);
            this.result = this.result.replace(AUTHOR, this.formatValue(testInfo.getModifiedBy()));
            this.result = this.result.replace(MODIFIED_AT_PLACEHOLDER, this.formatValue(testInfo.getModifiedAt()));
            this.result = this.result.replace("modified-at-header display-none", MODIFIED_AT_HEADER_CSS);
            if (StringUtils.isNotBlank((CharSequence)profilePic)) {
                this.result = this.result.replace(PROFILE_PICTURE_PLACEHOLDER, profilePic);
                this.result = this.result.replace("profile-pic display-none", PROFILE_PIC_CSS);
            }
        } else {
            this.result = this.result.replace(AUTHOR, this.formatValue(testInfo.getAuthor()));
            profilePic = this.getUserProfilePictureFromProjectProperties(contextExecution.project().getProperties().userProfileImages(), testInfo.getAuthor());
            if (StringUtils.isNotBlank((CharSequence)profilePic)) {
                this.result = this.result.replace(PROFILE_PICTURE_PLACEHOLDER, profilePic);
                this.result = this.result.replace("profile-pic display-none", PROFILE_PIC_CSS);
            }
            if (testInfo.getCreatedAt() != null) {
                this.result = this.result.replace(MODIFIED_AT_PLACEHOLDER, this.formatValue(testInfo.getCreatedAt()));
                this.result = this.result.replace(MODIFIED_AT_HEADER, CREATED_AT_HEADER);
                this.result = this.result.replace("modified-at-header display-none", MODIFIED_AT_HEADER_CSS);
            }
        }
        this.result = this.result.replace(FINISHED, this.formatValue(testInfo.getFinishedFormated()));
        this.result = this.result.replace(TEST_ID, this.formatValue(testInfo.getTestId()));
        this.result = this.result.replace(EXTERNAL_ID, this.formatValue(testInfo.getExternalId()));
        this.result = this.result.replace(TEST_DESCRIPTION, this.formatValue(testInfo.getDescription()));
        this.result = this.result.replace(PREREQUISITES, this.formatValue(testInfo.getPrerequisite()));
        this.result = this.result.replace(GROUPS, this.formatValue(groups));
        this.result = this.result.replace(EXECUTION_GROUPS, executionGroups);
        this.result = this.result.replace(TEST_NAME, this.buildTestNameLink(testInfo, suiteName));
        this.result = this.result.replace(TEST_CASE_ID, String.format("%s-%s", testInfo.getTestName(), suiteName));
        this.result = this.result.replace(REPORT_HTML_LINK_PLACE_HOLDER, this.buildReportsLinks(htmlReportPath, testInfo.getTestName(), suiteName));
        this.result = this.result.replace(TEST_TITLE, testInfo.getTestName());
        if (isCommandLineExecution) {
            this.result = this.result.replace("test-case-body collapsed", "test-case-body");
            this.result = this.result.replace("actions-container collapsed", "actions-container");
            this.result = this.result.replaceAll("display-toggle-icon-right", "display-toggle-icon-down");
            this.result = this.result.replace("elementNodeListOf.item(0).click();", "");
        }
        if (testInfo.getSummary() != null) {
            this.result = this.result.replace(ACTIONS_COUNT, testInfo.getSummary().getActions());
            Duration testCaseExecutionTime = Duration.ofMillis(Long.parseLong(testInfo.getSummary().getExecutionTime()));
            this.result = this.result.replace(EXECUTION_TIME_SEC, testCaseExecutionTime.toSecondsPart() + " sec");
            this.result = this.result.replace(EXECUTION_TIME_MIN, testCaseExecutionTime.toMinutesPart() + " min");
            this.result = testCaseExecutionTime.toHours() >= 1L ? this.result.replace(EXECUTION_TIME_HRS, testCaseExecutionTime.toHours() + " hr") : this.result.replace(ID_HIDDEN_PLACEHOLDER_HRS, "hidden");
            String executionResult = Constants.SummaryStatus.fromNumericValue(testInfo.getSummary().getStatus()).getMainReportIcon();
            String formattedExecutionResult = REPORT_EXECUTION_RESULT_HTML_TEMPLATE.replace("${executionResult}", executionResult);
            this.result = this.result.replace(REPORT_EXECUTION_RESULT_HTML_TEMPLATE_PLACE_HOLDER, formattedExecutionResult);
            this.result = StringUtils.isNotBlank((CharSequence)testInfo.getSummary().getData()) ? this.result.replace(EXECUTION_SUMMARY_HTML_PLACEHOLDER, REPORT_SUMMARY_HTML_TEMPLATE.replace(REPORT_SUMMARY, testInfo.getSummary().getData().replaceAll("'", "&apos;").replaceAll("\"", "&quot;"))) : this.result.replace(EXECUTION_SUMMARY_HTML_PLACEHOLDER, "");
            if (testInfo.getSummary().getTestErrors() != null && !testInfo.getSummary().getTestErrors().isEmpty()) {
                String uniqueErrorsBlockId = UUID.randomUUID().toString();
                String testErrorsNonBlocking = this.wrapNonBlockingErrors(testInfo.getSummary().getTestErrors().stream().filter(testError -> !TestError.TestErrorStatus.FAIL_STOP.equals((Object)testError.getTestErrorStatus())).map(testError -> this.buildExecutionErrorElement((TestError)testError, testInfo)).collect(Collectors.joining()), uniqueErrorsBlockId);
                String testErrorsBlocking = this.buildExecutionErrorElement(testInfo.getSummary().getTestErrors().stream().filter(testError -> TestError.TestErrorStatus.FAIL_STOP.equals((Object)testError.getTestErrorStatus())).findFirst().orElse(null), testInfo);
                this.result = this.result.replace(EXECUTION_ERROR_HTML_PLACEHOLDER, testErrorsNonBlocking + " " + testErrorsBlocking);
                this.result = this.result.replace(ERROR_ACTION_URL, HtmlActionUtils.getActionUrl(testInfo, testInfo.getSummary().getErrorScriptName(), testInfo.getSummary().getErrorLine()));
            } else {
                this.result = this.result.replace(EXECUTION_ERROR_HTML_PLACEHOLDER, "");
            }
        } else {
            this.result = this.result.replace(EXECUTION_SUMMARY_HTML_PLACEHOLDER, "");
            this.result = this.result.replace(EXECUTION_ERROR_HTML_PLACEHOLDER, "");
            this.result = this.result.replace(ACTIONS_COUNT, "No value");
            this.result = this.result.replace(EXECUTION_TIME_SEC, "No value");
            this.result = this.result.replace(REPORT_EXECUTION_RESULT_HTML_TEMPLATE_PLACE_HOLDER, "No value");
        }
    }

    private String getUserProfilePictureFromProjectProperties(Map<String, String> userImages, String userName) {
        List userImage = StringUtils.isNotBlank((CharSequence)userName) ? userImages.keySet().stream().filter(user -> user.contains(userName)).toList() : Collections.emptyList();
        return CollectionUtils.isNotEmpty(userImage) ? userImages.get(userImage.getFirst()) : null;
    }

    private String wrapNonBlockingErrors(String nonBlockingErrors, String uniqueErrorsBlockId) {
        Object nonBlockingErrorsWrapped = "<div class='non-blocking-errors-group'>\n    <div class='frame-header frame-header-errors-group'>\n        <div class='display-toggle-icon-right'\n             onclick='widgetManager.toggleElement(&quot;${uniqueErrorsGroupId}&quot;, this, &quot;errors-group&quot;)'></div>\n        Non-blocking actions failed\n    </div>\n    <div id=${uniqueErrorsGroupId} class='non-blocking-errors-items collapsed'>" + nonBlockingErrors + "</div>\n</div>";
        nonBlockingErrorsWrapped = StringUtils.replace((String)nonBlockingErrorsWrapped, (String)"${uniqueErrorsGroupId}", (String)uniqueErrorsBlockId);
        return StringUtils.isEmpty((CharSequence)nonBlockingErrors) ? "" : nonBlockingErrorsWrapped;
    }

    @NotNull
    private String buildExecutionErrorElement(TestError testError, TestInfo testInfo) {
        if (testError == null) {
            return "";
        }
        String result = StringUtils.replace((String)EXECUTION_ERROR_HTML_TEMPLATE, (String)EXECUTION_ERROR, (String)this.buildExecutionErrorLine(testError));
        result = result.replace(ERROR_ACTION_ID, testInfo.getTestName() + ":" + testInfo.getSummary().getTestErrors().indexOf(testError));
        result = result.replace(ERROR_ACTION_URL, HtmlActionUtils.getActionUrl(testInfo, testError.getScript(), String.valueOf(testError.getLine())));
        result = result.replace(ERROR_TEXT_COLOR_PLACEHOLDER, TestError.TestErrorStatus.FAIL_PASS.equals((Object)testError.getTestErrorStatus()) ? "error-text-brown" : "error-text-red");
        if (TestError.TestErrorStatus.FAIL_STOP.equals((Object)testError.getTestErrorStatus())) {
            return result;
        }
        if (TestError.TestErrorStatus.FAIL_PASS.equals((Object)testError.getTestErrorStatus())) {
            return result.replace(TEST_EXECUTION_STATUS_NAME_CLASS, "test-execution-status-name soft-orange-background-color").replace("Execution error", "Optional action").replace("this, true", "this, false");
        }
        return result.replace("Execution error", "Failed action").replace("this, true", "this, false");
    }

    @NotNull
    private String buildReportsLinks(String htmlReportLink, String testName, String suiteName) {
        String atsvLink = "";
        String atsvHtmlLink = "";
        if (this.reportSettings.atsvHtmlReport()) {
            String suitePath = StringUtils.isNotBlank((CharSequence)htmlReportLink) ? suiteName : "..";
            atsvHtmlLink = EXTERNAL_LINK_HTML_TEMPLATE.replace("${externalResourceUri}", suitePath + File.separator + testName + "_atsv.html").replace("${externalResource}", "ATSV_HTML");
        }
        if (!this.reportSettings.concatenationRun() && StringUtils.isNotBlank((CharSequence)htmlReportLink)) {
            String path = suiteName + File.separator + testName + "_xml" + File.separator + "ats-test-report.html";
            htmlReportLink = EXTERNAL_LINK_HTML_TEMPLATE.replace("${externalResourceUri}", path).replace("${externalResource}", "HTML");
        } else {
            htmlReportLink = "";
        }
        return atsvLink + atsvHtmlLink + htmlReportLink;
    }

    @NotNull
    private String buildGroupNameWithLink(TestInfo testInfo, String group) {
        return GROUP_NAME_HTML_TEMPLATE.replace("${groupUri}", String.format("%s/group/%s", testInfo.getProject().getProjectId(), group)).replace("${groupName}", group);
    }

    @NotNull
    private String buildExecutionGroupNameWithLink(TestInfo testInfo, String group) {
        ExecutionGroup executionGroup = this.executionGroups.get(group);
        Constants.ExecutionGroupStyle executionGroupStyle = Constants.EXECUTION_GROUPS_STYLE.get(executionGroup.color());
        String groupNameLine = EXECUTION_GROUP_TOOLTIP_LINE.replace("${label}", "Group").replace("${text}", executionGroup.name());
        String groupDescriptionLine = "";
        if (StringUtils.isNotBlank((CharSequence)executionGroup.description())) {
            groupDescriptionLine = EXECUTION_GROUP_TOOLTIP_LINE.replace("${label}", "Description").replace("${text}", executionGroup.description());
        }
        return EXECUTION_GROUP_NAME_HTML_TEMPLATE.replace("${groupUri}", String.format("%s/group/%s", testInfo.getProject().getProjectId(), group)).replace("${backgroundColor}", executionGroupStyle.backgroundColor()).replace("${color}", executionGroupStyle.textColor()).replace("${tooltipContent}", String.join((CharSequence)"", groupNameLine, groupDescriptionLine)).replace("${executionGroupTag}", executionGroup.tag());
    }

    private String buildTestNameLink(TestInfo testInfo, String suiteName) {
        String testName = testInfo.getTestName();
        String testDomain = "...";
        int domainDelimiter = testInfo.getTestName().lastIndexOf(".");
        if (domainDelimiter > -1) {
            testDomain = testInfo.getTestName().substring(0, domainDelimiter);
            testName = testInfo.getTestName().substring(domainDelimiter + 1);
        }
        return TEST_NAME_HTML_TEMPLATE.replace("${testNameUri}", String.format("%s/script/%s", testInfo.getProject().getProjectId(), testInfo.getTestName())).replace(TEST_NAME, testName).replace("${testDomain}", testDomain).replace("${testNameTitle}", testInfo.getTestName()).replace("${scriptNameUri}", String.format("%s/run-script/%s/%s", testInfo.getProject().getProjectId(), testInfo.getTestName(), suiteName));
    }

    private String buildExecutionErrorLine(TestError testError) {
        return EXECUTION_ERROR_TEMPLATE.replace("${executionErrorLine}", String.valueOf(testError.getLine())).replace("${executionErrorText}", testError.getMessage());
    }

    private String formatValue(String value) {
        return StringUtils.isEmpty((CharSequence)value) ? TABLE_NO_VALUE_TEMPLATE.replace("${valuePlaceholder}", "No value") : TABLE_VALUE_TEMPLATE.replace("${valuePlaceholder}", value);
    }

    public String getResult() {
        return this.result;
    }
}

