(function() {
    function collectFileInputs(root, result, path) {
        const inputs = root.querySelectorAll('input[type="file"]');
        inputs.forEach(el => {
            let r = el.getBoundingClientRect();
            const scX=(window.outerWidth-window.innerWidth)/2+window.screenX+0.0001, scY=window.outerHeight-window.innerHeight+window.screenY+0.0001;
            result.push([el, el.tagName, el.getAttribute('inputmode')==='numeric', el.getAttribute('type')==='password', r.x+0.0001, r.y+0.0001, r.width+0.0001, r.height+0.0001, r.left+0.0001, r.top+0.0001, scX, scY, {}, false]);
        });

		//Shadow root
        root.querySelectorAll('*').forEach(el => {
            if (el.shadowRoot) {
                collectFileInputs(el.shadowRoot, result, path);
            }
        });
    }

    const result = [];
    collectFileInputs(window.document, result, []);
    return result;
})();