/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element.test;

import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.element.SearchedElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.recorder.IVisualRecorder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public class TestElementDialog
extends TestElement {
    private static final String ID_CRITERIA = "id";
    private static final String TEXT_CRITERIA = "text";
    private static final String TYPE_CRITERIA = "type";
    private static final String INDEX_CRITERIA = "index";
    public static final String ALERT = "ALERT";
    public static final String DIALOG = "dialog";
    public static final String ACCEPT = "accept";
    public static final String DISMISS = "dismiss";
    private DialogBox dialog = null;
    private String alertAction = null;
    private String alertCriteria = null;

    public TestElementDialog() {
    }

    public TestElementDialog(ActionTestScript script, Channel channel) {
        super(script, channel);
    }

    public TestElementDialog(ActionTestScript script, ActionStatus status, Channel channel, int maxTry, SearchedElement searchElement, Predicate<Integer> predicate) {
        super(script, channel, maxTry, predicate);
        this.initSearch(status, searchElement.getCriterias());
    }

    public TestElementDialog(ActionTestScript script, ActionStatus status, Channel channel, int maxTry, List<CalculatedProperty> criterias) {
        super(script, channel, maxTry);
        this.initSearch(status, criterias);
    }

    public TestElementDialog(ActionTestScript script, FoundElement element, Channel currentChannel) {
        super(script, element, currentChannel);
    }

    public String getAlertAction() {
        return this.alertAction;
    }

    @Override
    public String getSearchedTag() {
        return DIALOG;
    }

    @Override
    public String getSelector() {
        if (this.dialog == null) {
            return "";
        }
        return ALERT + " [" + this.dialog.getText() + "]";
    }

    private void initSearch(ActionStatus status, List<CalculatedProperty> properties) {
        if (properties.size() > 0) {
            this.alertAction = properties.get(0).getValue().getDataListItem();
            this.alertCriteria = properties.get(0).getName();
        }
        this.dialog = this.getChannel().switchToAlert();
        if (this.dialog == null) {
            status.setError(-1, "dialog box not found");
            this.setCount(0);
        } else {
            this.setFoundElements(new ArrayList<FoundElement>(Arrays.asList(new FoundElement())));
            this.setCount(1);
        }
    }

    @Override
    public void updateScreen() {
    }

    @Override
    public FoundElement getFoundElement() {
        return null;
    }

    @Override
    public void over(ActionStatus status, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
    }

    @Override
    public String enterText(ActionStatus status, CalculatedValue text, ActionTestScript script, int waitChar) {
        this.sendText(script, status, text, waitChar);
        return text.getCalculated();
    }

    @Override
    public void clearText(ActionStatus status, MouseDirection md) {
    }

    @Override
    public String sendText(ActionTestScript script, ActionStatus status, CalculatedValue text, int waitChar) {
        String enterText = text.getCalculated();
        this.getChannel().sleep(this.dialog.getWaitBox());
        if (this.alertCriteria != null) {
            switch (this.alertCriteria) {
                case "index": {
                    try {
                        this.dialog.sendKeys(status, enterText, Integer.parseInt(this.alertAction));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "id": {
                    this.dialog.sendKeys(status, enterText, this.alertAction);
                    break;
                }
                case "text": 
                case "type": {
                    this.dialog.sendKeys(status, enterText);
                }
            }
        } else {
            this.dialog.sendKeys(status, enterText);
        }
        if (status.isPassed()) {
            if (ACCEPT.equals(this.alertAction)) {
                this.dialog.accept(status);
            } else if (DISMISS.equals(this.alertAction)) {
                this.dialog.dismiss(status);
            }
        }
        return enterText;
    }

    @Override
    public String getAttribute(ActionStatus status, String name) {
        if (this.dialog == null) {
            return "";
        }
        return this.dialog.getText();
    }

    @Override
    public void click(ActionStatus status, MouseDirection position) {
        this.getChannel().sleep(this.dialog.getWaitBox());
        status.setPassed(true);
        if (this.alertCriteria != null) {
            switch (this.alertCriteria) {
                case "index": {
                    try {
                        this.dialog.clickButtonAtIndex(Integer.parseInt(this.alertAction), status);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "id": {
                    this.dialog.clickButtonId(this.alertAction, status);
                    break;
                }
                case "text": {
                    this.dialog.clickButtonText(this.alertAction, status);
                    break;
                }
                case "type": {
                    if (DISMISS.equals(this.alertAction)) {
                        this.dialog.dismiss(status);
                        break;
                    }
                    if (ACCEPT.equals(this.alertAction)) {
                        this.dialog.accept(status);
                        break;
                    }
                    this.dialog.defaultButton(status);
                }
            }
        } else {
            this.dialog.defaultButton(status);
        }
        this.getChannel().sleep(this.dialog.getWaitBox());
        this.getChannel().switchToDefaultContent(true);
    }

    @Override
    protected String getOccurrencesError(int expected) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(expected).append("] expected alert box(es) but ");
        if (this.getCount() > 0) {
            sb.append("[").append(this.getCount()).append("] alert box(es) found");
        } else {
            sb.append(" no alert box found");
        }
        return sb.toString();
    }

    @Override
    public CalculatedProperty[] getHtmlAttributes() {
        return this.getAttributes(true);
    }

    @Override
    public CalculatedProperty[] getAttributes(boolean reload) {
        if (this.dialog == null) {
            return new CalculatedProperty[0];
        }
        return this.dialog.getAttributes();
    }

    @Override
    public void updateScreen(ActionStatus status, IVisualRecorder rec) {
        rec.updateScreen(status, this.getAlertAction());
    }

    @Override
    public String getNotFoundDescription() {
        return "dialog box not found";
    }
}

