/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.objects;

import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.actions.condition.ExecuteOptions;
import java.util.ArrayList;
import java.util.Arrays;

public class MouseDirection {
    private MouseDirectionData horizontalPos;
    private MouseDirectionData verticalPos;

    public MouseDirection() {
    }

    public MouseDirection(Script script, ExecuteOptions options, boolean canBeEmpty) {
        options.updateMouseDirections(this, script);
        if (!canBeEmpty && this.horizontalPos == null && this.verticalPos == null) {
            this.setHorizontalPos(new MouseDirectionData(Cartesian.CENTER, new CalculatedValue(script, "0")));
        }
    }

    public MouseDirection(MouseDirectionData hpos, MouseDirectionData vpos) {
        this.setHorizontalPos(hpos);
        this.setVerticalPos(vpos);
    }

    public int getHorizontalDirection() {
        if (this.horizontalPos != null) {
            return this.horizontalPos.getHorizontalDirection();
        }
        return 0;
    }

    public int getVerticalDirection() {
        if (this.verticalPos != null) {
            return this.verticalPos.getVerticalDirection();
        }
        return 0;
    }

    private String getJavaCode(ArrayList<String> codeData) {
        if (this.horizontalPos != null || this.verticalPos != null) {
            if (this.horizontalPos != null) {
                codeData.add("ps(" + this.horizontalPos.getJavaCode() + ")");
            } else {
                codeData.add("null");
            }
            if (this.verticalPos != null) {
                codeData.add("ps(" + this.verticalPos.getJavaCode() + ")");
            } else {
                codeData.add("null");
            }
            return String.join((CharSequence)", ", codeData);
        }
        return "";
    }

    public String getPositionJavaCode() {
        return this.getJavaCode(new ArrayList<String>(Arrays.asList("")));
    }

    public String getDirectionJavaCode() {
        return this.getJavaCode(new ArrayList<String>());
    }

    public MouseDirectionData getHorizontalPos() {
        return this.horizontalPos;
    }

    public void setHorizontalPos(MouseDirectionData horizontalPos) {
        this.horizontalPos = horizontalPos;
    }

    public MouseDirectionData getVerticalPos() {
        return this.verticalPos;
    }

    public void setVerticalPos(MouseDirectionData verticalPos) {
        this.verticalPos = verticalPos;
    }
}

