/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.performance.proxy;

import com.browserup.bup.BrowserUpProxyServer;
import com.browserup.bup.filters.RequestFilter;
import com.browserup.bup.filters.RequestFilterAdapter;
import com.browserup.bup.filters.ResponseFilter;
import com.browserup.bup.filters.ResponseFilterAdapter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.littleshoot.proxy.HttpFiltersSource;

public class AtsBrowserMobProxyServer
extends BrowserUpProxyServer {
    private static final int TRAFFIC_IDLE_DEFAULT = 3000;
    private static final int TRAFFIC_IDLE_WAIT = 1000;
    private int trafficIddle = 3000;
    private boolean trafficStarted = false;
    private long timestamp = 0L;
    private int waitTraffic = 1000;

    public AtsBrowserMobProxyServer(int trafficIddle) {
        this.setTrafficIddle(trafficIddle);
        this.setIdleConnectionTimeout(30, TimeUnit.SECONDS);
        this.setTrustAllServers(true);
    }

    public void setTrafficIddle(int value) {
        if (value > 0) {
            this.trafficIddle = value * 1000;
        }
    }

    public void setLatency(int value) {
        this.waitTraffic = 1000 + value * 1000;
        this.setLatency(value, TimeUnit.SECONDS);
    }

    public void setWhiteListRequests(List<String> value) {
        if (value != null && value.size() > 0) {
            this.whitelistRequests(value, 200);
        } else {
            this.disableWhitelist();
        }
    }

    public void setMaxUpload(long value) {
        if (value > 0L) {
            this.setWriteBandwidthLimit(value);
        } else {
            this.setWriteBandwidthLimit(Long.MAX_VALUE);
        }
    }

    public void setMaxDownload(long value) {
        if (value > 0L) {
            this.setReadBandwidthLimit(value);
        } else {
            this.setReadBandwidthLimit(Long.MAX_VALUE);
        }
    }

    public void startTrafficListener() {
        this.trafficStarted = false;
        this.timestamp = System.currentTimeMillis();
    }

    public void waitTrafficFinished() {
        if (this.trafficStarted) {
            for (int maxWait = 20; !this.isQuiet() && maxWait > 0; --maxWait) {
                this.sleep(this.waitTraffic);
            }
        }
    }

    private boolean isQuiet() {
        long diff = System.currentTimeMillis() - this.timestamp;
        return diff > (long)this.trafficIddle;
    }

    private void sleep(int t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addResponseFilter(ResponseFilter filter) {
        this.addLastHttpFilterFactory((HttpFiltersSource)new ResponseFilterAdapter.FilterSource(filter, Integer.MAX_VALUE));
    }

    public void addRequestFilter(RequestFilter filter) {
        this.addFirstHttpFilterFactory((HttpFiltersSource)new RequestFilterAdapter.FilterSource(filter, Integer.MAX_VALUE));
    }

    public void start(int port) {
        super.start(port);
        this.addResponseFilter((response, contents, messageInfo) -> {
            this.timestamp = System.currentTimeMillis();
        });
        this.addRequestFilter((response, contents, messageInfo) -> {
            this.trafficStarted = true;
            this.timestamp = System.currentTimeMillis();
            return null;
        });
    }
}

