/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.general;

import com.ats.generator.ATS;
import com.ats.tools.ResourceContent;
import com.ats.tools.Utils;
import com.ats.tools.report.Constants;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.ReportContextExecution;
import com.ats.tools.report.models.ReportItem;
import com.ats.tools.report.models.ReportSettings;
import com.ats.tools.report.models.ReportSummary;
import com.ats.tools.report.models.Suite;
import com.ats.tools.report.utils.TimeUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HtmlReportExecution {
    private static final String REPORT_TYPE = "${reportType}";
    private static final String PROJECT_NAME = "${projectNameFormatted}";
    private static final String SUITS_LAUNCHED = "${suitsLaunched}";
    private static final String CREATED_AT = "${createdAt}";
    private static final String JAVA_VERSION = "${javaVersion}";
    private static final String JAVA_VM = "${javaVm}";
    private static final String LOGO = "${logoImage}";
    private static final String WATERMARK = "${watermarkImage}";
    private static final String WATERMARK_DISPLAY = "${watermarkDisplay}";
    private static final String PDF_REPORT_LINK = "${pdfReportLink}";
    private static final String ATS_TEST_SCRIPT_VERSION = "${atsTestScriptVersion}";
    private static final String TOTAL_DURATION = "${totalDuration}";
    private static final String TOTAL_EXECUTION_TINE = "${totalExecutionTime}";
    private static final String ALL_SUITES_COUNT = "${executedSuitsCount}";
    private static final String PASSED_SUITES_COUNT = "${passedSuitsCount}";
    private static final String FAILED_SUITES_COUNT = "${failedSuitsCount}";
    private static final String ALL_TESTS_COUNT = "${executedTestsCount}";
    private static final String PASSED_TESTS_COUNT = "${passedTestCount}";
    private static final String FAILED_TESTS_COUNT = "${failedTestCount}";
    public static final String PROJECT_NAME_HTML_TEMPLATE = "<a class='project-info-body-value hover-underline' style='color: rgba(56, 63, 79, 1);' href='ats://${projectUri}' target='_self'><div class='external-link-icon'></div>${projectNameUri}</a>";
    public static final String PDF_SUMMARY_CSS = "pdf-summary";
    public static final String DISPLAY_NONE_CSS = "display-none";
    public static final String COMMAND_LINE_EXECUTION_FILE_NAME = "command-line-execution.html";
    private static final String CLOSE_REPORT_HTML = "</div></div></body></html>";
    private final String mainTemplate = mainExecutionTemplate;
    private final ReportContextExecution contextExecution;
    private final String projectLogo;
    private final String watermarkLogo;
    private OutputStream fileWriter;
    private OutputStream validationFileWriter;
    private String reportFilePath;
    private String validationReportFileName;
    private static final String mainExecutionTemplate = ResourceContent.getHtmlReportExecutionTemplate();
    private static final String styles = ResourceContent.getHtmlReportCss();
    private static final String scripts = ResourceContent.getHtmlReportJavascript();
    private static final String STYLES_PLACEHOLDER = "${styles}";
    private static final String SCRIPTS_PLACEHOLDER = "${scripts}";

    public HtmlReportExecution(ReportContextExecution contextExecution) {
        this.contextExecution = contextExecution;
        this.projectLogo = contextExecution.project().getLogo();
        this.watermarkLogo = contextExecution.project().getWatermark();
    }

    public void processMainExecutionsFile() throws IOException {
        Path executionFilePath;
        HtmlReportProject project = this.contextExecution.project();
        ReportSummary reportSummary = project.getReportSummary();
        ReportSettings reportSettings = this.contextExecution.reportSettings();
        CharSequence[] javaVersion = Utils.getJavaVersion();
        String result = this.mainTemplate.replace(REPORT_TYPE, Constants.ReportDetailLevel.fromLevelValue(reportSettings.devReport()).getDescription());
        result = result.replace(STYLES_PLACEHOLDER, styles);
        result = result.replace(SCRIPTS_PLACEHOLDER, scripts);
        result = result.replace(WATERMARK, StringUtils.isBlank((CharSequence)this.watermarkLogo) ? "" : this.watermarkLogo);
        result = result.replace(WATERMARK_DISPLAY, StringUtils.isBlank((CharSequence)this.watermarkLogo) ? "none" : "inline");
        result = result.replace(LOGO, this.projectLogo);
        result = result.replace(PROJECT_NAME, this.buildProjectName(project));
        result = result.replace(SUITS_LAUNCHED, String.valueOf(project.getSuites().size()));
        result = result.replace(PDF_REPORT_LINK, this.contextExecution.reportFileNames().summaryHtmlReport());
        result = result.replace(CREATED_AT, String.valueOf(project.getStartedFormatted()));
        result = result.replace(JAVA_VERSION, String.join((CharSequence)" ", javaVersion));
        result = result.replace(JAVA_VM, System.getProperty("java.vm.name"));
        result = result.replace(ATS_TEST_SCRIPT_VERSION, ATS.getAtsVersion());
        result = result.replace(TOTAL_DURATION, TimeUtil.formatExecutionTime(reportSummary.totalDuration()));
        result = result.replace(TOTAL_EXECUTION_TINE, TimeUtil.formatExecutionTime(reportSummary.executionTime()));
        result = result.replace(ALL_SUITES_COUNT, String.valueOf(reportSummary.executedSuitesCount()));
        result = result.replace(PASSED_SUITES_COUNT, String.valueOf(reportSummary.passedSuitesCount()));
        result = result.replace(FAILED_SUITES_COUNT, String.valueOf(reportSummary.failedSuitesCount()));
        result = result.replace(ALL_TESTS_COUNT, String.valueOf(reportSummary.executedTestsCount()));
        result = result.replace(PASSED_TESTS_COUNT, String.valueOf(reportSummary.passedTestsCount()));
        result = result.replace(FAILED_TESTS_COUNT, String.valueOf(reportSummary.failedTestsCount()));
        Optional<Suite> commandLineSuite = project.getSuites().stream().filter(suite -> suite.getName().toLowerCase().contains("command line suite")).findFirst();
        boolean commandLineExecution = commandLineSuite.isPresent();
        ReportItem suitesReportItem = this.contextExecution.suiteItem();
        suitesReportItem.setIsNoSuiteLaunch(commandLineExecution);
        if (suitesReportItem.isNoSuiteLaunch()) {
            result = result.replace(PDF_SUMMARY_CSS, DISPLAY_NONE_CSS);
            Object outputFileName = COMMAND_LINE_EXECUTION_FILE_NAME;
            if (commandLineSuite.isPresent()) {
                outputFileName = commandLineSuite.get().getTests().getFirst() + ".html";
            }
            executionFilePath = reportSettings.outputFolder().resolve((String)outputFileName);
        } else {
            executionFilePath = reportSettings.outputFolder().resolve(this.contextExecution.reportFileNames().mainHtmlReport());
        }
        this.reportFilePath = executionFilePath.toString();
        this.writeFile(result, executionFilePath);
        Path validationReportPath = reportSettings.outputFolder().resolve(this.contextExecution.reportFileNames().validationHtmlReport());
        this.validationReportFileName = validationReportPath.toString();
        this.writeValidationFile(result, validationReportPath);
    }

    private void writeValidationFile(String result, Path validationPath) throws IOException {
        result = this.contextExecution.contentFilter().filter(result);
        this.validationFileWriter = this.contextExecution.reportSettings().validationReport() ? Files.newOutputStream(validationPath, new OpenOption[0]) : OutputStream.nullOutputStream();
        this.validationFileWriter.write(result.getBytes());
    }

    private CharSequence buildProjectName(HtmlReportProject project) {
        return PROJECT_NAME_HTML_TEMPLATE.replace("${projectUri}", project.getProjectUuid()).replace("${projectNameUri}", project.getProjectName() + " " + project.getProjectVersion());
    }

    public void writeFile(String executionReport, Path suiteFile) throws IOException {
        executionReport = this.contextExecution.contentFilter().filter(executionReport);
        this.fileWriter = Files.newOutputStream(suiteFile, new OpenOption[0]);
        this.fileWriter.write(executionReport.getBytes());
    }

    public void closeWriter() throws IOException {
        IOException closeWritersException = new IOException("exception closing the report writers");
        try {
            this.closeWriter(this.fileWriter);
        }
        catch (IOException e) {
            closeWritersException.addSuppressed(e);
        }
        try {
            this.closeWriter(this.validationFileWriter);
        }
        catch (IOException e) {
            closeWritersException.addSuppressed(e);
        }
        if (ArrayUtils.isNotEmpty((Object[])closeWritersException.getSuppressed())) {
            throw closeWritersException;
        }
    }

    private void closeWriter(OutputStream stream) throws IOException {
        try (OutputStream outputStream = stream;){
            stream.write(CLOSE_REPORT_HTML.getBytes());
            stream.flush();
        }
    }

    public OutputStream getFileWriter() {
        return this.fileWriter;
    }

    public OutputStream getValidationFileWriter() {
        return this.validationFileWriter;
    }

    public String getReportFilePath() {
        return this.reportFilePath;
    }

    public String getValidationReportFilePath() {
        return this.validationReportFileName;
    }
}

