/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor;

import com.ats.element.test.TestElement;
import com.ats.executor.channels.Channel;
import com.ats.executor.channels.EmptyChannel;
import com.ats.recorder.IVisualRecorder;
import com.fasterxml.jackson.databind.JsonNode;

public class ActionStatus {
    public static final int NO_ERROR = 0;
    public static final int OBJECT_NOT_FOUND = -1;
    public static final int OBJECT_NOT_VISIBLE = -2;
    public static final int OBJECT_NOT_INTERACTABLE = -3;
    public static final int ENTER_TEXT_FAIL = -4;
    public static final int ATTRIBUTE_NOT_SET = -5;
    public static final int ATTRIBUTE_CHECK_FAIL = -6;
    public static final int VALUES_COMPARE_FAIL = -7;
    public static final int OCCURRENCES_ERROR = -8;
    public static final int CHANNEL_NOT_FOUND = -9;
    public static final int MALFORMED_GOTO_URL = -10;
    public static final int UNREACHABLE_GOTO_URL = -11;
    public static final int UNKNOWN_HOST_GOTO_URL = -12;
    public static final int JAVASCRIPT_ERROR = -13;
    public static final int WINDOW_NOT_FOUND = -14;
    public static final int WINDOW_INDEX_OUT = -15;
    public static final int WEB_DRIVER_ERROR = -16;
    public static final int DRIVER_NOT_REACHABLE = -17;
    public static final int JAVA_EXCEPTION = -18;
    public static final int CHANNEL_START_ERROR = -19;
    public static final int FILE_NOT_FOUND = -20;
    public static final int PERF_NOT_STARTED = -21;
    public static final int PERF_NOT_RECORDING = -22;
    public static final int CHANNEL_NOT_STARTED = -23;
    public static final int DATA_FILE_ERROR = -24;
    public static final int ATS_ERROR = -25;
    public static final int NOT_SELECT_ELEMENT = -26;
    public static final int NOT_INPUT_FILE = -27;
    public static final int NOT_SUBMIT_ELEMENT = -28;
    public static final int SUBSCRIPT_SYNTAX_ERROR = -29;
    public static final int SUBSCRIPT_NOT_FOUND = -30;
    public static final int OCTOPERF_FILE_ERROR = -40;
    public static final int NEOLOAD_POST_ERROR = -50;
    public static final int SYS_BUTTON_ERROR = -60;
    private static final String ATS_TECHNICAL_ERROR = "AtsTechnicalError";
    private static final String ATS_FUNCTIONAL_ERROR = "AtsFunctionalError";
    private Channel channel = new EmptyChannel();
    private long startedAt = 0L;
    private long duration = 0L;
    private long cpuUsage = 0L;
    private long searchDuration = 0L;
    private int occurences = 0;
    private boolean passed = true;
    private int code = 0;
    private String message = "";
    private TestElement element = null;
    private Object data = null;
    private String value = null;
    private String testName;
    private int testLine;
    private String errorType = "AtsFunctionalError";

    public ActionStatus() {
    }

    public ActionStatus(String testName, int line) {
        this.startDuration();
        this.testName = testName;
        this.testLine = line;
    }

    public ActionStatus(Channel channel, String testName, int line) {
        this(testName, line);
        this.setChannel(channel);
    }

    public String getTestNameLine() {
        return this.testName + ":" + this.testLine;
    }

    public String getTestName() {
        return this.testName;
    }

    public int getTestLine() {
        return this.testLine;
    }

    public void updateDuration(long currentTime) {
        this.duration += System.currentTimeMillis() - currentTime;
    }

    public void startDuration() {
        if (this.startedAt == 0L) {
            this.setStartedAt(System.currentTimeMillis());
        }
    }

    public long endDuration() {
        this.duration = System.currentTimeMillis() - this.getStartedAt() + (long)this.channel.getActionWait();
        return this.duration;
    }

    public void endAction() {
        this.channel.endHarAction();
    }

    public void endAction(IVisualRecorder rec) {
        this.endAction();
        if (this.getElement() != null) {
            this.getElement().updateScreen(this, rec);
        } else {
            System.out.println("element 'Null' updatescreen not available");
        }
    }

    public void setException(int code, Exception ex) {
        this.passed = false;
        this.code = code;
        this.errorType = ex.getClass().getName();
        this.message = ex.getMessage();
    }

    public void setTechnicalError(int code, String message) {
        this.passed = false;
        this.code = code;
        this.errorType = ATS_TECHNICAL_ERROR;
        this.message = message;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setNoError() {
        this.setPassed(true);
        this.setCode(0);
        this.setMessage("");
    }

    public void setNoError(String message) {
        this.setPassed(true);
        this.setCode(0);
        this.setMessage(message);
        this.setData(null);
    }

    public void setNoChannelError() {
        this.setPassed(false);
        this.setCode(-23);
        this.setMessage("channel engine is null ! (maybe no channel started)");
        this.startDuration();
    }

    public void setError(int code, String message) {
        this.setPassed(false);
        this.setCode(code);
        this.setMessage(message);
    }

    public void setError(int code, String message, long start) {
        this.setPassed(false);
        this.setCode(code);
        this.setMessage(message);
        this.setDuration(System.currentTimeMillis() - start);
    }

    public void setError(int code, String message, Object data) {
        this.setError(code, message);
        this.setData(data);
    }

    public void setError(int code, JsonNode node) {
        if (node.get("error") != null) {
            if (node.get("error").get("message") != null) {
                this.setError(code, node.get("error").asText() + " / " + node.get("error").get("message").asText());
            } else if (node.get("message") != null) {
                Object message = node.get("message").asText();
                if (node.get("stackTrace") != null && !node.get("stackTrace").asText().isEmpty()) {
                    message = (String)message + "\n" + node.get("stackTrace").asText();
                }
                if (node.get("datas") != null && !node.get("datas").asText().isEmpty()) {
                    message = (String)message + "\n" + node.get("datas").asText();
                }
                this.setError(code, node.get("error").asText() + " / " + (String)message);
            } else {
                this.setError(code, node.get("error").asText());
            }
        }
    }

    public String getFailMessage() {
        return this.message + " after " + this.duration + " ms";
    }

    public String getChannelApplication() {
        return this.channel.getApplication();
    }

    public boolean isPassed() {
        return this.passed;
    }

    public void setPassed(boolean b) {
        this.passed = b;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int i) {
        this.code = i;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String s) {
        this.message = s;
    }

    public TestElement getElement() {
        return this.element;
    }

    public void setElement(TestElement t) {
        this.element = t;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object o) {
        this.data = o;
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(long l) {
        this.startedAt = l;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public long getSearchDuration() {
        return this.searchDuration;
    }

    public void setSearchDuration(long l) {
        this.searchDuration = l;
    }

    public int getOccurences() {
        return this.occurences;
    }

    public void setOccurences(int i) {
        this.occurences = i;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel c) {
        this.channel = c == null ? new EmptyChannel() : c;
    }

    public long getCpuUsage() {
        return this.cpuUsage;
    }

    public void setCpuUsage(long l) {
        this.cpuUsage = l;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String s) {
        this.value = s;
    }
}

