/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.channels;

import com.ats.AtsSingleton;
import com.ats.driver.AtsManager;
import com.ats.element.DialogBox;
import com.ats.element.FoundElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.ScriptStatus;
import com.ats.executor.TestBound;
import com.ats.executor.channels.SystemValues;
import com.ats.executor.drivers.DriverManager;
import com.ats.executor.drivers.desktop.DesktopData;
import com.ats.executor.drivers.desktop.DesktopResponse;
import com.ats.executor.drivers.desktop.DesktopWindow;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.executor.drivers.engines.SapDriverEngine;
import com.ats.executor.drivers.engines.SystemDriverEngine;
import com.ats.executor.drivers.engines.WebDriverEngine;
import com.ats.generator.ATS;
import com.ats.generator.objects.BoundData;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.recorder.IVisualRecorder;
import com.ats.recorder.TestError;
import com.ats.recorder.TestSummary;
import com.ats.recorder.VisualRecorderNull;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionApi;
import com.ats.script.actions.ActionCallscript;
import com.ats.script.actions.ActionChannelStart;
import com.ats.script.actions.ActionComment;
import com.ats.script.actions.neoload.ActionNeoload;
import com.ats.script.actions.neoload.ActionNeoloadStop;
import com.ats.script.actions.network.octoperf.ActionOctoperfVirtualUser;
import com.ats.tools.ResourceContent;
import com.ats.tools.logger.ExecutionLogger;
import com.ats.tools.logger.levels.AtsFailError;
import com.ats.tools.performance.proxy.AtsNoProxy;
import com.ats.tools.performance.proxy.AtsProxy;
import com.ats.tools.performance.proxy.IAtsProxy;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;

public class Channel {
    private static final String SYSTEM_VALUE = "#SYSTEM_VALUE#::";
    public static final String HTML = "html";
    public static final String DESKTOP = "desktop";
    public static final String DESKTOP_EXPLORER = "explorer";
    public static final String MOBILE = "mobile";
    public static final String MOBILE_CHROME = "mobile-chrome";
    public static final String API = "api";
    public static final String SAP = "sap";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String BASIC_AUTHENTICATION = "Basic";
    public static final String BEARER_AUTHENTICATION = "Bearer";
    protected IDriverEngine engine;
    private ActionChannelStart actionStart;
    private boolean current = false;
    protected ActionTestScript mainScript;
    private final int scrollUnit = AtsManager.getScrollUnit();
    private TestBound dimension = AtsSingleton.getInstance().getApplicationBound();
    private TestBound subDimension = new TestBound();
    private String driverVersion = "";
    private String driverUrl = "";
    private double scale = 1.0;
    protected SystemValues systemValues = new SystemValues();
    private byte[] icon = new byte[0];
    private String screenServer;
    private ArrayList<String> operations = new ArrayList();
    private int winHandle = -1;
    private long processId = 0L;
    private String warning = "";
    private String neoloadDesignApi;
    private String type = "html";
    private ArrayList<String> systemProperties = new ArrayList();
    private ArrayList<String> systemButtons = new ArrayList();
    private int winIndex = 0;
    private ActionNeoloadStop stopNeoloadRecord = null;
    private IAtsProxy atsProxy = new AtsNoProxy();

    public void addSystemProperties(Iterator<JsonNode> iterator) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.systemProperties.add(iterator.next().asText());
            }
        }
    }

    public void addSystemButtons(Iterator<JsonNode> iterator) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.systemButtons.add(iterator.next().asText());
            }
        }
    }

    public Channel() {
    }

    public Channel(ActionChannelStart action, ActionTestScript script, DriverManager driverManager, String testName, int testLine) {
        ActionStatus status = action.getStatus();
        SystemDriver systemDriver = new SystemDriver(status, script);
        if (status.isPassed()) {
            status.setChannel(this);
            this.systemValues.setOsName(systemDriver.getOsName());
            this.systemValues.setApplicationName(action.getApplication().getCalculated());
            this.systemValues.setOsCountry(systemDriver.getCountryCode());
            this.systemValues.setMachineName(systemDriver.getMachineName());
            this.systemValues.setOsVersion(systemDriver.getOsVersion());
            this.systemValues.setOsBuild(systemDriver.getOsBuildVersion());
            this.systemValues.setScreenWidth(systemDriver.getScreenWidth().intValue());
            this.systemValues.setScreenHeight(systemDriver.getScreenHeight().intValue());
            this.mainScript = script;
            this.current = true;
            this.actionStart = action;
            this.engine = driverManager.getDriverEngine(this, status, systemDriver, script);
            if (status.isPassed()) {
                this.systemValues.setApplicationPath(this.engine.getApplicationPath());
                this.refreshLocation();
                this.engine.started(script, status);
                script.startChannel(action.getName());
            } else {
                script.startChannelFailed(testName, testLine, status.getChannelApplication(), status.getFailMessage());
            }
        } else {
            throw new AtsFailError(action.getClass().getSimpleName(), testName, testLine, "unable to start system driver, " + status.getErrorType(), status.getMessage(), script.getLogger());
        }
        status.endDuration();
    }

    public void waitBeforeMouseMoveToElement(WebDriverEngine webDriverEngine) {
        AtsSingleton.getInstance().getWaitGuiReady().waitBeforeMouseMoveToElement(this, webDriverEngine);
    }

    public void waitBeforeSwitchWindow(WebDriverEngine webDriverEngine) {
        AtsSingleton.getInstance().getWaitGuiReady().waitBeforeSwitchWindow(this, webDriverEngine);
    }

    public void waitBeforeSearchElement(WebDriverEngine webDriverEngine) {
        AtsSingleton.getInstance().getWaitGuiReady().waitBeforeSearchElement(this, webDriverEngine);
    }

    public void waitBeforeEnterText(WebDriverEngine webDriverEngine) {
        AtsSingleton.getInstance().getWaitGuiReady().waitBeforeEnterText(this, webDriverEngine);
    }

    public void waitBeforeGotoUrl(WebDriverEngine webDriverEngine) {
        AtsSingleton.getInstance().getWaitGuiReady().waitBeforeGotoUrl(this, webDriverEngine);
    }

    public static String systemValueObj(String value) {
        return SYSTEM_VALUE + value;
    }

    public static String checkSystemValue(Object o) {
        String s = o.toString();
        if (s.startsWith(SYSTEM_VALUE)) {
            return AtsSingleton.getInstance().getSystemValue(s.substring(16));
        }
        return s;
    }

    public String getSystemValue(String name) {
        return this.systemValues.get(name);
    }

    public ActionTestScript getTestScript() {
        return this.mainScript;
    }

    public String getTopScriptPackage() {
        String topScriptName = this.mainScript.getTopScript().getTestName();
        int lastDot = topScriptName.lastIndexOf(".");
        if (lastDot > 0) {
            return topScriptName.substring(0, lastDot);
        }
        return topScriptName;
    }

    public ActionStatus newActionStatus() {
        return new ActionStatus(this, "", 0);
    }

    public void newActionStatus(Action action, IVisualRecorder recorder, String testName, int testLine, boolean start) {
        ActionStatus status = new ActionStatus(this, testName, testLine);
        action.setStatus(status);
        if (status.isPassed() && start) {
            action.initAction(this, recorder, status);
        }
    }

    public SystemDriver getSystemDriver() {
        if (this.engine != null) {
            return this.engine.getSystemDriver();
        }
        return null;
    }

    public boolean isDesktopDriverEnabled() {
        return this.engine.getSystemDriver() != null && this.engine.getSystemDriver().isEnabled();
    }

    public String getTitle() {
        return this.engine.getTitle();
    }

    public void cleanHandle() {
        this.winHandle = -1;
        this.winIndex = 0;
        this.setWindowToFront();
    }

    public void setWinHandle(int hdl) {
        this.winHandle = hdl;
    }

    public void updateWinHandle(SystemDriver drv, int idx) {
        this.winIndex = idx;
        this.winHandle = this.getHandle(drv, idx);
        this.getSystemDriver().updateWindowHandle(this);
    }

    public int getHandle(SystemDriver drv) {
        if (this.winHandle < 0 && this.isDesktopDriverEnabled()) {
            this.winHandle = this.getHandle(drv, this.winIndex);
        }
        return this.winHandle;
    }

    public int getHandle() {
        return this.winHandle;
    }

    public int getHandle(SystemDriver drv, int index) {
        List<DesktopWindow> processWindows = drv.getWindowsByPid(this.getProcessId());
        if (index == -1) {
            index = processWindows.size() - 1;
        }
        if (processWindows != null && processWindows.size() > index) {
            return processWindows.get(index).getHandle();
        }
        return -1;
    }

    public void refreshLocation() {
        this.engine.updateDimensions();
    }

    public void setDimensions(TestBound dim1, TestBound dim2) {
        this.setDimension(dim1);
        this.setSubDimension(dim2);
    }

    public double getOffsetY() {
        return this.dimension.getHeight() - this.subDimension.getHeight();
    }

    public void refreshMapElementLocation() {
        this.refreshLocation();
        this.engine.refreshElementMapLocation();
    }

    public void defineRoot(String id) {
        this.getSystemDriver().defineRoot(this.dimension, id);
    }

    public void toFront() {
        if (this.isDesktopDriverEnabled()) {
            this.sleepMiddle();
            this.getSystemDriver().setChannelToFront(this.getHandle(this.getSystemDriver()), this.processId, this.getTitle());
        }
    }

    public void toFront(boolean dialog) {
        if (!dialog) {
            this.toFront();
        }
    }

    public void setWindowToFront() {
        if (this.isDesktopDriverEnabled()) {
            this.engine.setWindowToFront();
        }
    }

    public String rootKeys(ActionStatus status, CalculatedValue text) {
        String textValue = text.uncrypt(this.getTestScript(), text.getCalculated());
        this.getSystemDriver().rootKeys(this.getHandle(this.getSystemDriver()), textValue);
        this.actionTerminated(status);
        return textValue;
    }

    public String getSource() {
        return this.engine.getSource();
    }

    public byte[] getScreenShot(TestBound dim) {
        dim.setX(dim.getX() + this.dimension.getX());
        dim.setY(dim.getY() + this.dimension.getY());
        return this.getScreenShotEngine(dim);
    }

    public byte[] getScreenShot() {
        return this.getScreenShotEngine(this.dimension);
    }

    protected byte[] getScreenShotEngine(TestBound dim) {
        this.mainScript.sleep(100);
        return this.getSystemDriver().getScreenshotByte(dim.getX(), dim.getY(), dim.getWidth(), dim.getHeight());
    }

    public String getAuthenticationValue() {
        return this.actionStart.getAuthenticationValue();
    }

    public ArrayList<CalculatedValue> getArguments() {
        return this.actionStart.getArguments();
    }

    public boolean isUseCookie() {
        return this.actionStart.isUseCookie();
    }

    public void setNeoloadDesignApi(String value) {
        this.neoloadDesignApi = value;
    }

    public void setApplicationData(String type, String os) {
        this.setType(type);
        this.setIcon(ResourceContent.getAtsByteLogo());
        this.driverVersion = ATS.getAtsVersion();
        this.dimension = new TestBound(0.0, 0.0, 1.0, 1.0);
        this.systemValues.setOsName(os);
    }

    public void setApplicationData(String type, String os, String serviceType, ArrayList<String> op, byte[] ico) {
        this.setType(type);
        this.setIcon(ico);
        this.systemValues.setOsName(os);
        this.systemValues.setApplicationName(serviceType);
        this.dimension = new TestBound(0.0, 0.0, 1.0, 1.0);
        this.operations = op;
    }

    public void setApplicationData(String type, String os, String serviceType, byte[] ico) {
        this.setType(type);
        this.setIcon(ico);
        this.systemValues.setOsName(os);
        this.systemValues.setApplicationName(serviceType);
        this.dimension = new TestBound(0.0, 0.0, 1.0, 1.0);
    }

    public void setApplicationData(String type, String os, String version, String dv, long pid, byte[] ico, String screen) {
        this.setType(type);
        this.setIcon(ico);
        this.driverVersion = dv;
        this.processId = pid;
        this.screenServer = screen;
        this.systemValues.setOsName(os);
        this.systemValues.setApplicationVersion(version);
    }

    public void setApplicationData(String type, String os, int handle, byte[] ico) {
        this.setType(type);
        this.setIcon(ico);
        this.driverVersion = "";
        this.winHandle = handle;
        this.systemValues.setOsName(os);
    }

    public void setApplicationData(String type, String version, byte[] ico) {
        this.setType(type);
        this.setIcon(ico);
        this.systemValues.setOsVersion(version);
    }

    public void setApplicationData(String type, String os, String version, String dVersion, long pid, byte[] icon, double scale) {
        this.setApplicationData(type, os, version, dVersion, pid, icon, "");
        this.setScale(scale);
    }

    public void setApplicationData(String type, String os, String name, String version, String dVersion, long pid, int handle, byte[] icon, String warn) {
        this.setApplicationData(type, os, name, version, dVersion, pid, handle, icon);
        this.warning = warn;
    }

    public void setApplicationData(String type, String os, String name, String version, String dVersion, long pid, int handle, byte[] icon, String warn, String sapUrl) {
        this.setApplicationData(type, os, name, version, dVersion, pid, handle, icon, warn);
        this.driverUrl = sapUrl;
    }

    public void setApplicationData(String type, String os, String name, String version, String dVersion, long pid, int handle, byte[] icon) {
        this.setApplicationData(type, os, version, dVersion, pid, icon, "");
        this.systemValues.setApplicationName(name);
        this.winHandle = handle;
    }

    public void setApplicationData(String type, String os, String name, String version, String dVersion, long pid) {
        this.setApplicationData(type, os, version, dVersion, pid, new byte[0], "");
        this.systemValues.setApplicationName(name);
    }

    public void setApplicationData(String type, String os, String version, String dVersion, long pid, long handle) {
        this.setApplicationData(type, os, version, dVersion, pid, new byte[0], "");
        this.winHandle = (int)handle;
    }

    public void switchToFrame(String id) {
        this.engine.switchToFrameId(id);
    }

    public void clearData() {
        this.setIcon(null);
        this.operations.clear();
    }

    public Future<List<FoundElement>> getInputFiles() {
        return this.getDriverEngine().getInputFiles();
    }

    public FoundElement getElementFromPoint(Boolean syscomp, Double x, Double y) {
        return this.engine.getElementFromPoint(syscomp, x, y);
    }

    public FoundElement getElementFromRect(Boolean syscomp, Double x, Double y, Double w, Double h) {
        return this.engine.getElementFromRect(syscomp, x, y, w, h);
    }

    public void loadParents(FoundElement hoverElement) {
        if (hoverElement != null) {
            this.engine.loadParents(hoverElement);
        }
    }

    public CalculatedProperty[] getCssAttributes(FoundElement element) {
        return this.engine.getCssAttributes(element);
    }

    public CalculatedProperty[] getHtmlAttributes(FoundElement element) {
        return this.engine.getHtmlAttributes(element);
    }

    public CalculatedProperty[] getAttributes(FoundElement element) {
        return this.engine.getAttributes(element, false);
    }

    public List<String[]> findSelectOptions(TestElement element) {
        return this.engine.loadSelectOptions(element);
    }

    public String getAttribute(ActionStatus status, FoundElement element, String attributeName, int maxTry) {
        return this.engine.getAttribute(status, element, attributeName, maxTry + AtsSingleton.getInstance().getMaxTryProperty());
    }

    public void setSysProperty(String attributeName, String attributeValue) {
        this.engine.setSysProperty(attributeName, attributeValue);
    }

    public String getOs() {
        return this.systemValues.getOsName();
    }

    public String getApplication() {
        return this.systemValues.getApplicationName();
    }

    public String getApplicationVersion() {
        return this.systemValues.getApplicationVersion();
    }

    public boolean attachToExistingProcess() {
        if (this.actionStart != null) {
            return this.actionStart.isAttach();
        }
        return false;
    }

    public boolean isSameName(String value) {
        return this.actionStart.getName().equalsIgnoreCase(value);
    }

    public boolean isDesktop() {
        return this.engine instanceof SystemDriverEngine || this.engine instanceof SapDriverEngine;
    }

    public boolean isSap() {
        return this.engine instanceof SapDriverEngine;
    }

    public void setZoom(double d) {
        int z = (int)Math.round(d);
        if (z != 100) {
            this.warning = this.warning + "Browser zoom is " + z + "% (it should be 100%)";
        }
    }

    public void tryAndWait(int code, String message, int max, int left) {
        this.sendWarningLog(code, message, left);
        if (max > left) {
            this.progressiveWait(max - left);
        } else {
            this.sleepMiddle();
        }
    }

    public void sendLog(int code, String message, Object value) {
        this.mainScript.getLogger().sendLog(code, message, value);
    }

    public void sendWarningLog(int code, String message, Object value) {
        this.mainScript.getLogger().sendWarning(code, message, value);
    }

    public void sendWarningLog(String message, Object value) {
        this.mainScript.getLogger().sendWarning(51, message, value);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double value) {
        this.scale = value;
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String value) {
        this.warning = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public ArrayList<String> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(ArrayList<String> value) {
        this.systemProperties = value;
    }

    public ArrayList<String> getSystemButtons() {
        return this.systemButtons;
    }

    public void setSystemButtons(ArrayList<String> value) {
        this.systemButtons = value;
    }

    public ArrayList<String> getOperations() {
        return this.operations;
    }

    public void setOperations(ArrayList<String> value) {
        this.operations = value;
    }

    public SystemValues getSystemValues() {
        return this.systemValues;
    }

    public void setSystemValues(SystemValues value) {
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(String url) {
    }

    public String getName() {
        return this.actionStart.getName();
    }

    public void setName(String name) {
    }

    public String getAuthentication() {
        if (this.actionStart.getAuthentication() != null && this.actionStart.getAuthenticationValue() != null && this.actionStart.getAuthentication().length() > 0 && this.actionStart.getAuthenticationValue().length() > 0) {
            return this.actionStart.getAuthentication();
        }
        return "";
    }

    public void setAuthentication(String value) {
    }

    public int getNetwork() {
        return this.actionStart.getNetwork();
    }

    public void setNetwork(int value) {
        this.actionStart.setNetwork(value);
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean value) {
        this.current = value;
        if (value) {
            this.setWindowToFront();
        }
    }

    public byte[] getIcon() {
        return this.icon;
    }

    public void setIcon(byte[] value) {
        this.icon = value;
    }

    public String getScreenServer() {
        return this.screenServer;
    }

    public void setScreenServer(String value) {
        this.screenServer = value;
    }

    public TestBound getDimension() {
        return this.dimension;
    }

    public void setFullScreenSize(long w, long h) {
        this.dimension = new TestBound(0.0, 0.0, Double.valueOf(w), Double.valueOf(h));
    }

    public void setDimension(TestBound value) {
        this.dimension = value;
    }

    public String getBoundDimension() {
        return this.dimension.getX().intValue() + "," + this.dimension.getY().intValue() + "," + this.dimension.getWidth().intValue() + "," + this.dimension.getHeight().intValue();
    }

    public long getProcessId() {
        return this.processId;
    }

    public void setProcessId(long value) {
    }

    public TestBound getSubDimension() {
        return this.subDimension;
    }

    public void setSubDimension(TestBound value) {
        this.subDimension = value;
    }

    public String getDriverUrl() {
        return this.driverUrl;
    }

    public void setDriverUrl(String value) {
        this.driverUrl = value;
    }

    public void close() {
        this.close(this.newActionStatus());
    }

    public void close(ActionStatus status) {
        if (this.stopNeoloadRecord != null) {
            this.neoloadAction(this.stopNeoloadRecord, "", 0);
        }
        this.closeAtsProxy();
        this.engine.close();
        AtsSingleton.getInstance().channelClosed(status, this);
    }

    public void progressiveWait(int value) {
        this.sleep(100 + value * 50);
    }

    public void sleep() {
        this.mainScript.sleep(AtsSingleton.getInstance().getVelocity().getDefault());
    }

    public void sleepLow() {
        this.mainScript.sleep(AtsSingleton.getInstance().getVelocity().getLow());
    }

    public void sleepMiddle() {
        this.mainScript.sleep(AtsSingleton.getInstance().getVelocity().getMiddle());
    }

    public void sleepHigh() {
        this.mainScript.sleep(AtsSingleton.getInstance().getVelocity().getHigh());
    }

    public void sleep(int ms) {
        this.mainScript.sleep(ms);
    }

    public void actionTerminated(ActionStatus status) {
        this.engine.waitAfterAction(status);
    }

    public int getActionWait() {
        if (this.engine == null) {
            return 0;
        }
        return this.engine.getActionWait();
    }

    public void resetToDefaultWindow() {
        this.engine.resetToDefaultWindow();
    }

    public WebElement getRootElement() {
        return this.engine.getRootElement(this);
    }

    public List<String[]> getWindowsData() {
        return this.engine.getWindowsData();
    }

    public String switchWindow(ActionStatus status, String type, boolean regexp, CalculatedValue cv, int tries, int delay, boolean refresh) {
        if (delay > 0 && delay < 100) {
            this.sleep(delay * 1000);
        }
        String data = cv.getCalculated();
        boolean success = this.engine.switchWindow(status, type, data, regexp, refresh);
        for (int maxTry = tries; !success && maxTry > 0; --maxTry) {
            this.tryAndWait(55, "window not found, wait and try again", tries, maxTry);
            success = this.engine.switchWindow(status, type, data, regexp, refresh);
        }
        if (status.isPassed()) {
            this.engine.updateDimensions();
            if (refresh) {
                this.updateWinHandle(this.getSystemDriver(), cv.getCalculatedInteger());
            }
        }
        return data;
    }

    public String updateWindowBound(ActionStatus actionStatus, BoundData x, BoundData y, BoundData w, BoundData h) {
        String bounds = this.engine.setWindowBound(x, y, w, h);
        this.engine.updateDimensions();
        this.sleep(100);
        this.getSystemDriver().updateVisualImage(this.getDimension(), false);
        return bounds;
    }

    public void closeWindow(ActionStatus status) {
        this.engine.closeWindow(status);
    }

    public void windowState(ActionStatus status, String state) {
        this.engine.windowState(status, this, state);
    }

    public Object executeScript(ActionStatus status, String script, Object ... params) {
        return this.engine.executeScript(status, script, params);
    }

    public DialogBox switchToAlert() {
        return this.engine.switchToAlert();
    }

    public void switchToDefaultContent(boolean dialog) {
        this.engine.switchToDefaultContent(dialog);
    }

    public void navigate(ActionStatus status, String url) {
        this.engine.goToUrl(status, url);
    }

    public File saveCurrentPage() {
        return this.engine.saveCurrentPage();
    }

    public void api(ActionStatus status, ActionApi api) {
        this.engine.api(status, api);
    }

    public IDriverEngine getSystemDriverEngine() {
        return this.getSystemDriver().getEngine();
    }

    public IDriverEngine getDriverEngine() {
        return this.engine;
    }

    public List<DesktopData> getShapes(String duration, String device, int[] rect) throws Exception {
        return this.getSystemDriver().getShapes(this.dimension, duration, device, rect);
    }

    public void newWindow(ActionStatus status, WindowType type, CalculatedValue url) {
        this.engine.newWindow(status, type, url);
    }

    public void saveAppSource(String testName) {
    }

    public void scroll(int delta) {
        this.engine.scroll(delta * this.scrollUnit);
    }

    public void scroll(FoundElement foundElement, int delta) {
        this.engine.scroll(foundElement, delta * this.scrollUnit);
    }

    public void mouseMoveToElement(ActionStatus status, FoundElement foundElement) {
        this.engine.mouseMoveToElement(foundElement);
        this.actionTerminated(status);
    }

    public void mouseMoveToElement(ActionStatus status, FoundElement foundElement, MouseDirection position) {
        this.engine.mouseMoveToElement(status, foundElement, position, false, 0, 0);
        this.actionTerminated(status);
    }

    public void buttonClick(ActionStatus status, String buttonType) {
        this.engine.buttonClick(status, buttonType);
    }

    public void neoloadAction(ActionNeoload action, String testName, int testLine) {
        this.newActionStatus(action, new VisualRecorderNull(), testName, testLine, true);
        if (this.getNetwork() == 2) {
            if (this.neoloadDesignApi != null) {
                action.executeRequest(this, this.neoloadDesignApi);
            } else {
                action.getStatus().setPassed(false);
                action.getStatus().setMessage("Neoload design API is not defined in .atsProperties !");
            }
        } else {
            action.getStatus().setPassed(true);
        }
    }

    public void setStopNeoloadRecord(ActionNeoloadStop value) {
        this.stopNeoloadRecord = value;
    }

    public IAtsProxy getProxy() {
        AtsManager ats = AtsSingleton.getInstance().getAts();
        if (this.getNetwork() == 1) {
            this.atsProxy = new AtsProxy(this.actionStart, this.getName(), this.getApplication(), ats.getBlackListServers(), ats.getTrafficIdle(), ats.getOctoperf());
            return this.atsProxy;
        }
        return AtsSingleton.getInstance().getProxy();
    }

    public void startHarServer(ActionStatus status, List<String> whiteList, int trafficIddle, int latency, long sendBandWidth, long receiveBandWidth) {
        this.atsProxy.startRecord(status, whiteList, trafficIddle, latency, sendBandWidth, receiveBandWidth);
    }

    public void pauseHarRecord() {
        this.atsProxy.pauseRecord();
    }

    public void resumeHarRecord() {
        this.atsProxy.resumeRecord();
    }

    public void startHarAction(Action action, String testLine, String uid) {
        this.atsProxy.startAction(action, testLine, uid);
    }

    public void endHarAction() {
        this.atsProxy.endAction();
    }

    public void sendToOctoperfServer(ActionOctoperfVirtualUser action) {
        this.atsProxy.sendToOctoperfServer(this, action);
    }

    public void closeAtsProxy() {
        this.atsProxy.terminate(this.getName());
        while (!this.atsProxy.isTerminated()) {
            Thread.yield();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.atsProxy = new AtsNoProxy();
    }

    public void addStepComment(ActionComment action, IVisualRecorder recorder, String type, String calculated) {
        recorder.update(0, action.getStatus().endDuration(), type, calculated);
    }

    public void updateSummary(ActionComment action, IVisualRecorder recorder, String testName, int testLine, String calculated) {
        recorder.updateSummary(testName, testLine, calculated);
    }

    public void testFail(Action action, int line, TestError.TestErrorStatus testErrorStatus, Path outputPath, String testName) {
        this.addShadowActionError(action, line, testErrorStatus);
        this.engine.saveCurrentDom(outputPath, testName);
    }

    public void addShadowActionError(Action action, int line, TestError.TestErrorStatus testErrorStatus) {
    }

    public void addShadowAction(Action action, int line) {
    }

    public void switchTo(ActionStatus status, ActionTestScript ts, String testName, int testLine, String name) {
        status.setNoError();
        status.endDuration();
        if (AtsSingleton.getInstance().switchChannel(status, name)) {
            this.getSystemDriver().updateVisualImage(AtsSingleton.getInstance().getChannel(name).getDimension(), false);
            ts.getRecorder().update(0, status.endDuration(), name);
        } else {
            ts.getRecorder().update(-9, status.endDuration(), name, "channel is not running");
            status.setError(-9, "channel '" + name + "' is not running");
        }
    }

    public void closeChannel(ActionStatus status, ActionTestScript ts, String testName, int testLine, String name) {
        long time = Instant.now().toEpochMilli();
        status.setNoError();
        ts.getRecorder().updateScreen(false);
        if (AtsSingleton.getInstance().closeChannel(status, name)) {
            ts.getRecorder().update(0, Instant.now().toEpochMilli() - time, name, "{\"name\":\"" + name + "\",\"app\":\"" + status.getValue() + "\"}");
            status.setValue(name);
        } else {
            ts.getRecorder().update(-9, Instant.now().toEpochMilli() - time, name, "{\"name\":\"" + name + "\",\"app\":\"[N/A]\", \"error\":\"channel is not running\"}");
            status.setError(-9, "channel '" + name + "' is not running");
        }
    }

    public void updateVisualCallScript(String calledScript, IVisualRecorder recorder, ActionCallscript action, String testName, int line) {
        recorder.update(0, action.getStatus().endDuration(), calledScript);
    }

    public void updateRecorderData(ActionTestScript ts, String calledScript, String paramsData) {
        if (paramsData != null && !paramsData.isEmpty()) {
            ts.getRecorder().update(calledScript, paramsData);
        }
    }

    public String createVisualAction(IVisualRecorder recorder, Action action, String testName, int line) {
        return recorder.createVisualAction(action, testName, line);
    }

    public String createVisualAction(boolean stop, Action action, int scriptLine, String scriptName, long timeline, boolean sync) {
        if (this.engine != null) {
            return this.engine.createVisualAction(this, stop, action.getClass().getName(), scriptLine, scriptName, timeline, sync);
        }
        return "";
    }

    public void updateVisualAction(boolean isRef) {
        if (this.engine != null) {
            this.engine.updateScreenshot(this.dimension, isRef);
        }
    }

    public DesktopResponse startVisualRecord(ScriptHeader header, int quality, long started) {
        if (this.getSystemDriver() != null) {
            return this.getSystemDriver().startVisualRecord(header, quality, started);
        }
        return null;
    }

    public void stopVisualRecord(ScriptStatus status, TestSummary summary) {
        if (this.getSystemDriver() != null) {
            this.getSystemDriver().saveSummary(status, summary);
            this.getSystemDriver().stopVisualRecord();
        }
    }

    public void saveVisualReportFile(Path path, String fileName, ExecutionLogger logger) {
        if (this.getSystemDriver() != null) {
            this.getSystemDriver().saveVisualReportFile(path.resolve(fileName), logger);
        }
    }

    public void updateVisualAction(String value) {
        this.getSystemDriver().updateVisualValue(value);
    }

    public void updateVisualAction(String value, String data) {
        this.getSystemDriver().updateVisualData(value, data);
    }

    public void updateVisualAction(String type, MouseDirectionData hdir, MouseDirectionData vdir) {
        this.getSystemDriver().updateVisualPosition(type, hdir, vdir);
    }

    public void updateVisualAction(TestElement element) {
        this.getSystemDriver().updateVisualElement(element);
    }

    public void updateVisualAction(int error, long duration) {
        this.getSystemDriver().updateVisualStatus(error, duration);
    }

    public void updateVisualAction(int error, long duration, String value) {
        this.getSystemDriver().updateVisualStatus(error, duration);
        this.getSystemDriver().updateVisualValue(value);
    }

    public void updateVisualAction(int error, long duration, String value, String data) {
        if (this.getSystemDriver() != null) {
            this.getSystemDriver().updateVisualStatus(error, duration);
            this.getSystemDriver().updateVisualData(value, data);
        }
    }
}

