/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.mobiles;

import com.ats.AtsSingleton;
import com.ats.driver.ApplicationProperties;
import com.ats.driver.AtsRemoteWebDriver;
import com.ats.element.AtsElement;
import com.ats.element.FoundElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.channels.MobileChromeChannel;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.MobileDriverEngine;
import com.ats.executor.drivers.engines.WebDriverEngine;
import com.ats.executor.drivers.engines.browsers.BrowserArgumentsParser;
import com.ats.generator.ATS;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.interactions.Actions;

public class MobileChromeDriverEngine
extends WebDriverEngine {
    private String token;
    private final String userAgent;
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final OkHttpClient client;
    private final MobileDriverEngine mobileDriver;

    public MobileChromeDriverEngine(MobileChromeChannel channel, ActionStatus status, IDriverInfo driverInfo, SystemDriver systemDriver, MobileDriverEngine mobileDriver, ApplicationProperties props, boolean enableLearning) {
        super(channel, driverInfo, systemDriver, props, AtsSingleton.getInstance().getVelocity().getMobileDefaultWait(), AtsSingleton.getInstance().getVelocity().getMobileDefaultWait(), enableLearning);
        this.mobileDriver = mobileDriver;
        this.userAgent = "AtsMobileDriver/" + ATS.getAtsVersion() + "," + System.getProperty("user.name") + ",";
        this.client = new OkHttpClient.Builder().cache(null).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(50L, TimeUnit.SECONDS).readTimeout(50L, TimeUnit.SECONDS).build();
        String endPoint = props.getName().substring("mobile-chrome".length() + 3);
        this.applicationPath = "http://" + endPoint;
        if (mobileDriver.chromeDriver == null || mobileDriver.chromeDriver.isEmpty()) {
            status.setError(-19, "chromedriver address not set to the driver");
            return;
        }
        if (mobileDriver.serialNumber == null || mobileDriver.serialNumber.isEmpty()) {
            status.setError(-19, "serialNumber not set to the driver");
            return;
        }
        String compatibleDriverVersion = this.getDriverVersion(mobileDriver.chromeVersion);
        if (compatibleDriverVersion == null || !compatibleDriverVersion.equals(mobileDriver.chromeDriverVersion)) {
            status.setError(-19, "This version of ChromeDriver (" + mobileDriver.chromeDriverVersion + ") does not support this version of Chrome application (" + mobileDriver.chromeVersion + ")");
            return;
        }
        channel.setApplicationData("mobile-chrome", "0", "\u00e0".getBytes(), "chrome-mobile");
        BrowserArgumentsParser browserArguments = new BrowserArgumentsParser(driverInfo, channel.getArguments(), props, "mobile-chrome", this.applicationPath, systemDriver);
        ChromeOptions options = new ChromeOptions();
        options.setExperimentalOption("androidPackage", (Object)"com.android.chrome");
        options.setExperimentalOption("androidDeviceSerial", (Object)mobileDriver.serialNumber);
        if (browserArguments.isHeadless()) {
            options.addArguments(new String[]{"--headless"});
            options.addArguments(new String[]{"--disable-gpu"});
        }
        if (browserArguments.isIncognito()) {
            options.addArguments(new String[]{"--incognito"});
        }
        try {
            this.driver = new AtsRemoteWebDriver(new URI("http://" + mobileDriver.chromeDriver).toURL(), (Capabilities)options);
        }
        catch (MalformedURLException | URISyntaxException e) {
            status.setError(-19, "remote driver url error -> " + mobileDriver.chromeDriver);
            return;
        }
        this.actions = new Actions((WebDriver)this.driver);
        try {
            this.driver.navigate().to("http://" + mobileDriver.statusPage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.refreshElementMapLocation();
    }

    @Override
    public synchronized void close() {
        this.closeWindows();
        JsonNode jsonObject = this.executeRequest("driver", "stop");
        if (jsonObject != null) {
            this.token = null;
        }
    }

    public JsonNode executeRequest(String type, String ... data) {
        return MobileDriverEngine.executeRequestToMobile(this.applicationPath + "/" + type, this.token, this.userAgent, this.client, this.jsonMapper, data);
    }

    private String getDriverVersion(String chromeVersion) {
        String cleanVersion = chromeVersion.substring(0, chromeVersion.lastIndexOf(46));
        Request request = new Request.Builder().url("https://chromedriver.storage.googleapis.com/LATEST_RELEASE_" + cleanVersion).build();
        try {
            Response response = this.client.newCall(request).execute();
            String responseData = CharStreams.toString((Readable)new InputStreamReader(Objects.requireNonNull(response.body()).byteStream(), StandardCharsets.UTF_8));
            response.close();
            return responseData;
        }
        catch (IOException e) {
            return null;
        }
    }

    public MobileDriverEngine getMobileDesktopDriver() {
        return this.mobileDriver;
    }

    @Override
    public FoundElement getElementFromPoint(Boolean isSystemElement, Double x, Double y) {
        if (isSystemElement.booleanValue()) {
            return this.mobileDriver.getElementFromPoint(true, x, y);
        }
        this.switchToDefaultContent(false);
        x = x - this.channel.getSubDimension().getX();
        y = y - this.channel.getSubDimension().getY();
        return this.loadElement(new ArrayList<AtsElement>(), null, x, y, this.initElementX, this.initElementY);
    }

    @Override
    public void loadParents(FoundElement hoverElement) {
        if (hoverElement.isMobile()) {
            this.mobileDriver.loadParents(hoverElement);
        } else {
            hoverElement.setParent(this.getTestElementParent(hoverElement));
        }
    }

    @Override
    public void mouseClick(ActionStatus status, FoundElement element, MouseDirection position, int offsetX, int offsetY) {
        if (element.isMobile()) {
            this.mobileDriver.mouseClick(status, element, position, offsetX, offsetY);
        } else {
            super.mouseClick(status, element, position, offsetX, offsetY);
        }
    }

    @Override
    public CalculatedProperty[] getAttributes(FoundElement element, boolean reload) {
        if (element.isMobile()) {
            return this.mobileDriver.getAttributes(element, reload);
        }
        return this.getAttributes(this.getWebElement(element));
    }
}

