/*
 * Decompiled with CFR 0.152.
 */
package com.ats.recorder;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.Gson;
import java.util.List;

public class TestError {
    private String script;
    private int line = 0;
    private String message;
    private TestErrorStatus testErrorStatus;

    public TestErrorStatus getTestErrorStatus() {
        return this.testErrorStatus;
    }

    public void setTestErrorStatus(TestErrorStatus value) {
        this.testErrorStatus = value;
    }

    public TestError() {
    }

    public TestError(List<TestError> errors) {
        this.script = errors.getFirst().getScript();
        this.line = 0;
        this.message = new Gson().toJson(errors);
    }

    public TestError(String script, int line, String message) {
        this.script = script;
        this.line = line;
        this.message = message;
    }

    public TestError(String script, int line, String message, TestErrorStatus executionStatus) {
        this.script = script;
        this.line = line;
        this.message = message;
        this.testErrorStatus = executionStatus;
    }

    @JsonIgnore
    public Object getScriptLine() {
        StringBuilder sb = new StringBuilder(this.script).append(":").append(this.line);
        return sb.toString();
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String value) {
        this.script = value;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static enum TestErrorStatus {
        FAIL_CONTINUE,
        FAIL_STOP,
        FAIL_PASS;

    }
}

