/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script;

import com.ats.generator.GeneratorReport;
import com.ats.generator.parsers.Lexer;
import com.ats.generator.parsers.ScriptParser;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.script.Project;
import com.ats.script.Script;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionCallscript;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.ahocorasick.trie.Trie;

public class AtsScript
extends Script {
    public static final String SCRIPT_EXTENSION_ERROR = "ERR #198 - wrong file extension";
    public static final String SCRIPT_LOADING_ERROR = "ERR #199 - the script cannot be loaded";
    private ScriptParser parser;
    private ScriptHeader header;
    private String javaCode = null;
    private Charset charset = StandardCharsets.UTF_8;
    private ArrayList<Action> actions = new ArrayList();
    private String projectGav = "";
    private int actionsCount = 0;
    private int callscripts = 0;
    private long size;

    public AtsScript() {
    }

    public AtsScript(Lexer lexer) {
        this.parser = new ScriptParser(lexer);
        this.parser.addScript();
    }

    public AtsScript(String type, Lexer lexer, File file, Project project) {
        this(type, lexer, file, project, DEFAULT_CHARSET);
    }

    public AtsScript(String type, Lexer lexer, File file, Project project, Charset charset) {
        this(new ScriptHeader(project, file), file);
        this.projectGav = project.getGav();
        this.charset = charset;
        if ("ats".equals(type)) {
            if (file.getName().endsWith(".ats")) {
                this.setParameterList(new ParameterList(1));
                this.setVariables(new ArrayList<Variable>());
                this.parser = new ScriptParser(lexer);
                this.parser.addScript();
                try (Stream<String> lines = Files.lines(file.toPath(), this.charset);){
                    lines.map(String::trim).filter(a -> !a.isEmpty()).filter(a -> !a.startsWith("[")).forEach(a -> this.parser.parse(this, this.header, (String)a));
                }
                catch (Exception e) {
                    System.err.println("ATS load project error (ERR #199 - the script cannot be loaded) :\n" + file.getAbsolutePath());
                    this.header.setName(file.getName());
                    this.header.setPackageName("...");
                    this.header.setError(SCRIPT_LOADING_ERROR);
                }
            } else {
                this.header.setName(file.getName());
                this.header.setPackageName("...");
                this.header.setError(SCRIPT_EXTENSION_ERROR);
            }
        } else if ("java".equals(type)) {
            try {
                this.javaCode = new String(Files.readAllBytes(file.toPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public AtsScript(Lexer lexer, String content, Project project) {
        ScriptHeader h;
        this.header = h = new ScriptHeader(project);
        this.projectGav = project.getGav();
        this.setParameterList(new ParameterList(1));
        this.setVariables(new ArrayList<Variable>());
        this.parser = new ScriptParser(lexer);
        this.parser.addScript();
        try {
            this.parser.parse(this, h, content);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AtsScript(ScriptHeader h, File f) {
        this.header = h;
        this.size = f.length();
    }

    public AtsScript(ScriptHeader header) {
        this(header, new File(header.getPath()));
    }

    public AtsScript(Lexer lexer, File file) {
        this(lexer.loadScript(file), file);
    }

    public AtsScript(AtsScript script, File file) {
        this(script.header, file);
        try (Stream stream = script.getActions().parallelStream();){
            stream.forEach(this::count);
        }
    }

    public AtsScript(Project project, File file) {
        this(new ScriptHeader(project, file), file);
    }

    private void count(Action a) {
        if (a instanceof ActionCallscript) {
            ++this.callscripts;
        } else {
            ++this.actionsCount;
        }
    }

    public void addAction(Action data, boolean disabled) {
        data.setDisabled(disabled);
        data.setLine(this.actions.size());
        this.actions.add(data);
    }

    public void addAction(Action data, boolean disabled, String atsCode) {
        this.addAction(data, disabled);
        data.setCode(atsCode);
    }

    public boolean isSubscriptCalled(String scriptName) {
        for (Action action : this.actions) {
            if (!(action instanceof ActionCallscript) || !((ActionCallscript)action).isSubscriptCalled(scriptName)) continue;
            return true;
        }
        return false;
    }

    public boolean getActionsKeywords(Trie trie) {
        for (Action action : this.actions) {
            ArrayList<String> actionKeywords = action.getKeywords();
            for (String keywords : actionKeywords) {
                if (!trie.containsMatch((CharSequence)keywords)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateSubscript(ArrayList<String> result, String oldName, String newName) {
        ArrayList<String[]> replacements = new ArrayList<String[]>();
        for (Action a : this.actions) {
            ActionCallscript action;
            if (!(a instanceof ActionCallscript) || !oldName.equals((action = (ActionCallscript)a).getName().getData())) continue;
            int start = a.getAtsCode().indexOf(oldName);
            int end = start + oldName.length();
            replacements.add(new String[]{a.getAtsCode(), a.getAtsCode().substring(0, start) + newName + a.getAtsCode().substring(end)});
        }
        this.saveUpdates(result, replacements);
    }

    public void updateDataFile(ArrayList<String> result, String oldPath, String newPath) {
        ArrayList<String[]> replacements = new ArrayList<String[]>();
        for (Action a : this.actions) {
            ActionCallscript action;
            if (!(a instanceof ActionCallscript) || (action = (ActionCallscript)a).getParameterFilePath() == null || !oldPath.equals(action.getParameterFilePath().getData())) continue;
            replacements.add(new String[]{a.getAtsCode(), a.getAtsCode().replace(oldPath, newPath)});
        }
        this.saveUpdates(result, replacements);
    }

    private void saveUpdates(ArrayList<String> result, ArrayList<String[]> replacements) {
        if (!replacements.isEmpty()) {
            ArrayList<String> lines = new ArrayList<String>();
            Path path = Paths.get(this.header.getPath(), new String[0]);
            try (Stream<String> stream2 = Files.lines(path);){
                stream2.forEach(lines::add);
            }
            catch (IOException stream2) {
                // empty catch block
            }
            int i = 0;
            String[] replace = replacements.removeFirst();
            for (String line : lines) {
                if (line.equals(replace[0])) {
                    lines.set(i, replace[1]);
                    if (!replacements.isEmpty()) {
                        replace = replacements.removeFirst();
                    }
                }
                ++i;
            }
            try {
                Files.write(path, lines, Charset.defaultCharset(), new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            result.add(this.header.getQualifiedName());
        }
    }

    public String getJavaCode(Project project) {
        if (this.javaCode != null) {
            return this.javaCode;
        }
        StringBuilder code = new StringBuilder(this.header.getJavaCode(project));
        code.append("\r\n\r\n\t\t//   ---< Variables >---   //\r\n");
        List<Variable> variables = this.getVariables();
        Collections.sort(variables);
        for (Variable variable : variables) {
            code.append("\r\n\t\t").append(variable.getJavaCode()).append(";");
        }
        code.append("\r\n\r\n\t\t//   ---< Actions >---   //\r\n");
        for (Action action : this.actions) {
            if (action.isDisabled() || action.isScriptComment()) continue;
            code.append("\r\n\t\t").append((CharSequence)action.getJavaCode()).append(");");
        }
        CalculatedValue[] returnValues = this.getReturns();
        if (returnValues != null) {
            code.append("\r\n\r\n\t\t//   ---< Return >---   //\r\n\r\n\t\t").append("r").append("(");
            ArrayList<String> returnValuesCode = new ArrayList<String>();
            for (CalculatedValue ret : returnValues) {
                returnValuesCode.add(ret.getJavaCode());
            }
            code.append(String.join((CharSequence)", ", returnValuesCode)).append(");");
        }
        code.append("\r\n\t}\r\n}");
        return code.toString();
    }

    public void generateJavaFile(Project project) {
        if (this.header.getJavaDestinationFolder() != null) {
            File javaFile = this.header.getJavaFile();
            javaFile.getParentFile().mkdirs();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(javaFile, false), this.charset));){
                writer.write(this.getJavaCode(project));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getActionsCount() {
        return this.actionsCount;
    }

    public void setActionsCount(int value) {
        this.actionsCount = value;
    }

    public int getCallscripts() {
        return this.callscripts;
    }

    public void setCallscripts(int callscripts) {
        this.callscripts = callscripts;
    }

    public String getAuthor() {
        return this.header.getAuthor();
    }

    public void setAuthor(String author) {
        this.header.setAuthor(author);
    }

    public String getDescription() {
        return this.header.getDescription();
    }

    public void setDescription(String description) {
        this.header.setDescription(description);
    }

    public String getId() {
        return this.header.getId();
    }

    public void setId(String id) {
        this.header.setId(id);
    }

    public List<String> getGroups() {
        return this.header.getGroups();
    }

    public void setGroups(List<String> groups) {
        this.header.setGroups(groups);
    }

    public String getPrerequisite() {
        return this.header.getPrerequisite();
    }

    public void setPrerequisite(String prerequisite) {
        this.header.setPrerequisite(prerequisite);
    }

    public Date getCreatedAt() {
        return this.header.getCreatedAt();
    }

    public void setCreatedAt(Date createdAt) {
        this.header.setCreatedAt(createdAt);
    }

    public Date getModifiedAt() {
        return this.header.getModifiedAt();
    }

    public void setModifiedAt(Date modifiedAt) {
        this.header.setModifiedAt(modifiedAt);
    }

    public String getModifiedBy() {
        return this.header.getModifiedBy();
    }

    public void setModifiedBy(String name) {
        this.header.setModifiedBy(name);
    }

    public String getName() {
        return this.header.getName();
    }

    public void setName(String name) {
        this.header.setName(name);
    }

    public String getPackageName() {
        return this.header.getPackageName();
    }

    public void setPackageName(String packageName) {
        this.header.setPackageName(packageName);
    }

    public String getQualifiedName() {
        return this.header.getQualifiedName();
    }

    public void setQualifiedName(String qualifiedName) {
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getExternalId() {
        return this.header.getExternalId();
    }

    public void setExternalId(String id) {
        this.header.setExternalId(id);
    }

    public String getNativePath() {
        return this.header.getPath();
    }

    public void setNativePath(String nativePath) {
        this.header.setPath(nativePath);
    }

    public String getError() {
        return this.header.getError();
    }

    public void setError(String error) {
        this.header.setError(error);
    }

    public String getMemo() {
        return this.header.getMemo();
    }

    public void setMemo(String memo) {
        this.header.setMemo(memo);
    }

    public String getPreprocessing() {
        return this.header.getPreprocessing();
    }

    public void setPreprocessing(String preprocessing) {
        this.header.setPreprocessing(preprocessing);
    }

    public String getPostprocessing() {
        return this.header.getPostprocessing();
    }

    public void setPostprocessing(String postprocessing) {
        this.header.setPostprocessing(postprocessing);
    }

    public String getProjectPath() {
        return this.header.getProjectPath();
    }

    public void setProjectPath(String value) {
        this.header.setProjectPath(value);
    }

    public ScriptHeader getHeader() {
        return this.header;
    }

    public ArrayList<Action> getActions() {
        return this.actions;
    }

    public void setActions(ArrayList<Action> value) {
        this.actions = value;
    }

    public String getProjectGav() {
        return this.projectGav;
    }

    public void setProjectGav(String value) {
    }

    public Lexer getLexer() {
        return this.parser.getLexer();
    }

    public static void main(String[] args) {
        File scriptFile;
        if (args.length == 1 && (scriptFile = new File(args[0])).exists() && scriptFile.isFile() && scriptFile.getName().toLowerCase().endsWith("ats")) {
            Project projectData = Project.getProjectData(scriptFile, null, null);
            GeneratorReport report = new GeneratorReport();
            Lexer lexer = new Lexer(projectData, report, Script.DEFAULT_CHARSET);
            lexer.loadScript(scriptFile);
        }
    }
}

