/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.actions;

import com.ats.tools.Utils;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.Constants;
import com.ats.tools.report.actions.HtmlReportActionAssert;
import com.ats.tools.report.models.Action;
import com.ats.tools.report.models.OperatorsWithIcons;
import com.ats.tools.report.utils.HtmlActionUtils;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class HtmlReportActionAssertProperty
extends HtmlReportActionAssert {
    private static final String ERROR_TAG = "${errorTag}";
    private static final String JSON_SANITIZE_REGEX = "[\\x00-\\x1F]";

    public HtmlReportActionAssertProperty(String template, Action action) {
        this.result = template.replace(ERROR_TAG, HtmlActionUtils.buildActionFirstColumnHeaderErrorTag(action.getError()));
        this.result = this.result.replace("${searchedElementHeader}", HtmlActionUtils.buildSearchedElementHeader(action));
        this.result = this.result.replace("${searchedElement}", Objects.nonNull(action.getActionElement()) ? HtmlActionUtils.buildSearchedElementData(action) : "");
        HtmlReportActionAssertCondition htmlReportActionAssertCondition = this.parseValue(action);
        if (Objects.nonNull(htmlReportActionAssertCondition)) {
            this.result = this.result.replace("${operation}", this.buildOperation(htmlReportActionAssertCondition));
            this.result = this.result.replace("${propertyName}", htmlReportActionAssertCondition.name());
            this.result = this.result.replace("${actualLabel}", "Found");
            this.result = this.result.replace("${expectedLabel}", "Expected");
        } else {
            this.result = this.result.replace("${operation}", "");
            this.result = this.result.replace("${propertyName}", "");
        }
    }

    private HtmlReportActionAssertCondition parseValue(Action action) {
        if (StringUtils.isBlank((CharSequence)action.getValue())) {
            return null;
        }
        try {
            HtmlReportActionAssertCondition htmlReportActionAssertCondition = (HtmlReportActionAssertCondition)this.gson.fromJson(action.getValue().replaceAll(JSON_SANITIZE_REGEX, " "), HtmlReportActionAssertCondition.class);
            htmlReportActionAssertCondition = htmlReportActionAssertCondition.withNewActualAndExpected(action.getData(), Utils.escapeHTML(htmlReportActionAssertCondition.expected()));
            return htmlReportActionAssertCondition;
        }
        catch (JsonSyntaxException e) {
            AtsLogger.printLog("cannot parse assert property value", String.format("script %s, line %d; error msg %s", action.getScript(), action.getLine(), e.getMessage()));
            return null;
        }
    }

    private String buildOperation(HtmlReportActionAssertCondition htmlReportActionAssertCondition) {
        String operator = OperatorsWithIcons.getIconForOperator(htmlReportActionAssertCondition.operator());
        String actual = (String)Constants.CONDITIONALLY_REPLACE_TO_EMPTY_REPRESENTATION.apply(htmlReportActionAssertCondition.actual());
        String expected = (String)Constants.CONDITIONALLY_REPLACE_TO_EMPTY_REPRESENTATION.apply(htmlReportActionAssertCondition.expected());
        return "<div style=\"max-width: 45%\">\n    <div class=\"assertLib\">${actualLabel}</div>\n    <div style=\"min-height: 16px\">${actual}</div>\n</div>\n<div style=\"margin:0 10px\">${operator}</div>\n<div style=\"max-width: 45%\">\n    <div class=\"assertLib\">${expectedLabel}</div>\n    <div style=\"min-height: 16px\">${expected}</div>\n</div>".replace("${expected}", expected).replace("${actual}", actual).replace("${operator}", operator);
    }

    private record HtmlReportActionAssertCondition(String name, String operator, String expected, String actual) {
        public HtmlReportActionAssertCondition withNewActualAndExpected(String actual, String expected) {
            return new HtmlReportActionAssertCondition(this.name, this.operator, expected, actual);
        }
    }
}

