/*
 * Decompiled with CFR 0.152.
 */
package com.ats.driver;

import com.ats.driver.ApplicationProperties;
import com.ats.driver.AtsSystemProxy;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.TestBound;
import com.ats.tools.AtsClassLoader;
import com.ats.tools.Utils;
import com.ats.tools.performance.external.OctoperfApi;
import com.ats.tools.wait.IWaitGuiReady;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AtsManager {
    public static final String ATS_FOLDER_SIMPLE = "ats";
    public static final String ATS_FOLDER = ".actiontestscript";
    public static final String SCRIPTS_FOLDER = "ats_scripts";
    public static final String SCRIPTS_FOLDER_URL = "assets" + "/" + "ats_scripts";
    private static final String DRIVERS_FOLDER = "drivers";
    private static final String ATS_PROPERTIES_FILE = ".atsProperties";
    private static final int SYSTEM_DRIVER_PORT = 9700;
    private static final Double APPLICATION_WIDTH = 1280.0;
    private static final Double APPLICATION_HEIGHT = 960.0;
    private static final Double APPLICATION_X = 10.0;
    private static final Double APPLICATION_Y = 10.0;
    private static final int SCRIPT_TIMEOUT = 60;
    private static final int PAGELOAD_TIMEOUT = 120;
    private static final int WATCHDOG_TIMEOUT = 200;
    private static final int WEBSERVICE_TIMEOUT = 30;
    private static final int REGEX_TIMEOUT = 5;
    private static final int MAX_TRY_SEARCH = 15;
    private static final int MAX_TRY_INTERACTABLE = 20;
    private static final int MAX_TRY_PROPERTY = 10;
    private static final int MAX_TRY_WEBSERVICE = 1;
    private static final int MAX_TRY_IMAGE_RECOGNITION = 20;
    private static final int MAX_TRY_SCROLL_SEARCH = 15;
    private static final int SAP_START_TIMEOUT = 180;
    private static final int MAX_TRY_MOBILE = 5;
    private static final int SCROLL_UNIT = 120;
    private static final int MAX_STALE_OR_JAVASCRIPT_ERROR = 10;
    private static final int CAPTURE_PROXY_TRAFFIC_IDLE = 3;
    private static final String ATS_KEY_NAME = "ATS_KEY";
    private double applicationWidth = APPLICATION_WIDTH;
    private double applicationHeight = APPLICATION_HEIGHT;
    private double applicationX = APPLICATION_X;
    private double applicationY = APPLICATION_Y;
    private int scriptTimeOut = 60;
    private int pageloadTimeOut = 120;
    private int watchDogTimeOut = 200;
    private int regexTimeOut = 5;
    private int sapStartTimeOut = 180;
    private int webServiceTimeOut = 30;
    private int maxTrySearch = 15;
    private int maxTryInteractable = 20;
    private int maxTryProperty = 10;
    private int maxTryWebservice = 1;
    private int maxTryMobile = 5;
    private int maxTryImageRecognition = 20;
    private int maxTryScrollSearch = 15;
    private int waitEnterText = 0;
    private int waitSearch = 0;
    private int waitMouseMove = 0;
    private int waitSwitchWindow = 0;
    private int waitGotoUrl = 0;
    private AtsSystemProxy proxy = new AtsSystemProxy();
    private AtsSystemProxy neoloadProxy;
    private String neoloadDesignApi;
    private String atsPropertiesFilePath = null;
    private OctoperfApi octoperf;
    private ArrayList<String> blackListServers;
    private int trafficIdle = 3;
    private List<ApplicationProperties> applicationsList = new ArrayList<ApplicationProperties>();
    private String error;
    private String atsKey;
    private AtsClassLoader atsClassLoader;
    private Path driverPath;
    private List<URI> systemDriverUris = new ArrayList<URI>();

    public static int getScrollUnit() {
        return 120;
    }

    public static int getMaxStaleOrJavaScriptError() {
        return 10;
    }

    private static String getElementText(Node node) {
        return AtsManager.getElementText((Element)node);
    }

    private static String getElementText(Element elem) {
        String textContent;
        if (elem != null && (textContent = elem.getTextContent()) != null && !textContent.isEmpty()) {
            return textContent.replace("\n", "").replace("\r", "").trim();
        }
        return null;
    }

    private static double getElementDouble(Element elem) {
        String value = elem.getTextContent().replace("\n", "").replace("\r", "").trim();
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    private static int getElementInt(Element elem) {
        String value = elem.getTextContent().replace("\n", "").replace("\r", "").trim();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public AtsManager() {
        this.init();
    }

    public static String getAtsHomeFolder() {
        String atsHome = System.getProperty("ats-home");
        if (!(atsHome != null && !atsHome.isEmpty() || (atsHome = System.getProperty("ats.home")) != null && !atsHome.isEmpty() || (atsHome = System.getenv("ATS_HOME")) != null && !atsHome.isEmpty())) {
            Path userPath = Paths.get(System.getProperty("user.home"), new String[0]);
            Path atsPath = userPath.resolve(ATS_FOLDER);
            if (!Files.exists(atsPath, new LinkOption[0])) {
                atsPath = userPath.resolve(ATS_FOLDER_SIMPLE);
            }
            atsHome = atsPath.toString();
        }
        return atsHome;
    }

    public void init() {
        String atsHome = AtsManager.getAtsHomeFolder();
        Path atsFolderPath = null;
        try {
            atsFolderPath = Paths.get(atsHome, new String[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (atsFolderPath != null && atsFolderPath.toFile().exists()) {
            Path userHomePath = Paths.get(System.getProperty("user.home"), new String[0]);
            Path atsPropertiesFilePath = userHomePath.resolve(ATS_PROPERTIES_FILE);
            if (!Files.exists(atsPropertiesFilePath, new LinkOption[0]) && !Files.exists(atsPropertiesFilePath = userHomePath.resolve(ATS_FOLDER).resolve(ATS_PROPERTIES_FILE), new LinkOption[0])) {
                atsPropertiesFilePath = atsFolderPath.resolve(ATS_PROPERTIES_FILE);
            }
            if (Files.exists(atsPropertiesFilePath, new LinkOption[0])) {
                try {
                    this.loadProperties(atsPropertiesFilePath.toFile());
                }
                catch (Exception e) {
                    this.error = e.getMessage();
                }
            }
            this.addSystemDriver(System.getProperty("system-driver-url"));
            this.driverPath = atsFolderPath.resolve(DRIVERS_FOLDER);
        } else {
            this.driverPath = Paths.get("", new String[0]);
        }
        if (this.proxy == null) {
            this.proxy = new AtsSystemProxy("system");
        }
        this.atsClassLoader = new AtsClassLoader(this);
    }

    public IWaitGuiReady getWaitGuiReady() {
        return this.atsClassLoader.getWaitGuiReady();
    }

    public Class<ActionTestScript> loadTestScriptClass(ActionStatus status, String name) {
        return this.atsClassLoader.loadTestScriptClass(status, name);
    }

    public Path getDriverPath() {
        return this.driverPath;
    }

    public List<URI> getSystemDriverUris() {
        return this.systemDriverUris;
    }

    private void addSystemDriver(String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            if (!((String)value).startsWith("http")) {
                value = "http://" + (String)value;
            }
            if (((String)value).split(":").length != 3) {
                value = (String)value + ":9700";
            }
            try {
                URI newUri = new URI((String)value);
                if (!this.uriExists(newUri)) {
                    this.systemDriverUris.add(newUri);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean uriExists(URI u) {
        for (URI uri : this.systemDriverUris) {
            if (!uri.toString().equals(u.toString())) continue;
            return true;
        }
        return false;
    }

    private void loadProperties(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        this.atsPropertiesFilePath = xmlFile.getAbsolutePath();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(xmlFile);
        doc.getDocumentElement().normalize();
        Node executeNode = null;
        NodeList nodeList = doc.getChildNodes();
        for (Node node : AtsManager.iterable(nodeList)) {
            if (node.getNodeType() != 1 || !"execute".equals(node.getNodeName())) continue;
            executeNode = node;
            break;
        }
        if (executeNode == null) {
            return;
        }
        NodeList executeChildren = ((Element)executeNode).getChildNodes();
        block199: for (int i = 0; i < executeChildren.getLength(); ++i) {
            Node node = executeChildren.item(i);
            if (!(node instanceof Element)) continue;
            Element type = (Element)node;
            String url = null;
            switch (type.getNodeName().toLowerCase()) {
                case "atskey": {
                    this.atsKey = type.getChildNodes().item(0).getNodeValue();
                    continue block199;
                }
                case "systemdriver": {
                    NodeList dl = type.getChildNodes();
                    if (dl == null) continue block199;
                    for (int k = 0; k < dl.getLength(); ++k) {
                        if (!"driver".equals(dl.item(k).getNodeName())) continue;
                        this.addSystemDriver(AtsManager.getElementText(dl.item(k)));
                    }
                    continue block199;
                }
                case "atsremoteagents": {
                    NodeList urls = type.getElementsByTagName("url");
                    for (int j = 0; j < urls.getLength(); ++j) {
                        this.addSystemDriver(AtsManager.getElementText(urls.item(j)));
                    }
                    continue block199;
                }
                case "network": 
                case "performance": {
                    NodeList perfChildren = type.getChildNodes();
                    block202: for (int j = 0; j < perfChildren.getLength(); ++j) {
                        if (!(perfChildren.item(j) instanceof Element)) continue;
                        Element perfElement = (Element)perfChildren.item(j);
                        switch (perfElement.getNodeName().toLowerCase()) {
                            case "idle": {
                                this.trafficIdle = AtsManager.getElementInt(perfElement);
                                continue block202;
                            }
                            case "octoperf": {
                                String host = null;
                                String apiKey = null;
                                String workspaceName = null;
                                String projectName = null;
                                NodeList nl = perfElement.getElementsByTagName("host");
                                if (nl != null) {
                                    host = AtsManager.getElementText(nl.item(0));
                                }
                                if ((nl = perfElement.getElementsByTagName("apiKey")) != null) {
                                    apiKey = AtsManager.getElementText(nl.item(0));
                                }
                                if ((nl = perfElement.getElementsByTagName("workspaceName")) != null) {
                                    workspaceName = AtsManager.getElementText(nl.item(0));
                                }
                                if ((nl = perfElement.getElementsByTagName("projectName")) != null) {
                                    projectName = AtsManager.getElementText(nl.item(0));
                                }
                                if (host == null || apiKey == null) continue block202;
                                this.octoperf = new OctoperfApi(host, apiKey, workspaceName, projectName);
                                continue block202;
                            }
                            case "blacklist": {
                                this.blackListServers = new ArrayList();
                                NodeList blackList = perfElement.getElementsByTagName("url");
                                for (int k = 0; k < blackList.getLength(); ++k) {
                                    if (!(blackList.item(k) instanceof Element)) continue;
                                    this.blackListServers.add(AtsManager.getElementText(blackList.item(k)));
                                }
                                continue block202;
                            }
                        }
                    }
                    continue block199;
                }
                case "neoload": {
                    NodeList neoloadChildren = type.getChildNodes();
                    for (int j = 0; j < neoloadChildren.getLength(); ++j) {
                        Node node2 = neoloadChildren.item(j);
                        if (!(node2 instanceof Element)) continue;
                        Element neoloadElement = (Element)node2;
                        String host = null;
                        String port = null;
                        Object api = null;
                        String apiPort = null;
                        if (neoloadElement.getTagName().equals("recorder")) {
                            NodeList recorderChildren = neoloadElement.getChildNodes();
                            for (k = 0; k < recorderChildren.getLength(); ++k) {
                                k = recorderChildren.item(k);
                                if (!(k instanceof Element)) continue;
                                Element recorderElement = (Element)k;
                                if (recorderElement.getNodeName().equals("host")) {
                                    host = AtsManager.getElementText(recorderElement);
                                    continue;
                                }
                                if (!recorderElement.getNodeName().equals("port")) continue;
                                port = AtsManager.getElementText(recorderElement);
                            }
                        } else if (neoloadElement.getTagName().equals("design")) {
                            NodeList designChildren = neoloadElement.getChildNodes();
                            for (k = 0; k < designChildren.getLength(); ++k) {
                                k = designChildren.item(k);
                                if (!(k instanceof Element)) continue;
                                Element designElement = (Element)k;
                                if (designElement.getNodeName().equals("api")) {
                                    api = AtsManager.getElementText(designElement);
                                    continue;
                                }
                                if (!designElement.getNodeName().equals("port")) continue;
                                apiPort = AtsManager.getElementText(designElement);
                            }
                        }
                        if (host == null || port == null) continue;
                        this.neoloadProxy = new AtsSystemProxy(host, Utils.string2Int(port, 8080));
                        if (api == null || apiPort == null) continue;
                        if (!((String)api).startsWith("/")) {
                            api = "/" + (String)api;
                        }
                        if (!((String)api).endsWith("/")) {
                            api = (String)api + "/";
                        }
                        this.neoloadDesignApi = "http://" + this.neoloadProxy.getHost() + ":" + apiPort + (String)api;
                    }
                    continue block199;
                }
                case "proxy": {
                    NodeList proxyChildren = type.getChildNodes();
                    String proxyType = null;
                    String host = null;
                    int port = 0;
                    block207: for (int j = 0; j < proxyChildren.getLength(); ++j) {
                        Object designChildren = proxyChildren.item(j);
                        if (!(designChildren instanceof Element)) continue;
                        Element proxyElement = (Element)designChildren;
                        switch (proxyElement.getNodeName().toLowerCase()) {
                            case "type": {
                                proxyType = AtsManager.getElementText(proxyElement);
                                continue block207;
                            }
                            case "host": {
                                host = AtsManager.getElementText(proxyElement);
                                continue block207;
                            }
                            case "url": {
                                url = AtsManager.getElementText(proxyElement);
                                continue block207;
                            }
                            case "port": {
                                port = AtsManager.getElementInt(proxyElement);
                            }
                        }
                    }
                    if ("auto".equals(proxyType)) {
                        this.proxy = new AtsSystemProxy("auto");
                        continue block199;
                    }
                    if ("direct".equals(proxyType)) {
                        this.proxy = new AtsSystemProxy("direct");
                        continue block199;
                    }
                    if ("pac".equals(proxyType)) {
                        this.proxy = new AtsSystemProxy("pac", url);
                        continue block199;
                    }
                    if ("manual".equals(proxyType) && host != null && port > 0) {
                        this.proxy = new AtsSystemProxy("manual", host, port);
                        continue block199;
                    }
                    if (!"system".equals(proxyType)) continue block199;
                    this.proxy = new AtsSystemProxy("system");
                    continue block199;
                }
                case "appbounding": {
                    NodeList boundingChildren = type.getChildNodes();
                    for (int j = 0; j < boundingChildren.getLength(); ++j) {
                        Object k = boundingChildren.item(j);
                        if (k instanceof Element) {
                            Element boundingElement = (Element)k;
                            switch (boundingElement.getTagName()) {
                                case "x": {
                                    this.applicationX = AtsManager.getElementDouble(boundingElement);
                                    break;
                                }
                                case "y": {
                                    this.applicationY = AtsManager.getElementDouble(boundingElement);
                                    break;
                                }
                                case "width": {
                                    this.applicationWidth = AtsManager.getElementDouble(boundingElement);
                                    break;
                                }
                                case "height": {
                                    this.applicationHeight = AtsManager.getElementDouble(boundingElement);
                                }
                            }
                            continue;
                        }
                        String content = boundingChildren.item(j).getTextContent();
                        if (!"fullscreen".equalsIgnoreCase(content) && !"max".equalsIgnoreCase(content) && !"maxscreen".equalsIgnoreCase(content) && !"maxsize".equalsIgnoreCase(content)) continue;
                        this.applicationX = 0.0;
                        this.applicationY = 0.0;
                        this.applicationWidth = -1.0;
                        this.applicationHeight = -1.0;
                    }
                    continue block199;
                }
                case "wait": {
                    NodeList waitChildren = type.getChildNodes();
                    block209: for (int j = 0; j < waitChildren.getLength(); ++j) {
                        Object designElement = waitChildren.item(j);
                        if (!(designElement instanceof Element)) continue;
                        Element waitElement = (Element)designElement;
                        switch (waitElement.getTagName().toLowerCase()) {
                            case "entertext": {
                                this.waitEnterText = AtsManager.getElementInt(waitElement);
                                continue block209;
                            }
                            case "search": {
                                this.waitSearch = AtsManager.getElementInt(waitElement);
                                continue block209;
                            }
                            case "mousemove": {
                                this.waitMouseMove = AtsManager.getElementInt(waitElement);
                                continue block209;
                            }
                            case "switchwindow": {
                                this.waitSwitchWindow = AtsManager.getElementInt(waitElement);
                                continue block209;
                            }
                            case "gotourl": {
                                this.waitGotoUrl = AtsManager.getElementInt(waitElement);
                            }
                        }
                    }
                    continue block199;
                }
                case "maxtry": {
                    NodeList maxtryChildren = type.getChildNodes();
                    block210: for (int j = 0; j < maxtryChildren.getLength(); ++j) {
                        Object k = maxtryChildren.item(j);
                        if (!(k instanceof Element)) continue;
                        Element maxtryElement = (Element)k;
                        switch (maxtryElement.getTagName().toLowerCase()) {
                            case "searchelement": 
                            case "elementsearch": {
                                this.maxTrySearch = AtsManager.getElementInt(maxtryElement);
                                continue block210;
                            }
                            case "interactable": {
                                this.maxTryInteractable = AtsManager.getElementInt(maxtryElement);
                                continue block210;
                            }
                            case "getproperty": {
                                this.maxTryProperty = AtsManager.getElementInt(maxtryElement);
                                continue block210;
                            }
                            case "webservice": {
                                this.maxTryWebservice = AtsManager.getElementInt(maxtryElement);
                                continue block210;
                            }
                            case "searchimage": 
                            case "imagesearch": {
                                this.maxTryImageRecognition = AtsManager.getElementInt(maxtryElement);
                                continue block210;
                            }
                            case "searchscroll": 
                            case "scrollsearch": {
                                this.maxTryScrollSearch = AtsManager.getElementInt(maxtryElement);
                            }
                        }
                    }
                    continue block199;
                }
                case "timeout": {
                    NodeList timeoutChildren = type.getChildNodes();
                    block211: for (int j = 0; j < timeoutChildren.getLength(); ++j) {
                        Object object = timeoutChildren.item(j);
                        if (!(object instanceof Element)) continue;
                        Element timeoutElement = (Element)object;
                        switch (timeoutElement.getTagName().toLowerCase()) {
                            case "script": {
                                this.scriptTimeOut = AtsManager.getElementInt(timeoutElement);
                                continue block211;
                            }
                            case "pageload": {
                                this.pageloadTimeOut = AtsManager.getElementInt(timeoutElement);
                                continue block211;
                            }
                            case "watchdog": {
                                this.watchDogTimeOut = AtsManager.getElementInt(timeoutElement);
                                continue block211;
                            }
                            case "regexp": 
                            case "regex": {
                                this.regexTimeOut = AtsManager.getElementInt(timeoutElement);
                                if (this.regexTimeOut <= 5) continue block211;
                                this.regexTimeOut = 5;
                                continue block211;
                            }
                            case "webservice": {
                                this.webServiceTimeOut = AtsManager.getElementInt(timeoutElement);
                            }
                        }
                    }
                    continue block199;
                }
                case "browsers": {
                    Object extensions;
                    Object excludedOptions;
                    Object lang;
                    NodeList browsers = type.getElementsByTagName("browser");
                    for (int j = 0; j < browsers.getLength(); ++j) {
                        String name = null;
                        String waitAction = null;
                        String path = null;
                        String driver = null;
                        String dataDir = null;
                        String check = null;
                        lang = null;
                        String debugPort = null;
                        String[] options = null;
                        excludedOptions = null;
                        extensions = null;
                        String[] plugins = null;
                        String title = "";
                        Node node3 = browsers.item(j);
                        if (!(node3 instanceof Element)) continue;
                        Element browser = (Element)node3;
                        String elementName = browser.getAttribute("name");
                        if (Utils.isNotEmpty(elementName)) {
                            name = elementName;
                        }
                        NodeList browserAttributes = browser.getChildNodes();
                        block213: for (int k = 0; k < browserAttributes.getLength(); ++k) {
                            String nodeName;
                            Node node4 = browserAttributes.item(k);
                            if (!(node4 instanceof Element)) continue;
                            Element browserElement = (Element)node4;
                            switch (nodeName = browserElement.getNodeName().toLowerCase()) {
                                case "name": {
                                    name = AtsManager.getElementText(browserElement);
                                    continue block213;
                                }
                                case "waitaction": {
                                    waitAction = AtsManager.getElementText(browserElement);
                                    continue block213;
                                }
                                case "title": {
                                    title = AtsManager.getElementText(browserElement);
                                    continue block213;
                                }
                                case "driver": {
                                    driver = AtsManager.getElementText(browserElement);
                                    continue block213;
                                }
                                case "path": {
                                    path = AtsManager.getElementText(browserElement);
                                    continue block213;
                                }
                                case "userdatadir": 
                                case "userdata": 
                                case "profile": 
                                case "profiledir": {
                                    dataDir = AtsManager.getElementText(browserElement);
                                    continue block213;
                                }
                                case "waitproperty": {
                                    check = AtsManager.getElementText(browserElement);
                                    continue block213;
                                }
                                case "lang": {
                                    lang = AtsManager.getElementText(browserElement);
                                    continue block213;
                                }
                                case "debugport": {
                                    debugPort = AtsManager.getElementText(browserElement);
                                    continue block213;
                                }
                                case "excludedoptions": {
                                    NodeList excludedOptionsList = browserElement.getElementsByTagName("option");
                                    int excludedOptionsLen = excludedOptionsList.getLength();
                                    if (excludedOptionsLen <= 0) continue block213;
                                    excludedOptions = new String[excludedOptionsLen];
                                    for (int l = 0; l < excludedOptionsLen; ++l) {
                                        excludedOptions[l] = excludedOptionsList.item(l).getTextContent().replaceFirst("^--", "");
                                    }
                                    continue block213;
                                }
                                case "extensions": {
                                    NodeList extensionsList = browserElement.getElementsByTagName("extension");
                                    int extensionsLen = extensionsList.getLength();
                                    if (extensionsLen <= 0) continue block213;
                                    extensions = new String[extensionsLen];
                                    for (int l = 0; l < extensionsLen; ++l) {
                                        extensions[l] = extensionsList.item(l).getTextContent().trim();
                                    }
                                    continue block213;
                                }
                                case "plugins": {
                                    NodeList pluginsList = browserElement.getElementsByTagName("plugin");
                                    int pluginsLen = pluginsList.getLength();
                                    if (pluginsLen <= 0) continue block213;
                                    plugins = new String[pluginsLen];
                                    for (int l = 0; l < pluginsLen; ++l) {
                                        plugins[l] = pluginsList.item(l).getTextContent().trim();
                                    }
                                    continue block213;
                                }
                                case "options": {
                                    NodeList optionsList = browserElement.getElementsByTagName("option");
                                    int optionsLen = optionsList.getLength();
                                    if (optionsLen <= 0) continue block213;
                                    options = new String[optionsLen];
                                    for (int l = 0; l < optionsLen; ++l) {
                                        options[l] = optionsList.item(l).getTextContent();
                                    }
                                    continue block213;
                                }
                            }
                        }
                        if (name == null) continue;
                        this.addApplicationProperties(0, name, driver, path, waitAction, check, (String)lang, dataDir, title, options, (String[])excludedOptions, (String[])extensions, debugPort, plugins);
                    }
                    continue block199;
                }
                case "applications": {
                    Object excludedOptions;
                    Object lang;
                    NodeList applications = type.getElementsByTagName("application");
                    for (int j = 0; j < applications.getLength(); ++j) {
                        String name = null;
                        String waitAction = null;
                        Object path = null;
                        String[] options = null;
                        lang = applications.item(j);
                        if (!(lang instanceof Element)) continue;
                        Element application = (Element)lang;
                        NodeList applicationAttributes = application.getChildNodes();
                        block219: for (int k = 0; k < applicationAttributes.getLength(); ++k) {
                            excludedOptions = applicationAttributes.item(k);
                            if (!(excludedOptions instanceof Element)) continue;
                            Element applicationElement = (Element)excludedOptions;
                            switch (applicationElement.getNodeName().toLowerCase()) {
                                case "name": {
                                    name = AtsManager.getElementText(applicationElement);
                                    continue block219;
                                }
                                case "waitaction": {
                                    waitAction = AtsManager.getElementText(applicationElement);
                                    continue block219;
                                }
                                case "path": {
                                    path = AtsManager.getElementText(applicationElement);
                                    if (((String)path).startsWith("file:///")) continue block219;
                                    path = "file:///" + (String)path;
                                    continue block219;
                                }
                                case "options": {
                                    NodeList optionsList = application.getElementsByTagName("option");
                                    int optionsLen = optionsList.getLength();
                                    if (optionsLen <= 0) continue block219;
                                    options = new String[optionsLen];
                                    for (int l = 0; l < optionsLen; ++l) {
                                        options[l] = optionsList.item(l).getTextContent();
                                    }
                                    continue block219;
                                }
                            }
                        }
                        if (name == null || path == null) continue;
                        this.addApplicationProperties(1, name, (String)path, waitAction, "", null, null, null, options, null, null);
                    }
                    continue block199;
                }
                case "mobiles": {
                    Object mobileElement;
                    Node mobile;
                    Object extensions;
                    NodeList mobiles = type.getElementsByTagName("mobile");
                    for (int j = 0; j < mobiles.getLength(); ++j) {
                        String name = null;
                        String waitAction = null;
                        String endpoint = null;
                        String packageName = null;
                        Node k = mobiles.item(j);
                        if (!(k instanceof Element)) continue;
                        mobile = (Element)k;
                        NodeList mobileAttributes = mobile.getChildNodes();
                        block222: for (int k2 = 0; k2 < mobileAttributes.getLength(); ++k2) {
                            extensions = mobileAttributes.item(k2);
                            if (!(extensions instanceof Element)) continue;
                            mobileElement = (Element)extensions;
                            switch (mobileElement.getNodeName().toLowerCase()) {
                                case "name": {
                                    name = AtsManager.getElementText((Element)mobileElement);
                                    continue block222;
                                }
                                case "waitaction": {
                                    waitAction = AtsManager.getElementText((Element)mobileElement);
                                    continue block222;
                                }
                                case "endpoint": {
                                    endpoint = AtsManager.getElementText((Element)mobileElement);
                                    continue block222;
                                }
                                case "package": {
                                    packageName = AtsManager.getElementText((Element)mobileElement);
                                }
                            }
                        }
                        if (name == null || endpoint == null || packageName == null) continue;
                        this.addApplicationProperties(2, name, endpoint + "/" + packageName, waitAction, "", null, null, null, null, null, null);
                    }
                    continue block199;
                }
                case "apis": {
                    Object mobileElement;
                    Node mobile;
                    NodeList apis = type.getElementsByTagName("api");
                    for (int j = 0; j < apis.getLength(); ++j) {
                        String name = null;
                        String waitAction = null;
                        mobile = apis.item(j);
                        if (!(mobile instanceof Element)) continue;
                        Element api = (Element)mobile;
                        NodeList apiAttributes = api.getChildNodes();
                        block224: for (int k = 0; k < apiAttributes.getLength(); ++k) {
                            mobileElement = apiAttributes.item(k);
                            if (!(mobileElement instanceof Element)) continue;
                            Element apiElement = (Element)mobileElement;
                            switch (apiElement.getNodeName().toLowerCase()) {
                                case "name": {
                                    name = AtsManager.getElementText(apiElement);
                                    continue block224;
                                }
                                case "waitaction": {
                                    waitAction = AtsManager.getElementText(apiElement);
                                    continue block224;
                                }
                                case "url": {
                                    url = AtsManager.getElementText(apiElement);
                                }
                            }
                        }
                        if (name == null || url == null) continue;
                        this.addApplicationProperties(3, name, url, waitAction, "", null, null, null, null, null, null);
                    }
                    continue block199;
                }
                case "sap": {
                    NodeList sapChilds = type.getChildNodes();
                    for (int j = 0; j < sapChilds.getLength(); ++j) {
                        int k;
                        Node sapElement = sapChilds.item(j);
                        String sapElementName = sapElement.getNodeName().toLowerCase();
                        if ("timeout".equals(sapElementName)) {
                            NodeList toList = sapElement.getChildNodes();
                            for (k = 0; k < toList.getLength(); ++k) {
                                Node toElement = toList.item(k);
                                String toElementName = toElement.getNodeName().toLowerCase();
                                if (!"startdriver".equals(toElementName)) continue;
                                this.sapStartTimeOut = AtsManager.getElementInt((Element)toElement);
                            }
                            continue;
                        }
                        if (!"sessions".equals(sapElementName)) continue;
                        NodeList sessionsList = sapElement.getChildNodes();
                        for (k = 0; k < sessionsList.getLength(); ++k) {
                            String name = null;
                            String client = null;
                            String connection = null;
                            String authentication = null;
                            String lang = null;
                            Node sessionElement = sessionsList.item(k);
                            NodeList sessionProps = sessionElement.getChildNodes();
                            block228: for (int l = 0; l < sessionProps.getLength(); ++l) {
                                Node sessionProp = sessionProps.item(l);
                                switch (sessionProp.getNodeName().toLowerCase()) {
                                    case "name": {
                                        name = AtsManager.getElementText(sessionProp);
                                        continue block228;
                                    }
                                    case "client": {
                                        client = AtsManager.getElementText(sessionProp);
                                        continue block228;
                                    }
                                    case "connection": {
                                        connection = AtsManager.getElementText(sessionProp);
                                        continue block228;
                                    }
                                    case "authentication": {
                                        authentication = AtsManager.getElementText(sessionProp);
                                        continue block228;
                                    }
                                    case "lang": {
                                        lang = AtsManager.getElementText(sessionProp);
                                    }
                                }
                            }
                            if (name == null || client == null || connection == null) continue;
                            this.applicationsList.add(new ApplicationProperties(name, connection, client, authentication, lang));
                        }
                    }
                    continue block199;
                }
            }
        }
    }

    private void addApplicationProperties(int type, String name, String path, String wait, String check, String lang, String userDataDir, String title, String[] options, String[] excludedOptions, String[] extensions) {
        this.addApplicationProperties(type, name, null, path, wait, check, lang, userDataDir, title, options, excludedOptions, extensions, null, null);
    }

    private void addApplicationProperties(int type, String name, String driver, String path, String wait, String check, String lang, String userDataDir, String title, String[] options, String[] excludedOptions, String[] extensions, String debugPort, String[] plugins) {
        this.applicationsList.add(new ApplicationProperties(type, name, driver, path, Utils.string2Int(wait, -1), Utils.string2Int(check, -1), lang, userDataDir, title, options, excludedOptions, extensions, Utils.string2Int(debugPort, -1), plugins));
    }

    public String getError() {
        return this.error;
    }

    public ApplicationProperties getApplicationProperties(String name) {
        for (ApplicationProperties properties : this.applicationsList) {
            if (!name.equals(properties.getName())) continue;
            return properties;
        }
        return new ApplicationProperties(name);
    }

    public int getScriptTimeOut() {
        return this.scriptTimeOut;
    }

    public int getSapStartTimeout() {
        return this.sapStartTimeOut;
    }

    public int getPageloadTimeOut() {
        return this.pageloadTimeOut;
    }

    public int getRegexTimeOut() {
        return this.regexTimeOut;
    }

    public int getWatchDogTimeOut() {
        return this.watchDogTimeOut;
    }

    public int getWebServiceTimeOut() {
        return this.webServiceTimeOut;
    }

    public TestBound getApplicationBound() {
        return new TestBound(this.applicationX, this.applicationY, this.applicationWidth, this.applicationHeight);
    }

    public int getMaxTrySearch() {
        return this.maxTrySearch;
    }

    public int getMaxTryInteractable() {
        return this.maxTryInteractable;
    }

    public int getMaxTryImageRecognition() {
        return this.maxTryImageRecognition;
    }

    public int getMaxTryScrollSearch() {
        return this.maxTryScrollSearch;
    }

    public int getMaxTryProperty() {
        return this.maxTryProperty;
    }

    public int getMaxTryMobile() {
        return this.maxTryMobile;
    }

    public int getMaxTryWebservice() {
        return this.maxTryWebservice;
    }

    public int getWaitEnterText() {
        return this.waitEnterText;
    }

    public int getWaitSearch() {
        return this.waitSearch;
    }

    public int getWaitMouseMove() {
        return this.waitMouseMove;
    }

    public int getWaitSwitchWindow() {
        return this.waitSwitchWindow;
    }

    public int getWaitGotoUrl() {
        return this.waitGotoUrl;
    }

    public String getNeoloadDesignApi() {
        return this.neoloadDesignApi;
    }

    public AtsSystemProxy getNeoloadProxy() {
        if (this.neoloadProxy != null) {
            return this.neoloadProxy;
        }
        return this.getProxy();
    }

    public AtsSystemProxy getProxy() {
        return this.proxy;
    }

    public ArrayList<String> getBlackListServers() {
        return this.blackListServers;
    }

    public OctoperfApi getOctoperf() {
        return this.octoperf;
    }

    public int getTrafficIdle() {
        return this.trafficIdle;
    }

    public String getAtsKey() {
        String key = System.getenv(ATS_KEY_NAME);
        if (key != null && key.length() == 16) {
            return key;
        }
        if (this.atsKey != null && this.atsKey.length() == 16) {
            return this.atsKey;
        }
        return null;
    }

    public String getApplicationsList() {
        return new Gson().toJson(this.applicationsList);
    }

    public String getAtsPropertiesFilePath() {
        return this.atsPropertiesFilePath;
    }

    private static Iterable<Node> iterable(final NodeList n) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < n.getLength();
                    }

                    @Override
                    public Node next() {
                        if (this.hasNext()) {
                            return n.item(this.index++);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

