/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.transform.code;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaScriptFunctions {
    private static final Pattern isEmptyPattern = Pattern.compile("isEmpty\\((.*)\\)");
    private static final Pattern isNotEmptyPattern = Pattern.compile("isNotEmpty\\((.*)\\)");
    private static final String JS_CODE = "\nfunction isEmpty(p){\n    return p.length == 0;\n}\nfunction isNotEmpty(p){\n    return p.length > 0;\n}\n\nconsole.log(%s);\n\n";

    public static String getCode(String value) {
        String code = value.replace("\"", "'");
        if (code.endsWith(";")) {
            code = code.substring(0, code.length() - 1);
        }
        String newCode = code;
        Matcher m = isEmptyPattern.matcher(code);
        while (m.find()) {
            newCode = JavaScriptFunctions.replaceData(newCode, m.group(1));
            code = code.replace(m.group(0), "");
            m = isEmptyPattern.matcher(code);
        }
        m = isNotEmptyPattern.matcher(code);
        while (m.find()) {
            newCode = JavaScriptFunctions.replaceData(newCode, m.group(1));
            code = code.replace(m.group(0), "");
            m = isNotEmptyPattern.matcher(code);
        }
        return String.format(JS_CODE, newCode);
    }

    private static String replaceData(String code, String data) {
        if (data != null) {
            Object replace = "''";
            if (data.length() > 0) {
                replace = data;
                if (!((String)replace).startsWith("'")) {
                    replace = "'" + (String)replace;
                }
                if (!((String)replace).endsWith("'")) {
                    replace = (String)replace + "'";
                }
            }
            code = code.replace("(" + data + ")", "(" + (String)replace + ")");
        }
        return code;
    }
}

