/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.actions.ActionExecute;
import com.ats.script.actions.condition.ExecuteOptions;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Predicate;

public class ActionGotoUrl
extends ActionExecute {
    public static final String SCRIPT_LABEL = "goto-url";
    public static final String SCRIPT_LABEL_SIMPLE = "goto";
    public static final String SCRIPT_LABEL_OPEN = "open-url";
    public static final Predicate<String> PREDICATE = g -> SCRIPT_LABEL.equals(g) || SCRIPT_LABEL_SIMPLE.equals(g) || SCRIPT_LABEL_OPEN.equals(g);
    public static final String NEXT = "next";
    public static final String REFRESH = "refresh";
    public static final String BACK = "back";
    private CalculatedValue url;

    public ActionGotoUrl() {
    }

    public ActionGotoUrl(Script script, ExecuteOptions options, int stopPolicy, CalculatedValue url) {
        super(script, options, stopPolicy);
        this.setUrl(url);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(this.url.getJavaCode()).append(")");
        return codeBuilder;
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.url.getKeywords());
        return keywords;
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        super.execute(ts, testName, testLine, tryNum);
        if (this.status.isPassed()) {
            String urlString = this.url.getCalculated();
            this.getCurrentChannel().navigate(this.status, urlString);
            this.status.endAction();
            if (!this.status.isPassed()) {
                ts.failedAt(this.getClass().getSimpleName(), testName, this.line, "explorer", this.status.getCode(), this.status.getFailMessage());
            }
            ts.getRecorder().update(this.status.getCode(), this.status.endDuration(), urlString);
        }
        ts.getRecorder().updateScreen(true);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("url", this.url.getCalculated());
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public static StringBuilder getAtsCodeStr(String subFolder) {
        return new StringBuilder().append("callscript -> ").append(subFolder).append(".GoToURL");
    }

    public CalculatedValue getUrl() {
        return this.url;
    }

    public void setUrl(CalculatedValue url) {
        this.url = url;
    }
}

