/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.actions;

import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.actions.callscript.ActionCallscriptData;
import com.ats.tools.report.actions.callscript.ActionCallscriptDataJsonDeserializer;
import com.ats.tools.report.models.Action;
import com.ats.tools.report.utils.HtmlActionUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import org.apache.commons.lang3.StringUtils;

public class HtmlReportActionCallScript {
    private static final String ACTION_CALL_SCRIPT_ASASCRIPT_MESSAGE = "<div class=\"data-body-main\" style=\"border-top: 1px solid rgba(211, 211, 211, 1);\">\n    <div class=\"data-body-multiple-cell-cell asasuite-txt\">\n        \u26a0\ufe0factions following the iterations of an \"as a suite\" callscript action are not recorded \u26a0\ufe0f\n    </div>\n</div>";
    public static final String ATS_CALL_SCRIPT_HTML_TEMPLATE = "<a class=\"hover-underline\" style=\"color: rgba(104, 112, 125, 1); display: flex; align-items: center;\" href=\"ats://${scriptNameUri}\" target=\"_self\">\n    <div class=\"external-link-icon\"></div>\n    ${scriptName}\n</a>";
    private String result;

    public HtmlReportActionCallScript(String template, Action action, String projectId, boolean isAsASuite) {
        this.result = template.replace("${header1}", HtmlActionUtils.buildHtmlHeader("Called subscript", action.getError()));
        this.result = this.result.replace("${value1}", this.buildScriptUrl(action.getValue(), projectId));
        if (StringUtils.isNotBlank((CharSequence)action.getData())) {
            Gson gson = new GsonBuilder().registerTypeAdapter(ActionCallscriptData.class, (Object)new ActionCallscriptDataJsonDeserializer(projectId, action)).create();
            try {
                ActionCallscriptData actionCallscriptData = (ActionCallscriptData)gson.fromJson(action.getData(), ActionCallscriptData.class);
                this.result = this.result.replace("${header2}", actionCallscriptData.getHeader());
                this.result = this.result.replace("${value2}", actionCallscriptData.getBody());
            }
            catch (JsonSyntaxException | IllegalArgumentException e) {
                AtsLogger.printLog("cannot parse action callscript data", String.format("script %s, line %d; error msg %s", action.getScript(), action.getLine(), e.getMessage()));
            }
        }
        this.result = this.result.replace("${message}", isAsASuite ? ACTION_CALL_SCRIPT_ASASCRIPT_MESSAGE : "");
    }

    private CharSequence buildScriptUrl(String scriptName, String projectId) {
        return ATS_CALL_SCRIPT_HTML_TEMPLATE.replace("${scriptNameUri}", projectId + "/script/" + scriptName).replace("${scriptName}", scriptName);
    }

    public String getResult() {
        return this.result;
    }
}

