/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.analytics;

import java.util.Arrays;
import java.util.List;

public enum ActionType {
    NAVIGATION("ActionWindowNew", "ActionWindowResize", "ActionWindowState", "ActionWindowSwitch", "ActionGotoUrl", "ActionApi"),
    CALL_SCRIPT("ActionCallscript"),
    USER_ACTION("ActionText", "ActionMouse", "ActionMouseDragDrop", "ActionMouseKey", "ActionMouseScroll", "ActionMouseSwipe", "ActionSelect", "ActionFileTransfer"),
    ASSERT("ActionAssertCount", "ActionAssertProperty", "ActionAssertValue", "ActionProperty"),
    TECHNICAL("ActionChannelClose", "ActionChannelExist", "ActionChannelStart", "ActionChannelSwitch", "ActionScripting", "ActionButton", "ActionPropertySet", "EndOfRecording"),
    OTHERS(new String[0]);

    private final List<String> actionTypes;

    private ActionType(String ... actionTypes) {
        this.actionTypes = List.of(actionTypes);
    }

    public static ActionType of(String actionType) {
        return Arrays.stream(ActionType.values()).filter(actionTypeCategory -> actionTypeCategory.actionTypes.stream().anyMatch(actionType::endsWith)).findFirst().orElse(OTHERS);
    }
}

