/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.builders;

import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public final class ErrorTagBuilder {
    private static String buildTagInternal(Optional<ErrorTag> errorTag) {
        return errorTag.map(tag -> "<div class=\"searched-element-error\">${description} #${code}</div>".replace("${description}", tag.description()).replace("${code}", tag.code())).orElse("");
    }

    public static String buildDialogElementErrorTag(String errorCode) {
        return ErrorTagBuilder.buildTagInternal(Optional.ofNullable(DialogSearchElementActionErrorStatus.getErrorTag(errorCode)));
    }

    public static String buildSearchElementErrorTag(String errorCode) {
        return ErrorTagBuilder.buildTagInternal(Optional.ofNullable(SearchElementActionErrorStatus.getErrorTag(errorCode)));
    }

    public static String buildPropertyErrorTag(String errorCode) {
        return ErrorTagBuilder.buildTagInternal(Optional.ofNullable(ActionPropertyErrorStatus.getErrorTag(errorCode)));
    }

    public static enum DialogSearchElementActionErrorStatus {
        OBJECT_NOT_FOUND(Integer.toString(-1), "dialog_box_not_found"),
        OBJECT_NOT_VISIBLE(Integer.toString(-2), "dialog_box_not_visible"),
        OBJECT_NOT_INTERACTABLE(Integer.toString(-3), "dialog_box_not_interactable");

        private final String code;
        private final String description;

        private DialogSearchElementActionErrorStatus(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static ErrorTag getErrorTag(String code) {
            return StringUtils.isBlank((CharSequence)code) ? null : (ErrorTag)Arrays.stream(DialogSearchElementActionErrorStatus.values()).filter(errorStatus -> errorStatus.code.equals(code)).findFirst().map(dialogSearchElementActionErrorStatus -> new ErrorTag(dialogSearchElementActionErrorStatus.code, dialogSearchElementActionErrorStatus.description)).orElse(null);
        }
    }

    private record ErrorTag(String code, String description) {
    }

    public static enum SearchElementActionErrorStatus {
        OBJECT_NOT_FOUND(Integer.toString(-1), "element_not_found"),
        OBJECT_NOT_VISIBLE(Integer.toString(-2), "element_not_visible"),
        OBJECT_NOT_INTERACTABLE(Integer.toString(-3), "element_not_interactable"),
        NOT_INPUT_FILE(Integer.toString(-27), "not_input_file");

        private final String code;
        private final String description;

        private SearchElementActionErrorStatus(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static ErrorTag getErrorTag(String code) {
            return StringUtils.isBlank((CharSequence)code) ? null : (ErrorTag)Arrays.stream(SearchElementActionErrorStatus.values()).filter(errorStatus -> errorStatus.code.equals(code)).findFirst().map(dialogSearchElementActionErrorStatus -> new ErrorTag(dialogSearchElementActionErrorStatus.code, dialogSearchElementActionErrorStatus.description)).orElse(null);
        }
    }

    public static enum ActionPropertyErrorStatus {
        ATTRIBUTE_NOT_SET(Integer.toString(-5), "property_not_found"),
        ATTRIBUTE_CHECK_FAIL(Integer.toString(-6), "property_check_fail"),
        JAVASCRIPT_ERROR(Integer.toString(-13), "javascript_error"),
        JAVA_EXCEPTION(Integer.toString(-18), "java_exception"),
        FILE_NOT_FOUND(Integer.toString(-20), "file_not_found"),
        SUBSCRIPT_SYNTAX_ERROR(Integer.toString(-29), "syntax_error"),
        SUBSCRIPT_NOT_FOUND(Integer.toString(-30), "subscript_not_found");

        private final String code;
        private final String description;

        private ActionPropertyErrorStatus(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static ErrorTag getErrorTag(String code) {
            return StringUtils.isBlank((CharSequence)code) ? null : (ErrorTag)Arrays.stream(ActionPropertyErrorStatus.values()).filter(actionPropertyErrorStatus -> actionPropertyErrorStatus.code.equals(code)).findFirst().map(actionPropertyErrorStatus -> new ErrorTag(actionPropertyErrorStatus.code, actionPropertyErrorStatus.description)).orElse(null);
        }
    }
}

