/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.builders;

import com.ats.tools.logger.levels.AtsLogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SearchElementCriteriaBuilder {
    private static final String TEMPLATE = "<div style=\"display: flex; align-items: center;\">\n    <div>${tag}</div>\n    ${criteria}\n    ${index}\n</div>\n";

    private SearchElementCriteriaBuilder() {
    }

    public static String buildSearchCriteria(String tag, Optional<List<Map<String, String>>> criterias, Optional<String> index) {
        String htmlCriteria = criterias.map(crit -> CollectionUtils.emptyIfNull((Collection)crit).stream().map(map -> map.entrySet().iterator().next()).map(entry -> "[&nbsp;<span class=\"action-callscript-criteria-key\">${key}:</span> ${value}&nbsp;]".replace("${key}", (CharSequence)entry.getKey()).replace("${value}", (CharSequence)entry.getValue())).collect(Collectors.joining("&nbsp;"))).orElse("");
        String htmlIndex = index.map(i -> "&nbsp;<div class=\"index-icon\">${elementIndex}</div>".replace("${elementIndex}", (CharSequence)i)).orElse("");
        return TEMPLATE.replace("${tag}", tag).replace("${criteria}", StringUtils.isNotBlank((CharSequence)htmlCriteria) ? String.format("&nbsp;%s", htmlCriteria) : htmlCriteria).replace("${index}", htmlIndex);
    }

    public static String buildSearchCriteria(String elementTag, String criterias) {
        if (StringUtils.isBlank((CharSequence)criterias)) {
            return "";
        }
        if ("dialog".equals(elementTag)) {
            Matcher matcher = Pattern.compile("ALERT \\[(.*?)]").matcher(criterias);
            return matcher.find() ? matcher.group(1) : criterias;
        }
        String criteriaRegex = "(?i)(?<tag>.+?) \\[(?<searchCriteria>.*?)](\\[(?<index>-?\\d+)])?$";
        Pattern criteriaPattern = Pattern.compile(criteriaRegex, 2);
        Matcher matcher = criteriaPattern.matcher(criterias);
        if (matcher.matches()) {
            String tag = matcher.group("tag");
            Optional<String> index = Optional.ofNullable(matcher.group("index"));
            Optional<String> searchCriteria = Optional.ofNullable(matcher.group("searchCriteria"));
            Optional<List<Map<String, String>>> parsedSearchCriterias = searchCriteria.filter(StringUtils::isNotBlank).map(crit -> Arrays.stream(crit.split("(?<!\\\\),")).map(criteria -> {
                String[] keyValue = criteria.replace("\\,", ",").split("(?<!\\\\)=", 2);
                return Map.of(keyValue[0].trim().replace("\\=", "="), keyValue[1].trim().replace("\\=", "="));
            }).toList());
            return SearchElementCriteriaBuilder.buildSearchCriteria(tag, parsedSearchCriterias, index);
        }
        AtsLogger.printWarning("fail to parse criterias", criterias);
        return criterias;
    }
}

