/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.context.reader;

import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.Constants;
import com.ats.tools.report.adapters.NoOpReportAdapter;
import com.ats.tools.report.context.reader.AbstractReportContextExecutionReader;
import com.ats.tools.report.filters.ContentFilter;
import com.ats.tools.report.filters.ContentFilterFactory;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.Properties;
import com.ats.tools.report.models.ReportItem;
import com.ats.tools.report.models.ReportSettings;
import com.ats.tools.report.models.Results;
import com.ats.tools.report.models.Script;
import com.ats.tools.report.models.Suite;
import com.ats.tools.report.models.SuiteInfo;
import com.ats.tools.report.models.TestSummary;
import com.ats.tools.report.summary.SummaryCalculator;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ConcatenatorReportContextExecutionReader
extends AbstractReportContextExecutionReader {
    private final List<Path> concatFolders;

    public ConcatenatorReportContextExecutionReader(List<Path> concatFolders, ReportSettings reportSettings, ReportItem suiteItem) {
        super(new NoOpReportAdapter(), new SummaryCalculator(), reportSettings, suiteItem);
        this.concatFolders = concatFolders;
    }

    @Override
    protected void readFiles() throws Exception {
        this.readTestSummaries();
        this.generateScriptsFromSummaries();
        this.generateResults();
        this.generateProject();
    }

    @Override
    Properties readProjectProperties() {
        return new Properties(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    @Override
    protected ContentFilter getContentFilter() {
        return ContentFilterFactory.getConcatFilter();
    }

    private void readTestSummaries() throws Exception {
        ArrayList<TestSummary> summaries = new ArrayList<TestSummary>();
        for (Path folder : this.concatFolders) {
            String suiteName = folder.getName(folder.getNameCount() - 2).toString();
            String testName = folder.getName(folder.getNameCount() - 1).toString();
            Path realPath = this.getReportSettings().outputFolder().resolve(Paths.get(String.format("%s_xml", folder), new String[0]));
            Path testReportFolder = realPath.resolve("actions.xml");
            if (Files.exists(testReportFolder, new LinkOption[0])) {
                summaries.add(this.readTestSummary(testReportFolder, suiteName, testName));
                continue;
            }
            AtsLogger.printLog("test case not found", suiteName + ":" + testName);
        }
        this.setTestSummaries(summaries);
    }

    private void generateScriptsFromSummaries() {
        List<Script> scripts = this.getTestSummaries().stream().map(testSummary -> new Script(testSummary.getTestName(), testSummary.getSuiteName(), testSummary.getDuration(), !Constants.SummaryStatus.FAIL.getNumericValue().equals(testSummary.getStatus()), testSummary.getActions())).toList();
        this.setScripts(scripts);
    }

    private void generateProject() throws IOException {
        List<Suite> suites = this.generateSuites();
        HtmlReportProject project = new HtmlReportProject();
        project.setProjectUuid(UUID.randomUUID().toString());
        project.setProjectName("com.agilitest");
        project.setProjectVersion("0.0.1");
        project.setProjectId(String.format("%s(%s)", project.getProjectName(), project.getProjectVersion()));
        project.setProjectDescription("Project is generated using the concatenation of the provided tests results");
        project.setSuites(suites);
        project.setStarted(new Date().getTime());
        project.setProjectLogo(project.getATS_LOGO());
        this.setProject(project);
    }

    private List<Suite> generateSuites() throws IOException {
        HashMap<String, String> suiteToDescription = new HashMap<String, String>();
        if (Files.exists(this.getReportSettings().jsonSuiteFile(), new LinkOption[0]) && !Files.isDirectory(this.getReportSettings().jsonSuiteFile(), new LinkOption[0])) {
            HtmlReportProject loadedProject = (HtmlReportProject)new Gson().fromJson(Files.readString(this.getReportSettings().jsonSuiteFile()), HtmlReportProject.class);
            suiteToDescription.putAll(loadedProject.getSuites().stream().collect(Collectors.toMap(Suite::getName, Suite::getDescription)));
        }
        List<SuiteInfo> suiteInfos = this.getResults().getSuites();
        return suiteInfos.stream().map(suiteInfo -> {
            Suite suite = new Suite();
            List<String> tests = suiteInfo.getSummaries().stream().map(TestSummary::getTestName).toList();
            suite.setTests(tests);
            suite.setName(suiteInfo.getName());
            suite.setStarted(suiteInfo.getStarted());
            suite.setDescription(Objects.requireNonNullElse((String)suiteToDescription.get(suite.getName()), ""));
            suite.setDateOrder("");
            suite.setParameters(Collections.emptyMap());
            suite.setIncludedGroups(Collections.emptyList());
            suite.setExcludedGroups(Collections.emptyList());
            return suite;
        }).toList();
    }

    private void generateResults() {
        List<SuiteInfo> suiteInfos = this.generateTestSuitesInfo();
        Map<String, List<SuiteInfo>> suitesByStatus = suiteInfos.stream().collect(Collectors.groupingBy(SuiteInfo::getStatus));
        int testsCount = suiteInfos.stream().mapToInt(suiteInfo -> suiteInfo.getSummaries().size()).sum();
        long duration = suiteInfos.stream().mapToLong(SuiteInfo::getDuration).sum();
        SuiteInfo firstStarted = suiteInfos.stream().min(Comparator.comparingLong(SuiteInfo::getStarted)).get();
        Results results = new Results();
        results.setSuites(suiteInfos);
        results.setSuitesCount(suiteInfos.size());
        results.setSuitesPassed(CollectionUtils.emptyIfNull((Collection)suitesByStatus.get(Constants.Status.PASS.getValue())).size());
        results.setSuitesFailed(CollectionUtils.emptyIfNull((Collection)suitesByStatus.get(Constants.Status.FAIL.getValue())).size());
        results.setTestsCount(testsCount);
        results.setStatus(results.getSuitesFailed() > 0 ? Constants.Status.FAIL.getValue() : Constants.Status.PASS.getValue());
        results.setDuration(duration);
        results.setStarted(firstStarted.getStarted());
        this.setResults(results);
    }

    private List<SuiteInfo> generateTestSuitesInfo() {
        Map<String, List<TestSummary>> suiteToSummaries = this.getTestSummaries().stream().collect(Collectors.groupingBy(TestSummary::getSuiteName));
        Map<String, List<Script>> suiteToScripts = this.getScripts().stream().collect(Collectors.groupingBy(Script::getSuite));
        return suiteToSummaries.keySet().stream().map(suiteName -> {
            SuiteInfo suiteInfo = new SuiteInfo();
            List testSummaries = (List)suiteToSummaries.get(suiteName);
            Map<Boolean, List<TestSummary>> passedAndFailed = testSummaries.stream().collect(Collectors.groupingBy(testSummary -> !Constants.SummaryStatus.FAIL.getNumericValue().equals(testSummary.getStatus())));
            long duration = testSummaries.stream().map(testSummary -> StringUtils.isNotBlank((CharSequence)testSummary.getDuration()) ? testSummary.getDuration() : testSummary.getExecutionTime()).mapToLong(Long::parseLong).sum();
            String status = !CollectionUtils.emptyIfNull((Collection)passedAndFailed.get(Boolean.FALSE)).isEmpty() ? Constants.Status.FAIL.getValue() : Constants.Status.PASS.getValue();
            TestSummary firstStartedSummary = testSummaries.stream().min(Comparator.comparingLong(TestSummary::getStarted)).get();
            suiteInfo.setName((String)suiteName);
            suiteInfo.setTestsFailed(CollectionUtils.emptyIfNull((Collection)passedAndFailed.get(Boolean.FALSE)).size());
            suiteInfo.setTestsPassed(CollectionUtils.emptyIfNull((Collection)passedAndFailed.get(Boolean.TRUE)).size());
            suiteInfo.setDuration(duration);
            suiteInfo.setScripts((List)suiteToScripts.get(suiteName));
            suiteInfo.setSummaries(testSummaries);
            suiteInfo.setStatus(status);
            suiteInfo.setStarted(firstStartedSummary.getStarted());
            return suiteInfo;
        }).sorted(Comparator.comparingLong(SuiteInfo::getStarted)).toList();
    }
}

