/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.generators;

import com.ats.tools.ResourceContent;
import com.ats.tools.logger.ExecutionLogger;
import com.ats.tools.report.atsv.HtmlPlayerReportReader;
import com.ats.tools.report.atsv.models.ActionData;
import com.ats.tools.report.atsv.models.ReportData;
import com.ats.tools.report.atsv.processors.HtmlPlayerReportProcessor;
import com.ats.tools.report.generators.ReportGenerator;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;

public class HtmlPlayerReportGenerator
implements ReportGenerator {
    private static final String TEMPLATE_FOLDER_PATH = "/reports/playerHTML/";
    private static final String TEMPLATE_GSAP_FOLDER_PATH = "/reports/playerHTML/gsap_file/";
    private static final String HTML_TEMPLATE_PATH = "/reports/playerHTML/player_tpl.html";
    public static final String HTML_PLAYER_NAME_SUFFIX = "_atsv.html";
    private static final String GSAP_FILE_NAME = "gsap_3.11.1.min.js";
    private static final String GSAP_STP_FILE_NAME = "ScrollToPlugin_3.11.1.min.js";
    private static final String CSS_FILE_NAME = "open.css";
    private static final String JSCODE_FILE_NAME = "script.js";
    private static final byte[] LINE_BREAK_BYTES = "\n".getBytes();
    private static final String REPORT_IMAGE_TEMPLATE = "<script>\n    imgStock[${index}] = ${image};\n    imgStockLoaded = ${nextIndex};\n</script>\n";
    private static final String REPORT_DATA_TEMPLATE = "\t<script > // auto-generated section\n    const execution = ${executionData}\n    const test = ${testData}\n    const actions = ${actionsData}\n    const customsImg = ${customImageData}\n    dataLoaded = true;\n\n\t /* end of auto-integrated section */ </script>\n";
    private static final String REPORT_ICONS_TEMPLATE = "\t<script > // auto-generated section\n    const icons = ${icons}\n\n\t /* end of auto-integrated section */ </script>\n";
    private final ExecutionLogger logger;
    private final Path outputFolder;
    private final String testName;
    private final HtmlPlayerReportReader reader;
    private final Gson gson;
    private final HtmlPlayerReportProcessor processor;

    public HtmlPlayerReportGenerator(ExecutionLogger logger, Path outputFolder, String qualifiedName) {
        Validate.notBlank((CharSequence)qualifiedName);
        this.logger = logger;
        this.outputFolder = outputFolder;
        this.testName = qualifiedName;
        this.reader = new HtmlPlayerReportReader(logger);
        this.processor = HtmlPlayerReportProcessor.getDefaultProcessor();
        this.gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    }

    @Override
    public void generateReport() {
        block5: {
            Path atsvFile = this.outputFolder.resolve(this.testName + ".atsv");
            Path atsvHtmlReport = this.outputFolder.resolve(String.format("%s%s", this.testName, HTML_PLAYER_NAME_SUFFIX));
            this.logger.sendInfo("create ATSV-HTML player report", atsvHtmlReport.toAbsolutePath().toString());
            if (Files.exists(atsvFile, new LinkOption[0]) && Files.isRegularFile(atsvFile, new LinkOption[0])) {
                long startTime = System.nanoTime();
                try {
                    ReportData reportData = this.reader.readReportDate(atsvFile);
                    ReportData processedReportData = this.processor.process(reportData);
                    if (CollectionUtils.isNotEmpty(processedReportData.actionsData())) {
                        this.generatePlayerHtmlReport(atsvHtmlReport, processedReportData);
                        Duration generationDuration = Duration.ofNanos(System.nanoTime() - startTime);
                        this.logger.sendInfo(String.format("ATSV-HTML player report generated in %d second(s) %d millisecond(s)", generationDuration.toSeconds(), generationDuration.toMillisPart()), atsvHtmlReport.toAbsolutePath().toString());
                        break block5;
                    }
                    this.logger.sendInfo("no actions for ATSV-HTML player report after processing", "skipping report generation");
                }
                catch (IOException e) {
                    this.logger.sendError("ATSV report file error ->", e.getMessage());
                }
            } else {
                this.logger.sendWarning("no ATSV file generated", this.testName);
            }
        }
    }

    private void generatePlayerHtmlReport(Path atsvHtmlReportPath, ReportData reportData) throws IOException {
        try (BufferedReader reportHtmlTemplate = new BufferedReader(new InputStreamReader(Objects.requireNonNull(ResourceContent.class.getResourceAsStream(HTML_TEMPLATE_PATH))));
             OutputStream reportOutputStream = Files.newOutputStream(atsvHtmlReportPath, new OpenOption[0]);){
            String reportLine;
            while (Objects.nonNull(reportLine = reportHtmlTemplate.readLine())) {
                if (reportLine.contains("!%ATS%GSAP%ATS%!")) {
                    this.copyResourceFile(reportOutputStream, "script", "/reports/playerHTML/gsap_file/gsap_3.11.1.min.js");
                } else if (reportLine.contains("!%ATS%GSAP_STP%ATS%!")) {
                    this.copyResourceFile(reportOutputStream, "script", "/reports/playerHTML/gsap_file/ScrollToPlugin_3.11.1.min.js");
                } else if (reportLine.contains("!%ATS%CSS%ATS%!")) {
                    this.copyResourceFile(reportOutputStream, "style", "/reports/playerHTML/open.css");
                } else if (reportLine.contains("!%ATS%JSCODE%ATS%!")) {
                    this.copyResourceFile(reportOutputStream, "script", "/reports/playerHTML/script.js");
                } else if (reportLine.contains("!%ATS%JSICONS%ATS%!")) {
                    reportOutputStream.write(REPORT_ICONS_TEMPLATE.replace("${icons}", this.gson.toJson(reportData.icons())).getBytes());
                } else if (reportLine.contains("!%ATS%JSDATA%ATS%!")) {
                    reportOutputStream.write(this.getReportData(reportData).getBytes());
                } else if (reportLine.contains("!%ATS%JSIMG%ATS%!")) {
                    reportOutputStream.write(this.getImgStock(reportData.actionsData()).getBytes());
                } else {
                    reportOutputStream.write(reportLine.getBytes());
                    reportOutputStream.write(LINE_BREAK_BYTES);
                }
                reportOutputStream.flush();
            }
        }
    }

    private String getReportData(ReportData reportData) {
        Map actions = IntStream.range(0, reportData.actionsData().size()).boxed().collect(Collectors.toMap(Function.identity(), reportData.actionsData()::get));
        return REPORT_DATA_TEMPLATE.replace("${executionData}", this.gson.toJson((Object)reportData.executionData())).replace("${testData}", this.gson.toJson((Object)reportData.testData())).replace("${actionsData}", this.gson.toJson(actions)).replace("${customImageData}", this.gson.toJson(reportData.playerReportImages()));
    }

    private String getImgStock(List<ActionData> actionData) {
        int size = actionData.size();
        ArrayList<String> images = new ArrayList<String>();
        for (int index = 0; index < size; ++index) {
            images.add(REPORT_IMAGE_TEMPLATE.replace("${index}", Integer.toString(index)).replace("${nextIndex}", Integer.toString(index + 1)).replace("${image}", this.gson.toJson((Object)actionData.get(index).images())));
        }
        return String.join((CharSequence)"", images);
    }

    private void copyResourceFile(OutputStream out, String resourceType, String filePath) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Objects.requireNonNull(ResourceContent.class.getResourceAsStream(filePath)));){
            out.write(String.format("\n\t<%s> /* auto-integrated section */\n", resourceType).getBytes());
            ((InputStream)in).transferTo(out);
            out.write(String.format("\n\t/* end of auto-integrated section */ </%s>\n", resourceType).getBytes());
        }
    }
}

