/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.generators;

import com.ats.generator.ATS;
import com.ats.tools.ResourceContent;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.Constants;
import com.ats.tools.report.generators.ReportGenerator;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.ReportContextExecution;
import com.ats.tools.report.models.ReportDurationData;
import com.ats.tools.report.models.ReportSummary;
import com.ats.tools.report.models.Suite;
import com.ats.tools.report.models.SuiteInfo;
import com.ats.tools.report.models.SuiteSummary;
import com.ats.tools.report.models.TestSummary;
import com.ats.tools.report.utils.TimeUtil;
import com.google.gson.Gson;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HtmlSummaryReportGenerator
implements ReportGenerator {
    private static final String htmlSummaryTemplate = ResourceContent.getHtmlReportSummaryTemplate();
    private static final String summarySuiteTemplate = ResourceContent.getHtmlReportSummarySuiteTemplate();
    private static final String summaryTestTemplate = ResourceContent.getHtmlReportSummaryTestCaseTemplate();
    private final ReportContextExecution contextExecution;

    public HtmlSummaryReportGenerator(ReportContextExecution contextExecution) {
        this.contextExecution = contextExecution;
    }

    @Override
    public void generateReport() throws IOException {
        String htmlReportString = this.generateHtml();
        htmlReportString = this.contextExecution.contentFilter().filter(htmlReportString);
        String fileName = String.format("%s/%s", this.contextExecution.reportSettings().outputFolder().toString(), this.contextExecution.reportFileNames().summaryHtmlReport());
        try (FileWriter writer = new FileWriter(fileName);){
            writer.write(htmlReportString);
            AtsLogger.printLog("HTML summary report generated", fileName);
        }
        catch (IOException e) {
            AtsLogger.printLog("an error occurred during HTML summary report processing");
        }
    }

    private String generateHtml() {
        HtmlReportProject project = this.contextExecution.project();
        ReportSummary reportSummary = project.getReportSummary();
        ReportDurationData stepsCalculatedDuration = reportSummary.stepsCalculatedDuration();
        String result = htmlSummaryTemplate.replace("${atsTestScriptVersion}", ATS.getAtsVersion());
        result = result.replace("${projectLogo}", project.getLogo());
        result = result.replace("${projectNameFormatted}", project.getProjectId());
        result = result.replace("${suitsLaunched}", String.valueOf(project.getSuites().size()));
        result = result.replace("${createdAt}", String.valueOf(project.getStartedFormatted()));
        result = result.replace("${reportType}", Constants.ReportDetailLevel.fromLevelValue(this.contextExecution.reportSettings().devReport()).getDescription());
        result = result.replace("${executedSuitsCount}", String.valueOf(reportSummary.executedSuitesCount()));
        result = result.replaceAll(Pattern.quote("${passedSuitsCount}"), String.valueOf(reportSummary.passedSuitesCount()));
        result = result.replaceAll(Pattern.quote("${failedSuitsCount}"), String.valueOf(reportSummary.failedSuitesCount()));
        result = result.replace("${totalDuration}", TimeUtil.formatExecutionTime(reportSummary.totalDuration()));
        result = result.replace("${reportTechnicalDuration}", stepsCalculatedDuration.totalTechnicalDuration());
        result = result.replace("${totalExecutionTime}", TimeUtil.formatExecutionTime(reportSummary.executionTime()));
        result = result.replace("${reportFunctionalDuration}", stepsCalculatedDuration.totalFunctionalDuration());
        result = result.replace("${userActionsDuration}", stepsCalculatedDuration.userActionDuration());
        result = result.replace("${assertionsDuration}", stepsCalculatedDuration.assertionDuration());
        result = result.replace("${technicalDuration}", stepsCalculatedDuration.technicalDuration());
        result = result.replace("${othersDuration}", stepsCalculatedDuration.othersDuration());
        result = result.replace("${navigationDuration}", stepsCalculatedDuration.navigationDuration());
        result = result.replace("${callScriptDuration}", stepsCalculatedDuration.callScriptDuration());
        result = result.replace("${miscellaneousDuration}", stepsCalculatedDuration.miscellaneousDuration());
        result = result.replace("${executedTestsCount}", String.valueOf(reportSummary.executedTestsCount()));
        result = result.replaceAll(Pattern.quote("${passedTestCount}"), String.valueOf(reportSummary.passedTestsCount()));
        result = result.replaceAll(Pattern.quote("${failedTestCount}"), String.valueOf(reportSummary.failedTestsCount()));
        result = result.replace("${executedActionsCount}", String.valueOf(reportSummary.calculatedActionsCount()));
        result = result.replaceAll(Pattern.quote("${plm}"), project.getSuites().size() > 1 ? "s" : "");
        result = result.replaceAll(Pattern.quote("${tem}"), reportSummary.calculatedActionsCount() > 1 ? "s" : "");
        result = result.replace("${peem}", reportSummary.executedActionsCount() > 1 ? "s" : "");
        result = result.replaceAll(Pattern.quote("${suiteChartsData}"), this.getJsonChartsData());
        result = result.replace("${suites}", this.buildSuites());
        return result;
    }

    private String getJsonChartsData() {
        return new Gson().toJson(this.contextExecution.project().getSuites().stream().collect(Collectors.toMap(Suite::getName, suite -> {
            SuiteSummary suitesStatistic = suite.getSuiteSummary();
            return new int[]{suitesStatistic.passedTestsCount(), suitesStatistic.failedTestsCount(), suitesStatistic.filteredTestsCount()};
        })));
    }

    private String buildSuites() {
        return this.contextExecution.project().getSuites().stream().sorted(Comparator.comparingLong(s -> s.getSuiteInfo().getStarted())).map(this::buildSuite).collect(Collectors.joining());
    }

    private String buildSuite(Suite suite) {
        SuiteSummary suiteSummary = suite.getSuiteSummary();
        String result = summarySuiteTemplate.replace("${playlistName}", suite.getName());
        result = result.replaceAll(Pattern.quote("${suiteTestCount}"), String.valueOf(suiteSummary.totalTestsCount()));
        result = result.replace("${suiteTestsPassed}", String.valueOf(suiteSummary.passedTestsCount()));
        result = result.replace("${suiteTestsFailed}", String.valueOf(suiteSummary.failedTestsCount()));
        result = result.replace("${suiteTestsSkipped}", String.valueOf(suiteSummary.filteredTestsCount()));
        result = result.replace("${suiteActionsCount}", String.valueOf(suiteSummary.calculatedActionsCount()));
        result = result.replace("${suiteExecutionTime}", TimeUtil.formatExecutionTime(TimeUtil.roundUpToSecond(suiteSummary.executionTime())));
        result = result.replace("${resultClass}", suiteSummary.status().getSummaryReportIcon());
        result = result.replace("${idSuiteName}", suite.getName());
        result = result.replace("${tests}", this.buildTests(suite.getSuiteInfo()));
        result = result.replace("${eem}", suiteSummary.executedActionsCount() > 1 ? "s" : "");
        return result;
    }

    private String buildTests(SuiteInfo suite) {
        StringBuilder result = new StringBuilder();
        int counter = 0;
        int totalPlaylistScripts = suite.getSummaries().size();
        for (TestSummary testSummary : suite.getSummaries()) {
            boolean darkBackground = ++counter % 2 == 0;
            boolean isLast = counter == totalPlaylistScripts;
            boolean isFirst = counter == 1;
            result.append(this.buildTest(testSummary, isFirst, isLast, darkBackground));
        }
        return result.toString();
    }

    private String buildTest(TestSummary testSummary, boolean isFirst, boolean isLast, boolean darkBackground) {
        String finalTestName;
        String testPath;
        String testName = testSummary.getTestName();
        int lastDotIndex = testName.lastIndexOf(46);
        if (lastDotIndex != -1) {
            testPath = testName.substring(0, lastDotIndex);
            finalTestName = testName.substring(lastDotIndex + 1);
        } else {
            testPath = "...";
            finalTestName = testName;
        }
        String testInfo = summaryTestTemplate.replace("${actionsCount}", Integer.toString(testSummary.getCalculatedActionsCount())).replace("${testExecutionTime}", TimeUtil.formatExecutionTime(Long.parseLong(testSummary.getExecutionTime()))).replace("${resultIcon}", Constants.SummaryStatus.fromNumericValue(testSummary.getStatus()).getSummaryReportIcon()).replace("${teem}", testSummary.getCalculatedActionsCount() > 1 ? "s" : "").replace("${testPath}", testPath).replace("${testName}", finalTestName);
        if (isFirst && isLast) {
            testInfo = testInfo.replace("${border-radius}", "full-border-radius");
        }
        if (isLast) {
            testInfo = testInfo.replace("no-bottom-border", "");
            testInfo = testInfo.replace("${border-radius}", "bottom-border-radius");
        }
        if (isFirst) {
            testInfo = testInfo.replace("${tcp-border-radius}", "test-name-prefix-br");
            testInfo = testInfo.replace("${border-radius}", "top-border-radius");
        }
        if (darkBackground) {
            testInfo = testInfo.replace("${background-color}", "test-background-color");
        }
        return testInfo;
    }
}

