/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.utils;

import com.ats.tools.report.Constants;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class HtmlReportActionKeyValueTemplate {
    private static final String DATA_KEY_VALUE_MAIN_TEMPLATE = "<div style=\"display: flex; flex-direction: ${direction}; margin-right: 10px;\">\n    ${dataProperties}\n</div>";
    private static final String DATA_KEY_VALUE_INLINE_TEMPLATE = "<span class=\"inline-key-value-item\">\n    <span class=\"inline-key-value-item-header\">${dataKey}</span>\n    ${dataValue}\n</span>";
    private static final String DATA_LABEL_VALUE_INLINE_TEMPLATE = "<span class=\"inline-key-value-item\">\n    <span class=\"inline-label-value-item-header\">${dataKey}</span>\n    ${dataValue}\n</span>";

    public static String buildKeyValueString(Map<String, String> keyValues, boolean isColumnDirection) {
        return HtmlReportActionKeyValueTemplate.buildString(DATA_KEY_VALUE_INLINE_TEMPLATE, keyValues, isColumnDirection);
    }

    public static String buildLabelValueString(Map<String, String> keyValues, boolean isColumnDirection) {
        return HtmlReportActionKeyValueTemplate.buildString(DATA_LABEL_VALUE_INLINE_TEMPLATE, keyValues, isColumnDirection);
    }

    private static String buildString(String template, Map<String, String> keyValues, boolean isColumnDirection) {
        String items = keyValues.entrySet().stream().map(entry -> HtmlReportActionKeyValueTemplate.processString(template, entry)).collect(Collectors.joining());
        return DATA_KEY_VALUE_MAIN_TEMPLATE.replace("${dataProperties}", items).replace("${direction}", isColumnDirection ? "column" : "row");
    }

    private static String processString(String template, Map.Entry<String, String> values) {
        return template.replace("${dataKey}", values.getKey() + ":").replace("${dataValue}", StringUtils.isNotBlank((CharSequence)values.getValue()) ? (CharSequence)Constants.CONDITIONALLY_REPLACE_TO_EMPTY_REPRESENTATION.apply(values.getValue()) : "");
    }
}

