/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import java.util.Objects;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public final class CopySource {
    public static final String DELIMITER = "/";
    private final String bucket;
    private final String key;

    public CopySource(String copySource) {
        Objects.requireNonNull(copySource, "copySource == null");
        String[] bucketAndKey = CopySource.extractBucketAndKeyArray(SdkHttpUtils.urlDecode((String)copySource));
        this.bucket = bucketAndKey[0];
        this.key = bucketAndKey[1];
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    private static String[] extractBucketAndKeyArray(String copySource) {
        String source = CopySource.normalizeCopySource(copySource);
        String[] bucketAndKey = source.split(DELIMITER, 2);
        if (bucketAndKey.length != 2) {
            throw new IllegalArgumentException("Expected a copySource as '/{bucket}/{key}' but got: " + copySource);
        }
        return bucketAndKey;
    }

    private static String normalizeCopySource(String copySource) {
        if (copySource.startsWith(DELIMITER)) {
            return copySource.substring(1);
        }
        return copySource;
    }
}

