/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.s3mock.dto.Prefix;
import com.adobe.testing.s3mock.dto.S3Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@JsonRootName(value="ListBucketResult")
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ListBucketResultV2 {
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Prefix")
    private String prefix;
    @JsonProperty(value="MaxKeys")
    private int maxKeys;
    @JsonProperty(value="IsTruncated")
    private boolean isTruncated;
    @JsonProperty(value="Contents")
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<S3Object> contents;
    @JsonProperty(value="CommonPrefixes")
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<Prefix> commonPrefixes;
    @JsonProperty(value="ContinuationToken")
    private String continuationToken;
    @JsonProperty(value="KeyCount")
    private String keyCount;
    @JsonProperty(value="NextContinuationToken")
    private String nextContinuationToken;
    @JsonProperty(value="StartAfter")
    private String startAfter;
    @JsonProperty(value="EncodingType")
    private String encodingType;

    public ListBucketResultV2(String name, String prefix, int maxKeys, boolean isTruncated, List<S3Object> contents, Collection<String> commonPrefixes, String continuationToken, String keyCount, String nextContinuationToken, String startAfter, String encodingType) {
        this.name = name;
        this.prefix = prefix;
        this.maxKeys = maxKeys;
        this.isTruncated = isTruncated;
        this.contents = new ArrayList<S3Object>();
        this.contents.addAll(contents);
        this.commonPrefixes = commonPrefixes.stream().map(Prefix::new).collect(Collectors.toList());
        this.continuationToken = continuationToken;
        this.keyCount = keyCount;
        this.nextContinuationToken = nextContinuationToken;
        this.startAfter = startAfter;
        this.encodingType = encodingType;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getMaxKeys() {
        return this.maxKeys;
    }

    @JsonIgnore
    public boolean isTruncated() {
        return this.isTruncated;
    }

    public List<S3Object> getContents() {
        return this.contents;
    }

    public List<Prefix> getCommonPrefixes() {
        return this.commonPrefixes;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public String getKeyCount() {
        return this.keyCount;
    }

    public String getNextContinuationToken() {
        return this.nextContinuationToken;
    }

    public String getStartAfter() {
        return this.startAfter;
    }

    public String getEncodingType() {
        return this.encodingType;
    }
}

