/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.BucketStore;
import com.adobe.testing.s3mock.store.KmsKeyStore;
import com.adobe.testing.s3mock.store.MultipartStore;
import com.adobe.testing.s3mock.store.ObjectStore;
import com.adobe.testing.s3mock.store.StoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={StoreProperties.class})
public class StoreConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(StoreConfiguration.class);
    static final DateTimeFormatter S3_OBJECT_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.of("UTC"));

    @Bean
    ObjectStore objectStore(StoreProperties properties, List<String> bucketNames, BucketStore bucketStore, ObjectMapper objectMapper) {
        ObjectStore objectStore = new ObjectStore(properties.isRetainFilesOnExit(), S3_OBJECT_DATE_FORMAT, objectMapper);
        for (String bucketName : bucketNames) {
            BucketMetadata bucketMetadata = bucketStore.getBucketMetadata(bucketName);
            if (bucketMetadata == null) continue;
            objectStore.loadObjects(bucketMetadata, bucketMetadata.getObjects().values());
        }
        return objectStore;
    }

    @Bean
    BucketStore bucketStore(StoreProperties properties, File rootFolder, List<String> bucketNames, ObjectMapper objectMapper) {
        BucketStore bucketStore = new BucketStore(rootFolder, properties.isRetainFilesOnExit(), S3_OBJECT_DATE_FORMAT, objectMapper);
        if (bucketNames.isEmpty()) {
            properties.getInitialBuckets().forEach(bucketName -> {
                bucketStore.createBucket((String)bucketName, false);
                LOG.info("Creating initial bucket {}.", bucketName);
            });
        } else {
            bucketStore.loadBuckets(bucketNames);
        }
        return bucketStore;
    }

    @Bean
    List<String> bucketNames(File rootFolder) {
        File[] buckets = rootFolder.listFiles((dir, name) -> !Objects.equals(name, "test"));
        if (buckets != null) {
            return Arrays.stream(buckets).map(File::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Bean
    MultipartStore multipartStore(StoreProperties properties, ObjectStore objectStore) {
        return new MultipartStore(properties.isRetainFilesOnExit(), objectStore);
    }

    @Bean
    KmsKeyStore kmsKeyStore(StoreProperties properties) {
        return new KmsKeyStore(properties.getValidKmsKeys());
    }

    @Bean
    File rootFolder(StoreProperties properties) {
        File root;
        boolean createTempDir;
        boolean bl = createTempDir = properties.getRoot() == null || properties.getRoot().isEmpty();
        if (createTempDir) {
            Path baseTempDir = FileUtils.getTempDirectory().toPath();
            try {
                root = Files.createTempDirectory(baseTempDir, "s3mockFileStore", new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Root folder could not be created. Base temp dir: " + baseTempDir, e);
            }
            LOG.info("Successfully created \"{}\" as root folder. Will retain files on exit: {}", (Object)root.getAbsolutePath(), (Object)properties.isRetainFilesOnExit());
        } else {
            root = new File(properties.getRoot());
            if (root.exists()) {
                LOG.info("Using existing folder \"{}\" as root folder. Will retain files on exit: {}", (Object)root.getAbsolutePath(), (Object)properties.isRetainFilesOnExit());
            } else {
                if (!root.mkdir()) {
                    throw new IllegalStateException("Root folder could not be created. Path: " + root.getAbsolutePath());
                }
                LOG.info("Successfully created \"{}\" as root folder. Will retain files on exit: {}", (Object)root.getAbsolutePath(), (Object)properties.isRetainFilesOnExit());
            }
        }
        if (!properties.isRetainFilesOnExit()) {
            root.deleteOnExit();
        }
        return root;
    }
}

