/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr;

import com.aetrion.flickr.REST;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.activity.ActivityInterface;
import com.aetrion.flickr.auth.AuthInterface;
import com.aetrion.flickr.blogs.BlogsInterface;
import com.aetrion.flickr.contacts.ContactsInterface;
import com.aetrion.flickr.favorites.FavoritesInterface;
import com.aetrion.flickr.groups.GroupsInterface;
import com.aetrion.flickr.groups.pools.PoolsInterface;
import com.aetrion.flickr.interestingness.InterestingnessInterface;
import com.aetrion.flickr.people.PeopleInterface;
import com.aetrion.flickr.photos.PhotosInterface;
import com.aetrion.flickr.photos.licenses.LicensesInterface;
import com.aetrion.flickr.photos.notes.NotesInterface;
import com.aetrion.flickr.photos.transform.TransformInterface;
import com.aetrion.flickr.photosets.PhotosetsInterface;
import com.aetrion.flickr.prefs.PrefsInterface;
import com.aetrion.flickr.reflection.ReflectionInterface;
import com.aetrion.flickr.tags.TagsInterface;
import com.aetrion.flickr.test.TestInterface;
import com.aetrion.flickr.urls.UrlsInterface;
import javax.xml.parsers.ParserConfigurationException;

public class Flickr {
    public static final String DEFAULT_HOST = "www.flickr.com";
    public static boolean debugStream = false;
    public static boolean debugRequest = false;
    public static boolean tracing = false;
    private String apiKey;
    private Transport transport;
    private AuthInterface authInterface;
    private ActivityInterface activityInterface;
    private BlogsInterface blogsInterface;
    private ContactsInterface contactsInterface;
    private FavoritesInterface favoritesInterface;
    private GroupsInterface groupsInterface;
    private LicensesInterface licensesInterface;
    private NotesInterface notesInterface;
    private PoolsInterface poolsInterface;
    private PeopleInterface peopleInterface;
    private PhotosInterface photosInterface;
    private PhotosetsInterface photosetsInterface;
    private PrefsInterface prefsInterface;
    private ReflectionInterface reflectionInterface;
    private TagsInterface tagsInterface;
    private TestInterface testInterface;
    private TransformInterface transformInterface;
    private UrlsInterface urlsInterface;
    private InterestingnessInterface interestingnessInterface;
    public static final String CONTENTTYPE_PHOTO = "1";
    public static final String CONTENTTYPE_SCREENSHOT = "2";
    public static final String CONTENTTYPE_OTHER = "3";
    public static final int ACCURACY_WORLD = 1;
    public static final int ACCURACY_COUNTRY = 3;
    public static final int ACCURACY_REGION = 6;
    public static final int ACCURACY_CITY = 11;
    public static final int ACCURACY_STREET = 16;
    public static final String SAFETYLEVEL_SAFE = "1";
    public static final String SAFETYLEVEL_MODERATE = "2";
    public static final String SAFETYLEVEL_RESTRICTED = "3";
    public static final int PRIVACY_LEVEL_NO_FILTER = 0;
    public static final int PRIVACY_LEVEL_PUBLIC = 1;
    public static final int PRIVACY_LEVEL_FRIENDS = 2;
    public static final int PRIVACY_LEVEL_FAMILY = 3;
    public static final int PRIVACY_LEVEL_FRIENDS_FAMILY = 4;
    public static final int PRIVACY_LEVEL_PRIVATE = 5;

    public Flickr(String apiKey) {
        this.setApiKey(apiKey);
        try {
            this.setTransport(new REST(DEFAULT_HOST));
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Flickr(String apiKey, Transport transport) {
        this.setApiKey(apiKey);
        this.setTransport(transport);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        if (apiKey == null) {
            throw new IllegalArgumentException("API key must not be null");
        }
        this.apiKey = apiKey;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        if (transport == null) {
            throw new IllegalArgumentException("Transport must not be null");
        }
        this.transport = transport;
    }

    public AuthInterface getAuthInterface() {
        if (this.authInterface == null) {
            this.authInterface = new AuthInterface(this.apiKey, this.transport);
        }
        return this.authInterface;
    }

    public ActivityInterface getActivityInterface() {
        if (this.activityInterface == null) {
            this.activityInterface = new ActivityInterface(this.apiKey, this.transport);
        }
        return this.activityInterface;
    }

    public synchronized BlogsInterface getBlogsInterface() {
        if (this.blogsInterface == null) {
            this.blogsInterface = new BlogsInterface(this.apiKey, this.transport);
        }
        return this.blogsInterface;
    }

    public ContactsInterface getContactsInterface() {
        if (this.contactsInterface == null) {
            this.contactsInterface = new ContactsInterface(this.apiKey, this.transport);
        }
        return this.contactsInterface;
    }

    public FavoritesInterface getFavoritesInterface() {
        if (this.favoritesInterface == null) {
            this.favoritesInterface = new FavoritesInterface(this.apiKey, this.transport);
        }
        return this.favoritesInterface;
    }

    public GroupsInterface getGroupsInterface() {
        if (this.groupsInterface == null) {
            this.groupsInterface = new GroupsInterface(this.apiKey, this.transport);
        }
        return this.groupsInterface;
    }

    public LicensesInterface getLicensesInterface() {
        if (this.licensesInterface == null) {
            this.licensesInterface = new LicensesInterface(this.apiKey, this.transport);
        }
        return this.licensesInterface;
    }

    public NotesInterface getNotesInterface() {
        if (this.notesInterface == null) {
            this.notesInterface = new NotesInterface(this.apiKey, this.transport);
        }
        return this.notesInterface;
    }

    public PoolsInterface getPoolsInterface() {
        if (this.poolsInterface == null) {
            this.poolsInterface = new PoolsInterface(this.apiKey, this.transport);
        }
        return this.poolsInterface;
    }

    public PeopleInterface getPeopleInterface() {
        if (this.peopleInterface == null) {
            this.peopleInterface = new PeopleInterface(this.apiKey, this.transport);
        }
        return this.peopleInterface;
    }

    public PhotosInterface getPhotosInterface() {
        if (this.photosInterface == null) {
            this.photosInterface = new PhotosInterface(this.apiKey, this.transport);
        }
        return this.photosInterface;
    }

    public PhotosetsInterface getPhotosetsInterface() {
        if (this.photosetsInterface == null) {
            this.photosetsInterface = new PhotosetsInterface(this.apiKey, this.transport);
        }
        return this.photosetsInterface;
    }

    public PrefsInterface getPrefsInterface() {
        if (this.prefsInterface == null) {
            this.prefsInterface = new PrefsInterface(this.apiKey, this.transport);
        }
        return this.prefsInterface;
    }

    public ReflectionInterface getReflectionInterface() {
        if (this.reflectionInterface == null) {
            this.reflectionInterface = new ReflectionInterface(this.apiKey, this.transport);
        }
        return this.reflectionInterface;
    }

    public TagsInterface getTagsInterface() {
        if (this.tagsInterface == null) {
            this.tagsInterface = new TagsInterface(this.apiKey, this.transport);
        }
        return this.tagsInterface;
    }

    public TestInterface getTestInterface() {
        if (this.testInterface == null) {
            this.testInterface = new TestInterface(this.apiKey, this.transport);
        }
        return this.testInterface;
    }

    public TransformInterface getTransformInterface() {
        if (this.transformInterface == null) {
            this.transformInterface = new TransformInterface(this.apiKey, this.transport);
        }
        return this.transformInterface;
    }

    public UrlsInterface getUrlsInterface() {
        if (this.urlsInterface == null) {
            this.urlsInterface = new UrlsInterface(this.apiKey, this.transport);
        }
        return this.urlsInterface;
    }

    public synchronized InterestingnessInterface getInterestingnessInterface() {
        if (this.interestingnessInterface == null) {
            this.interestingnessInterface = new InterestingnessInterface(this.apiKey, this.transport);
        }
        return this.interestingnessInterface;
    }
}

