/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.groups;

import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.Response;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.groups.Category;
import com.aetrion.flickr.groups.Group;
import com.aetrion.flickr.groups.GroupList;
import com.aetrion.flickr.groups.Subcategory;
import com.aetrion.flickr.groups.Throttle;
import com.aetrion.flickr.util.XMLUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GroupsInterface {
    public static final String METHOD_BROWSE = "flickr.groups.browse";
    public static final String METHOD_GET_ACTIVE_LIST = "flickr.groups.getActiveList";
    public static final String METHOD_GET_INFO = "flickr.groups.getInfo";
    public static final String METHOD_SEARCH = "flickr.groups.search";
    private String apiKey;
    private Transport transportAPI;

    public GroupsInterface(String apiKey, Transport transportAPI) {
        this.apiKey = apiKey;
        this.transportAPI = transportAPI;
    }

    public Category browse(String catId) throws IOException, SAXException, FlickrException {
        Response response;
        ArrayList<Subcategory> subcategories = new ArrayList<Subcategory>();
        ArrayList<Group> groups = new ArrayList<Group>();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("method", METHOD_BROWSE));
        parameters.add(new Parameter("api_key", this.apiKey));
        if (catId != null) {
            parameters.add(new Parameter("cat_id", catId));
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element categoryElement = response.getPayload();
        Category category = new Category();
        category.setName(categoryElement.getAttribute("name"));
        category.setPath(categoryElement.getAttribute("path"));
        category.setPathIds(categoryElement.getAttribute("pathids"));
        NodeList subcatNodes = categoryElement.getElementsByTagName("subcat");
        for (int i = 0; i < subcatNodes.getLength(); ++i) {
            Element node = (Element)subcatNodes.item(i);
            Subcategory subcategory = new Subcategory();
            subcategory.setId(Integer.parseInt(node.getAttribute("id")));
            subcategory.setName(node.getAttribute("name"));
            subcategory.setCount(Integer.parseInt(node.getAttribute("count")));
            subcategories.add(subcategory);
        }
        NodeList groupNodes = categoryElement.getElementsByTagName("group");
        for (int i = 0; i < groupNodes.getLength(); ++i) {
            Element node = (Element)groupNodes.item(i);
            Group group = new Group();
            group.setId(node.getAttribute("nsid"));
            group.setName(node.getAttribute("name"));
            group.setMembers(node.getAttribute("members"));
            group.setOnline(node.getAttribute("online"));
            group.setChatId(node.getAttribute("chatnsid"));
            group.setInChat(node.getAttribute("inchat"));
            groups.add(group);
        }
        category.setGroups(groups);
        category.setSubcategories(subcategories);
        return category;
    }

    public Group getInfo(String groupId) throws IOException, SAXException, FlickrException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("method", METHOD_GET_INFO));
        parameters.add(new Parameter("api_key", this.apiKey));
        parameters.add(new Parameter("group_id", groupId));
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element groupElement = response.getPayload();
        Group group = new Group();
        group.setId(groupElement.getAttribute("id"));
        group.setIconServer(groupElement.getAttribute("iconserver"));
        group.setName(XMLUtilities.getChildValue(groupElement, "name"));
        group.setDescription(XMLUtilities.getChildValue(groupElement, "description"));
        group.setMembers(XMLUtilities.getChildValue(groupElement, "members"));
        group.setPrivacy(XMLUtilities.getChildValue(groupElement, "privacy"));
        NodeList throttleNodes = groupElement.getElementsByTagName("throttle");
        int n = throttleNodes.getLength();
        if (n == 1) {
            Element throttleElement = (Element)throttleNodes.item(0);
            Throttle throttle = new Throttle();
            group.setThrottle(throttle);
            throttle.setMode(throttleElement.getAttribute("mode"));
            String countStr = throttleElement.getAttribute("count");
            String remainingStr = throttleElement.getAttribute("remaining");
            if (countStr != null && countStr.length() > 0) {
                throttle.setCount(Integer.parseInt(countStr));
            }
            if (remainingStr != null && remainingStr.length() > 0) {
                throttle.setRemaining(Integer.parseInt(remainingStr));
            }
        } else if (n > 1) {
            System.err.println("WARNING: more than one throttle element in group");
        }
        group.setOnline(XMLUtilities.getChildValue(groupElement, "online"));
        group.setChatId(XMLUtilities.getChildValue(groupElement, "chatid"));
        group.setInChat(XMLUtilities.getChildValue(groupElement, "chatcount"));
        return group;
    }

    public Collection search(String text, int perPage, int page) throws FlickrException, IOException, SAXException {
        Response response;
        GroupList groupList = new GroupList();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("method", METHOD_SEARCH));
        parameters.add(new Parameter("api_key", this.apiKey));
        parameters.add(new Parameter("text", text));
        if (perPage > 0) {
            parameters.add(new Parameter("per_page", new Integer(perPage)));
        }
        if (page > 0) {
            parameters.add(new Parameter("page", new Integer(page)));
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element groupsElement = response.getPayload();
        NodeList groupNodes = groupsElement.getElementsByTagName("group");
        groupList.setPage(XMLUtilities.getIntAttribute(groupsElement, "page"));
        groupList.setPages(XMLUtilities.getIntAttribute(groupsElement, "pages"));
        groupList.setPerPage(XMLUtilities.getIntAttribute(groupsElement, "perpage"));
        groupList.setTotal(XMLUtilities.getIntAttribute(groupsElement, "total"));
        for (int i = 0; i < groupNodes.getLength(); ++i) {
            Element groupElement = (Element)groupNodes.item(i);
            Group group = new Group();
            group.setId(groupElement.getAttribute("nsid"));
            group.setName(groupElement.getAttribute("name"));
            group.setEighteenPlus(XMLUtilities.getBooleanAttribute(groupElement, "eighteenplus"));
            groupList.add(group);
        }
        return groupList;
    }
}

