/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.photos.transform;

import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.Response;
import com.aetrion.flickr.Transport;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.SAXException;

public class TransformInterface {
    public static final String METHOD_ROTATE = "flickr.photos.transform.rotate";
    private String apiKey;
    private Transport transportAPI;

    public TransformInterface(String apiKey, Transport transport) {
        this.apiKey = apiKey;
        this.transportAPI = transport;
    }

    public void rotate(String photoId, int degrees) throws IOException, SAXException, FlickrException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("method", METHOD_ROTATE));
        parameters.add(new Parameter("api_key", this.apiKey));
        parameters.add(new Parameter("photo_id", photoId));
        parameters.add(new Parameter("degrees", String.valueOf(degrees)));
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }
}

