/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.maven.docbkx;

import com.agilejava.maven.docbkx.spec.Parameter;
import com.agilejava.maven.docbkx.spec.Specification;
import com.icl.saxon.TransformerFactoryImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GeneratorMojo
extends AbstractMojo {
    private static String TRANSFORMER_LOCATION = "extract-params.xsl";
    private String className;
    private String packageName;
    private String superClassName;
    private String pluginSuffix;
    private File targetDirectory;
    private MavenProjectHelper projectHelper;
    private File targetResourcesDirectory;
    private MavenProject project;
    private String type;
    private String targetFileExtension;
    private boolean useStandardOutput = true;
    protected DOMXPath selectDescription;
    private DOMXPath selectType;
    private String stylesheetTargetRoot;
    private String stylesheetTargetLocation;
    private String stylesheetPath;
    private String groupId;
    private String version;
    private File distribution;
    private String sourceRootDirectory = "docbook/";
    protected String excludedProperties;

    public GeneratorMojo() {
        try {
            this.selectDescription = new DOMXPath("//refsection[position()=1]/para[position()=1]/text()");
            this.selectType = new DOMXPath("//refmiscinfo[@class='other' and @otherclass='datatype']/text()");
        }
        catch (JaxenException e) {
            throw new IllegalStateException("Failed to parse XPath expression.");
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.completeConfiguration();
        this.generateSourceCode();
    }

    private void completeConfiguration() throws MojoExecutionException {
        if (this.distribution == null) {
            boolean found = false;
            Set artifacts = this.project.getDependencyArtifacts();
            if (artifacts != null) {
                Iterator i = artifacts.iterator();
                while (i.hasNext()) {
                    Artifact artifact = (Artifact)i.next();
                    if (!"net.sf.docbook".equals(artifact.getGroupId()) || !"docbook-xsl".equals(artifact.getArtifactId())) continue;
                    this.distribution = artifact.getFile();
                    this.version = artifact.getVersion();
                    found = true;
                    this.getLog().debug((CharSequence)("Docbook artifact used for generation: " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getClassifier()));
                    break;
                }
            }
            if (!found) {
                throw new MojoExecutionException("Unable to find a valid docbook depencency artifact");
            }
        }
        if (this.stylesheetPath == null) {
            this.stylesheetPath = this.type + "/docbook.xsl";
        }
        if (this.stylesheetTargetLocation == null) {
            this.stylesheetTargetLocation = this.stylesheetTargetRoot + "/" + this.stylesheetPath;
        }
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return factory.newDocumentBuilder();
    }

    private void generateSourceCode() throws MojoExecutionException {
        File sourcesDir = new File(this.targetDirectory, this.getPackageName().replace('.', '/'));
        try {
            FileUtils.forceMkdir((File)sourcesDir);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Can't create directory for sources.", (Exception)ioe);
        }
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream in = loader.getResourceAsStream("plugins.stg");
        InputStreamReader reader = new InputStreamReader(in);
        StringTemplateGroup group = new StringTemplateGroup((Reader)reader);
        StringTemplate template = group.getInstanceOf("plugin");
        File targetFile = new File(sourcesDir, this.getClassName() + ".java");
        Specification specification = null;
        try {
            specification = this.createSpecification();
            this.getLog().info((CharSequence)("Number of parameters: " + specification.getParameters().size()));
            template.setAttribute("spec", (Object)specification);
            FileUtils.writeStringToFile((File)targetFile, (String)template.toString(), null);
        }
        catch (IOException ioe) {
            if (specification == null) {
                throw new MojoExecutionException("Failed to read parameters.", (Exception)ioe);
            }
            throw new MojoExecutionException("Failed to create " + targetFile + ".", (Exception)ioe);
        }
        this.project.addCompileSourceRoot(this.targetDirectory.getAbsolutePath());
    }

    private Specification createSpecification() throws MojoExecutionException {
        String stylesheetLocation = this.stylesheetTargetLocation == null ? this.stylesheetTargetRoot + "/" + this.type + "/docbook.xsl" : this.stylesheetTargetLocation;
        Specification specification = new Specification();
        specification.setType(this.type);
        specification.setStylesheetLocation(stylesheetLocation);
        specification.setClassName(this.getClassName());
        specification.setSuperClassName(this.superClassName);
        specification.setPackageName(this.getPackageName());
        specification.setDocbookXslVersion(this.version);
        specification.setPluginSuffix(this.pluginSuffix);
        specification.setParameters(this.extractParameters());
        specification.setUseStandardOutput(this.useStandardOutput);
        specification.setTargetFileExtension(this.targetFileExtension);
        return specification;
    }

    private List extractParameters() throws MojoExecutionException {
        String stylesheetURL = this.createURL(this.stylesheetPath);
        Collection parameterNames = this.getParameterNames(stylesheetURL);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Iterator iterator = parameterNames.iterator();
        List excluded = this.getExcludedProperties();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (excluded.contains(name)) continue;
            parameters.add(this.extractParameter(name));
        }
        return parameters;
    }

    private List getExcludedProperties() {
        List<String> excluded = this.excludedProperties != null ? Arrays.asList(this.excludedProperties.split(",[ ]*")) : Collections.EMPTY_LIST;
        return excluded;
    }

    private Parameter extractParameter(String name) throws MojoExecutionException {
        String url = this.createURL("params/" + name + ".xml");
        Parameter parameter = new Parameter();
        parameter.setName(name);
        try {
            DocumentBuilder builder = this.createDocumentBuilder();
            Document document = builder.parse(url);
            Node node = (Node)this.selectDescription.selectSingleNode((Object)document);
            if (node == null) {
                this.getLog().warn((CharSequence)("Failed to parse description for " + name));
                return parameter;
            }
            String result = node.getNodeValue();
            result = result.substring(0, result.indexOf(46) + 1);
            result = result.trim();
            result = result.replace('\n', ' ');
            parameter.setDescription(result);
            node = (Node)this.selectType.selectSingleNode((Object)document);
            if (node != null) {
                parameter.setTypeFromRefType(node.getNodeValue());
            } else {
                this.getLog().warn((CharSequence)("Missing type info for " + name));
            }
        }
        catch (FileNotFoundException fnfe) {
            this.logMissingDescription(name, fnfe);
        }
        catch (IOException ioe) {
            this.logMissingDescription(name, ioe);
        }
        catch (ParserConfigurationException pce) {
            this.logMissingDescription(name, pce);
        }
        catch (SAXException se) {
            this.logMissingDescription(name, se);
        }
        catch (JaxenException je) {
            this.logMissingDescription(name, je);
        }
        return parameter;
    }

    private void logMissingDescription(String name, Throwable cause) {
        this.getLog().warn((CharSequence)("Failed to obtain description for " + name));
        this.getLog().debug(cause);
    }

    private String createURL(String filename) throws MojoExecutionException {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("jar:");
            builder.append(this.distribution.toURL().toExternalForm());
            builder.append("!/");
            builder.append(this.sourceRootDirectory);
            builder.append(filename);
            return builder.toString();
        }
        catch (MalformedURLException mue) {
            throw new MojoExecutionException("Failed to construct URL for " + filename + ".", (Exception)mue);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection getParameterNames(String url) throws MojoExecutionException {
        ByteArrayOutputStream out = null;
        try {
            Transformer transformer = this.createParamListTransformer();
            StreamSource source = new StreamSource(url);
            out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            out.flush();
            String[] paramNames = new String(out.toByteArray()).split("\n");
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(paramNames));
            IOUtils.closeQuietly((OutputStream)out);
            return hashSet;
        }
        catch (IOException ioe) {
            this.getLog().warn((CharSequence)"Failed to flush ByteArrayOutputStream.");
            return Collections.EMPTY_SET;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (TransformerConfigurationException tce) {
                throw new MojoExecutionException("Failed to create Transformer for retrieving parameter names", (Exception)tce);
                catch (TransformerException te) {
                    throw new MojoExecutionException("Failed to apply Transformer for retrieving parameter names.", (Exception)te);
                }
            }
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    private Transformer createParamListTransformer() throws TransformerConfigurationException {
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        URL stylesheet = Thread.currentThread().getContextClassLoader().getResource(TRANSFORMER_LOCATION);
        StreamSource source = new StreamSource(stylesheet.toExternalForm());
        return factory.newTransformer(source);
    }

    private String getPackageName() {
        return this.packageName != null ? this.packageName : this.groupId;
    }

    private String getClassName() {
        if (this.className == null) {
            StringBuffer builder = new StringBuffer();
            builder.append("Docbkx");
            builder.append(Character.toUpperCase(this.type.charAt(0)));
            builder.append(this.type.substring(1));
            builder.append("Mojo");
            return builder.toString();
        }
        return this.className;
    }
}

