/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.maven;

import com.agilejava.docbkx.maven.AbstractMojoBase;
import java.io.File;
import javax.xml.transform.Transformer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class AbstractHtmlMojo
extends AbstractMojoBase {
    private boolean chunkedOutput;

    protected String getNonDefaultStylesheetLocation() {
        if (this.chunkedOutput) {
            return "docbook/" + this.getType() + "/chunk.xsl";
        }
        return null;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setUseStandardOutput(!this.chunkedOutput);
        super.execute();
    }

    public void adjustTransformer(Transformer transformer, String sourceFilename, File targetFile) {
        super.adjustTransformer(transformer, sourceFilename, targetFile);
        transformer.setParameter("base.dir", targetFile.getParent() + File.separator);
        if (this.chunkedOutput) {
            this.getLog().info((CharSequence)"Chunking output.");
            String rootFilename = targetFile.getName();
            rootFilename = rootFilename.substring(0, rootFilename.lastIndexOf(46));
            transformer.setParameter("root.filename", rootFilename);
        }
    }
}

