/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.support.csv.CSVParser;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;

class CSVParserUTF16
extends CSVParser {
    char[] buf;
    Reader input;

    CSVParserUTF16(CSVParser.Feature ... features) {
        for (CSVParser.Feature feature : features) {
            this.features |= feature.mask;
        }
    }

    CSVParserUTF16(Reader input, Type[] types) {
        super(types);
        this.input = input;
    }

    CSVParserUTF16(char[] bytes, int off, int len, ObjectReaderAdapter objectReader) {
        super(objectReader);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
    }

    CSVParserUTF16(char[] bytes, int off, int len, Type[] types) {
        super(types);
        this.buf = bytes;
        this.off = off;
        this.end = off + len;
    }

    @Override
    boolean seekLine() throws IOException {
        if (this.buf == null && this.input != null) {
            this.buf = new char[262144];
            int cnt = this.input.read(this.buf);
            if (cnt == -1) {
                this.inputEnd = true;
                return false;
            }
            this.end = cnt;
            if (this.end > 3 && this.buf[0] == '\uffffffef' && this.buf[1] == '\uffffffbb' && this.buf[2] == '\uffffffbf') {
                this.lineNextStart = this.off = 3;
            }
        }
        for (int k = 0; k < 3; ++k) {
            this.lineTerminated = false;
            for (int i = this.off; i < this.end; ++i) {
                int n;
                char ch;
                if (i + 4 < this.end) {
                    char b0 = this.buf[i];
                    char b1 = this.buf[i + 1];
                    char b2 = this.buf[i + 2];
                    char b3 = this.buf[i + 3];
                    if (b0 > '\"' && b1 > '\"' && b2 > '\"' && b3 > '\"') {
                        this.lineSize += 4;
                        i += 3;
                        continue;
                    }
                }
                if ((ch = this.buf[i]) == '\"') {
                    ++this.lineSize;
                    if (!this.quote) {
                        this.quote = true;
                        continue;
                    }
                    n = i + 1;
                    if (n >= this.end) break;
                    if (this.buf[n] == '\"') {
                        ++this.lineSize;
                        ++i;
                        continue;
                    }
                    this.quote = false;
                    continue;
                }
                if (this.quote) {
                    ++this.lineSize;
                    continue;
                }
                if (ch == '\n') {
                    if (this.lineSize > 0 || (this.features & CSVParser.Feature.IgnoreEmptyLine.mask) == 0L) {
                        ++this.rowCount;
                    }
                    this.lineTerminated = true;
                    this.lineSize = 0;
                    this.lineEnd = i;
                    this.lineStart = this.lineNextStart;
                    this.lineNextStart = this.off = i + 1;
                    break;
                }
                if (ch == '\r') {
                    if (this.lineSize > 0 || (this.features & CSVParser.Feature.IgnoreEmptyLine.mask) == 0L) {
                        ++this.rowCount;
                    }
                    this.lineTerminated = true;
                    this.lineSize = 0;
                    this.lineEnd = i;
                    n = i + 1;
                    if (n >= this.end) break;
                    if (this.buf[n] == '\n') {
                        ++i;
                    }
                    this.lineStart = this.lineNextStart;
                    this.lineNextStart = this.off = i + 1;
                    break;
                }
                ++this.lineSize;
            }
            if (!this.lineTerminated) {
                if (this.input != null && !this.inputEnd) {
                    int cnt;
                    int len = this.end - this.off;
                    if (this.off > 0) {
                        if (len > 0) {
                            System.arraycopy(this.buf, this.off, this.buf, 0, len);
                        }
                        this.lineNextStart = 0;
                        this.lineStart = 0;
                        this.off = 0;
                        this.end = len;
                        this.quote = false;
                    }
                    if ((cnt = this.input.read(this.buf, this.end, this.buf.length - this.end)) == -1) {
                        this.inputEnd = true;
                        if (this.off == this.end) {
                            return false;
                        }
                    } else {
                        this.end += cnt;
                        continue;
                    }
                }
                this.lineStart = this.lineNextStart;
                this.lineEnd = this.end;
                ++this.rowCount;
                this.lineSize = 0;
                this.off = this.end;
            }
            this.lineTerminated = this.off == this.end;
            break;
        }
        return true;
    }

    Object readValue(char[] chars, int off, int len, Type type) {
        String str = new String(chars, off, len);
        return TypeUtils.cast((Object)str, (Type)type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object[] readLineValues(boolean strings) {
        try {
            if (this.inputEnd) {
                return null;
            }
            if (this.input == null && this.off >= this.end) {
                return null;
            }
            boolean result = this.seekLine();
            if (!result) {
                return null;
            }
        }
        catch (IOException e) {
            throw new JSONException("seekLine error", (Throwable)e);
        }
        Object[] values = null;
        ArrayList<Object> valueList = null;
        if (this.columns != null) {
            values = strings ? new String[this.columns.size()] : new Object[this.columns.size()];
        }
        boolean quote = false;
        int valueStart = this.lineStart;
        int valueSize = 0;
        int escapeCount = 0;
        int columnIndex = 0;
        for (int i = this.lineStart; i < this.lineEnd; ++i) {
            char ch;
            block36: {
                block39: {
                    ch = this.buf[i];
                    if (!quote) break block39;
                    if (ch == '\"') {
                        int n = i + 1;
                        if (n < this.lineEnd) {
                            char c1 = this.buf[n];
                            if (c1 == '\"') {
                                valueSize += 2;
                                ++escapeCount;
                                ++i;
                                continue;
                            }
                            if (c1 == ',') {
                                ++i;
                                ch = c1;
                            }
                            break block36;
                        } else if (n == this.lineEnd) {
                            break;
                        }
                        break block36;
                    } else {
                        ++valueSize;
                        continue;
                    }
                }
                if (ch == '\"') {
                    quote = true;
                    continue;
                }
            }
            if (ch == ',') {
                Object value;
                Type type;
                Type type2 = type = this.types != null && columnIndex < this.types.length ? this.types[columnIndex] : null;
                if (quote) {
                    if (escapeCount == 0) {
                        value = type == null || type == String.class || type == Object.class ? new String(this.buf, valueStart + 1, valueSize) : this.readValue(this.buf, valueStart + 1, valueSize, type);
                    } else {
                        char[] bytes = new char[valueSize - escapeCount];
                        int valueEnd = valueStart + valueSize;
                        int k = 0;
                        for (int j = valueStart + 1; j < valueEnd; ++j) {
                            char c = this.buf[j];
                            bytes[k++] = c;
                            if (c != '\"' || this.buf[j + 1] != '\"') continue;
                            ++j;
                        }
                        value = type == null || type == String.class || type == Object.class ? new String(bytes) : this.readValue(bytes, 0, bytes.length, type);
                    }
                } else {
                    value = type == null || type == String.class || type == Object.class ? new String(this.buf, valueStart, valueSize) : this.readValue(this.buf, valueStart, valueSize, type);
                }
                if (values != null) {
                    if (columnIndex < values.length) {
                        values[columnIndex] = value;
                    }
                } else {
                    if (valueList == null) {
                        valueList = new ArrayList();
                    }
                    valueList.add(value);
                }
                quote = false;
                valueStart = i + 1;
                valueSize = 0;
                escapeCount = 0;
                ++columnIndex;
                continue;
            }
            ++valueSize;
        }
        if (valueSize > 0) {
            Object value;
            Type type;
            Type type3 = type = this.types != null && columnIndex < this.types.length ? this.types[columnIndex] : null;
            if (quote) {
                if (escapeCount == 0) {
                    value = type == null || type == String.class || type == Object.class ? new String(this.buf, valueStart + 1, valueSize) : this.readValue(this.buf, valueStart + 1, valueSize, type);
                } else {
                    char[] bytes = new char[valueSize - escapeCount];
                    int valueEnd = this.lineEnd;
                    int k = 0;
                    for (int j = valueStart + 1; j < valueEnd; ++j) {
                        char c = this.buf[j];
                        bytes[k++] = c;
                        if (c != '\"' || this.buf[j + 1] != '\"') continue;
                        ++j;
                    }
                    value = type == null || type == String.class || type == Object.class ? new String(bytes) : this.readValue(bytes, 0, bytes.length, type);
                }
            } else {
                value = type == null || type == String.class || type == Object.class ? new String(this.buf, valueStart, valueSize) : this.readValue(this.buf, valueStart, valueSize, type);
            }
            if (values != null) {
                if (columnIndex < values.length) {
                    values[columnIndex] = value;
                }
            } else {
                if (valueList == null) {
                    valueList = new ArrayList<Object>();
                }
                valueList.add(value);
            }
        }
        if (values == null && valueList != null) {
            values = strings ? new String[valueList.size()] : new Object[valueList.size()];
            valueList.toArray(values);
        }
        return values;
    }

    @Override
    public void close() {
        if (this.input != null) {
            IOUtils.close((Closeable)this.input);
        }
    }
}

