/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import com.amashchenko.maven.plugin.gitflow.AbstractGitFlowMojo;
import com.amashchenko.maven.plugin.gitflow.GitFlowVersionInfo;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

@Mojo(name="feature-finish", aggregator=true)
public class GitFlowFeatureFinishMojo
extends AbstractGitFlowMojo {
    @Parameter(property="keepBranch", defaultValue="false")
    private boolean keepBranch = false;
    @Parameter(property="skipTestProject", defaultValue="false")
    private boolean skipTestProject = false;
    @Parameter(property="featureSquash", defaultValue="false")
    private boolean featureSquash = false;
    @Parameter(property="pushRemote", defaultValue="true")
    private boolean pushRemote;
    @Parameter(property="featureName")
    private String featureName;
    @Parameter(property="featureBranch")
    private String featureBranch;
    @Parameter(property="preFeatureFinishGoals")
    private String preFeatureFinishGoals;
    @Parameter(property="postFeatureFinishGoals")
    private String postFeatureFinishGoals;
    @Parameter(property="incrementVersionAtFinish", defaultValue="false")
    private boolean incrementVersionAtFinish;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfiguration(this.preFeatureFinishGoals, this.postFeatureFinishGoals);
        try {
            HashMap<String, String> properties;
            this.checkUncommittedChanges();
            String featureBranchName = null;
            if (this.settings.isInteractiveMode()) {
                featureBranchName = this.promptBranchName();
            } else if (StringUtils.isNotBlank((String)this.featureBranch)) {
                if (!this.featureBranch.startsWith(this.gitFlowConfig.getFeatureBranchPrefix())) {
                    throw new MojoFailureException("The featureBranch parameter doesn't start with feature branch prefix.");
                }
                if (!this.gitCheckBranchExists(this.featureBranch)) {
                    throw new MojoFailureException("Feature branch with name '" + this.featureBranch + "' doesn't exist. Cannot finish feature.");
                }
                featureBranchName = this.featureBranch;
            } else if (StringUtils.isNotBlank((String)this.featureName)) {
                String branch = this.gitFlowConfig.getFeatureBranchPrefix() + this.featureName;
                if (!this.gitCheckBranchExists(branch)) {
                    throw new MojoFailureException("Feature branch with name '" + branch + "' doesn't exist. Cannot finish feature.");
                }
                featureBranchName = branch;
            }
            if (StringUtils.isBlank((String)featureBranchName)) {
                throw new MojoFailureException("Feature branch name to finish is blank.");
            }
            if (this.fetchRemote) {
                this.gitFetchRemoteAndCompareCreate(featureBranchName);
                this.gitFetchRemoteAndCompareCreate(this.gitFlowConfig.getDevelopmentBranch());
            }
            this.gitCheckout(featureBranchName);
            if (!this.skipTestProject) {
                this.mvnCleanTest();
            }
            if (StringUtils.isNotBlank((String)this.preFeatureFinishGoals)) {
                this.mvnRun(this.preFeatureFinishGoals);
            }
            String featureVersion = this.getCurrentProjectVersion();
            String featName = featureBranchName.replaceFirst(this.gitFlowConfig.getFeatureBranchPrefix(), "");
            if (this.incrementVersionAtFinish) {
                String ver = featureVersion.replaceFirst("-" + featName, "");
                GitFlowVersionInfo nextVersionInfo = new GitFlowVersionInfo(ver, this.getVersionPolicy());
                ver = nextVersionInfo.nextSnapshotVersion();
                GitFlowVersionInfo featureVersionInfo = new GitFlowVersionInfo(ver, this.getVersionPolicy());
                featureVersion = featureVersionInfo.featureVersion(featName);
                this.mvnSetVersions(featureVersion);
                HashMap<String, String> properties2 = new HashMap<String, String>();
                properties2.put("version", featureVersion);
                properties2.put("featureName", featName);
                this.gitCommit(this.commitMessages.getFeatureFinishIncrementVersionMessage(), properties2);
            }
            String keptFeatureVersion = featureVersion;
            String version = keptFeatureVersion.replaceFirst("-" + featName, "");
            if (keptFeatureVersion.contains("-" + featName)) {
                this.mvnSetVersions(version);
                properties = new HashMap<String, String>();
                properties.put("version", version);
                properties.put("featureName", featName);
                this.gitCommit(this.commitMessages.getFeatureFinishMessage(), properties);
            }
            this.gitCheckout(this.gitFlowConfig.getDevelopmentBranch());
            if (this.featureSquash) {
                this.gitMergeSquash(featureBranchName);
                this.gitCommit(StringUtils.isBlank((String)this.commitMessages.getFeatureSquashMessage()) ? featureBranchName : this.commitMessages.getFeatureSquashMessage());
            } else {
                properties = new HashMap();
                properties.put("version", version);
                properties.put("featureName", featName);
                this.gitMergeNoff(featureBranchName, this.commitMessages.getFeatureFinishDevMergeMessage(), properties);
            }
            if (StringUtils.isNotBlank((String)this.postFeatureFinishGoals)) {
                this.mvnRun(this.postFeatureFinishGoals);
            }
            if (this.installProject) {
                this.mvnCleanInstall();
            }
            if (this.keepBranch) {
                this.gitCheckout(featureBranchName);
                this.mvnSetVersions(keptFeatureVersion);
                properties = new HashMap();
                properties.put("version", keptFeatureVersion);
                properties.put("featureName", featName);
                this.gitCommit(this.commitMessages.getUpdateFeatureBackMessage(), properties);
            }
            if (this.pushRemote) {
                this.gitPush(this.gitFlowConfig.getDevelopmentBranch(), false);
                if (this.keepBranch) {
                    this.gitPush(featureBranchName, false);
                } else {
                    this.gitPushDelete(featureBranchName);
                }
            }
            if (!this.keepBranch) {
                if (this.featureSquash) {
                    this.gitBranchDeleteForce(featureBranchName);
                } else {
                    this.gitBranchDelete(featureBranchName);
                }
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("feature-finish", (Throwable)e);
        }
    }

    private String promptBranchName() throws MojoFailureException, CommandLineException {
        String featureBranches = this.gitFindBranches(this.gitFlowConfig.getFeatureBranchPrefix(), false);
        if (StringUtils.isBlank((String)featureBranches)) {
            throw new MojoFailureException("There are no feature branches.");
        }
        String[] branches = featureBranches.split("\\r?\\n");
        return this.prompter.prompt(branches, this.gitCurrentBranch(), "Feature branches:", "Choose feature branch to finish");
    }
}

