/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import com.amashchenko.maven.plugin.gitflow.AbstractGitFlowMojo;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

@Mojo(name="feature-finish", aggregator=true)
public class GitFlowFeatureFinishMojo
extends AbstractGitFlowMojo {
    @Parameter(property="keepBranch", defaultValue="false")
    private boolean keepBranch = false;
    @Parameter(property="skipTestProject", defaultValue="false")
    private boolean skipTestProject = false;
    @Parameter(property="featureSquash", defaultValue="false")
    private boolean featureSquash = false;
    @Parameter(property="pushRemote", defaultValue="true")
    private boolean pushRemote;
    @Parameter(property="featureName")
    private String featureName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfiguration(new String[0]);
        try {
            this.checkUncommittedChanges();
            String featureBranchName = null;
            if (this.settings.isInteractiveMode()) {
                featureBranchName = this.promptBranchName();
            } else if (StringUtils.isNotBlank((String)this.featureName)) {
                String branch = this.gitFlowConfig.getFeatureBranchPrefix() + this.featureName;
                if (!this.gitCheckBranchExists(branch)) {
                    throw new MojoFailureException("Feature branch with name '" + branch + "' doesn't exist. Cannot finish feature.");
                }
                featureBranchName = branch;
            }
            if (StringUtils.isBlank((String)featureBranchName)) {
                throw new MojoFailureException("Feature branch name to finish is blank.");
            }
            if (this.fetchRemote) {
                this.gitFetchRemoteAndCompare(featureBranchName);
                this.gitFetchRemoteAndCompare(this.gitFlowConfig.getDevelopmentBranch());
            }
            if (!this.skipTestProject) {
                this.gitCheckout(featureBranchName);
                this.mvnCleanTest();
            }
            this.gitCheckout(this.gitFlowConfig.getDevelopmentBranch());
            if (this.featureSquash) {
                this.gitMergeSquash(featureBranchName);
                this.gitCommit(featureBranchName);
            } else {
                this.gitMergeNoff(featureBranchName);
            }
            String currentVersion = this.getCurrentProjectVersion();
            String featName = featureBranchName.replaceFirst(this.gitFlowConfig.getFeatureBranchPrefix(), "");
            if (currentVersion.contains("-" + featName)) {
                String version = currentVersion.replaceFirst("-" + featName, "");
                this.mvnSetVersions(version);
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("version", version);
                properties.put("featureName", featName);
                this.gitCommit(this.commitMessages.getFeatureFinishMessage(), properties);
            }
            if (this.installProject) {
                this.mvnCleanInstall();
            }
            if (!this.keepBranch) {
                if (this.featureSquash) {
                    this.gitBranchDeleteForce(featureBranchName);
                } else {
                    this.gitBranchDelete(featureBranchName);
                }
            }
            if (this.pushRemote) {
                this.gitPush(this.gitFlowConfig.getDevelopmentBranch(), false);
                if (!this.keepBranch) {
                    this.gitPushDelete(featureBranchName);
                }
            }
        }
        catch (CommandLineException e) {
            throw new MojoFailureException("feature-finish", (Throwable)e);
        }
    }

    private String promptBranchName() throws MojoFailureException, CommandLineException {
        String featureBranches = this.gitFindBranches(this.gitFlowConfig.getFeatureBranchPrefix(), false);
        if (StringUtils.isBlank((String)featureBranches)) {
            throw new MojoFailureException("There are no feature branches.");
        }
        String[] branches = featureBranches.split("\\r?\\n");
        ArrayList<String> numberedList = new ArrayList<String>();
        StringBuilder str = new StringBuilder("Feature branches:").append(LS);
        for (int i = 0; i < branches.length; ++i) {
            str.append(i + 1 + ". " + branches[i] + LS);
            numberedList.add(String.valueOf(i + 1));
        }
        str.append("Choose feature branch to finish");
        String featureNumber = null;
        try {
            while (StringUtils.isBlank(featureNumber)) {
                featureNumber = this.prompter.prompt(str.toString(), numberedList);
            }
        }
        catch (PrompterException e) {
            throw new MojoFailureException("feature-finish", (Throwable)e);
        }
        String featureBranchName = null;
        if (featureNumber != null) {
            int num = Integer.parseInt(featureNumber);
            featureBranchName = branches[num - 1];
        }
        return featureBranchName;
    }
}

