/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.Directive;
import com.amazon.ask.model.ui.Card;
import com.amazon.ask.model.ui.OutputSpeech;
import com.amazon.ask.model.ui.Reprompt;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Response {
    @JsonProperty(value="outputSpeech")
    private OutputSpeech outputSpeech = null;
    @JsonProperty(value="card")
    private Card card = null;
    @JsonProperty(value="reprompt")
    private Reprompt reprompt = null;
    @JsonProperty(value="directives")
    private List<Directive> directives = new ArrayList<Directive>();
    @JsonProperty(value="shouldEndSession")
    private Boolean shouldEndSession = null;

    public static Builder builder() {
        return new Builder();
    }

    private Response(Builder builder) {
        this.outputSpeech = builder.outputSpeech;
        this.card = builder.card;
        this.reprompt = builder.reprompt;
        this.directives = builder.directives;
        this.shouldEndSession = builder.shouldEndSession;
    }

    public OutputSpeech getOutputSpeech() {
        return this.outputSpeech;
    }

    public Card getCard() {
        return this.card;
    }

    public Reprompt getReprompt() {
        return this.reprompt;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Boolean getShouldEndSession() {
        return this.shouldEndSession;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response response = (Response)o;
        return Objects.equals(this.outputSpeech, response.outputSpeech) && Objects.equals(this.card, response.card) && Objects.equals(this.reprompt, response.reprompt) && Objects.equals(this.directives, response.directives) && Objects.equals(this.shouldEndSession, response.shouldEndSession);
    }

    public int hashCode() {
        return Objects.hash(this.outputSpeech, this.card, this.reprompt, this.directives, this.shouldEndSession);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Response {\n");
        sb.append("    outputSpeech: ").append(this.toIndentedString(this.outputSpeech)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    reprompt: ").append(this.toIndentedString(this.reprompt)).append("\n");
        sb.append("    directives: ").append(this.toIndentedString(this.directives)).append("\n");
        sb.append("    shouldEndSession: ").append(this.toIndentedString(this.shouldEndSession)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private OutputSpeech outputSpeech;
        private Card card;
        private Reprompt reprompt;
        private List<Directive> directives;
        private Boolean shouldEndSession;

        private Builder() {
        }

        @JsonProperty(value="outputSpeech")
        public Builder withOutputSpeech(OutputSpeech outputSpeech) {
            this.outputSpeech = outputSpeech;
            return this;
        }

        @JsonProperty(value="card")
        public Builder withCard(Card card) {
            this.card = card;
            return this;
        }

        @JsonProperty(value="reprompt")
        public Builder withReprompt(Reprompt reprompt) {
            this.reprompt = reprompt;
            return this;
        }

        @JsonProperty(value="directives")
        public Builder withDirectives(List<Directive> directives) {
            this.directives = directives;
            return this;
        }

        public Builder addDirectivesItem(Directive directivesItem) {
            if (this.directives == null) {
                this.directives = new ArrayList<Directive>();
            }
            this.directives.add(directivesItem);
            return this;
        }

        @JsonProperty(value="shouldEndSession")
        public Builder withShouldEndSession(Boolean shouldEndSession) {
            this.shouldEndSession = shouldEndSession;
            return this;
        }

        public Response build() {
            return new Response(this);
        }
    }
}

