/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.SlotConfirmationStatus;
import com.amazon.ask.model.slu.entityresolution.Resolutions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Slot {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="value")
    private String value = null;
    @JsonProperty(value="confirmationStatus")
    private SlotConfirmationStatus confirmationStatus = null;
    @JsonProperty(value="resolutions")
    private Resolutions resolutions = null;

    public static Builder builder() {
        return new Builder();
    }

    private Slot(Builder builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.confirmationStatus = builder.confirmationStatus;
        this.resolutions = builder.resolutions;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public SlotConfirmationStatus getConfirmationStatus() {
        return this.confirmationStatus;
    }

    public Resolutions getResolutions() {
        return this.resolutions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Slot slot = (Slot)o;
        return Objects.equals(this.name, slot.name) && Objects.equals(this.value, slot.value) && Objects.equals((Object)this.confirmationStatus, (Object)slot.confirmationStatus) && Objects.equals(this.resolutions, slot.resolutions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.value, this.confirmationStatus, this.resolutions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Slot {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    confirmationStatus: ").append(this.toIndentedString((Object)this.confirmationStatus)).append("\n");
        sb.append("    resolutions: ").append(this.toIndentedString(this.resolutions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String name;
        private String value;
        private SlotConfirmationStatus confirmationStatus;
        private Resolutions resolutions;

        private Builder() {
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="value")
        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="confirmationStatus")
        public Builder withConfirmationStatus(SlotConfirmationStatus confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
            return this;
        }

        @JsonProperty(value="resolutions")
        public Builder withResolutions(Resolutions resolutions) {
            this.resolutions = resolutions;
            return this;
        }

        public Slot build() {
            return new Slot(this);
        }
    }
}

